/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.CmmSavedMeeting;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.ConfNumberAutoCompleteTextView;
import com.zipow.videobox.view.ConfNumberMgr;
import com.zipow.videobox.view.VanityUrlAutoCompleteTextView;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class JoinConfView
extends LinearLayout
implements View.OnClickListener,
TextView.OnEditorActionListener {
    private static final int UI_MODE_MEETINGID = 0;
    private static final int UI_MODE_VANITYURL = 1;
    private ConfNumberAutoCompleteTextView mAutoCompleteConfNumber;
    private EditText mEdtScreenName;
    private Button mBtnJoin;
    private Button mBtnBack;
    private Button mBtnCancel;
    private TextView mTxtTitle;
    private CheckedTextView mChkNoAudio;
    private View mOptionNoAudio;
    private CheckedTextView mChkNoVideo;
    private View mOptionNoVideo;
    private VanityUrlAutoCompleteTextView mAutoCompleteEdtVanityUrl;
    private Button mBtnGotoVanityUrl;
    private Button mBtnGotoMeetingId;
    private View mPanelConfNumber;
    private View mPanelConfVanityUrl;
    private ImageButton mBtnConfNumberDropdown;
    private ImageButton mBtnConfVanityUrlDropdown;
    private String mUrlAction;
    private Listener mListener;
    private int mUIMode = 0;

    public JoinConfView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public JoinConfView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_join_conf, (ViewGroup)this);
        this.mTxtTitle = (TextView)this.findViewById(R.id.txtTitle);
        this.mAutoCompleteConfNumber = (ConfNumberAutoCompleteTextView)this.findViewById(R.id.edtConfNumber);
        this.mEdtScreenName = (EditText)this.findViewById(R.id.edtScreenName);
        this.mBtnJoin = (Button)this.findViewById(R.id.btnJoin);
        this.mBtnBack = (Button)this.findViewById(R.id.btnBack);
        this.mBtnCancel = (Button)this.findViewById(R.id.btnCancel);
        this.mChkNoAudio = (CheckedTextView)this.findViewById(R.id.chkNoAudio);
        this.mOptionNoAudio = this.findViewById(R.id.optionNoAudio);
        this.mChkNoVideo = (CheckedTextView)this.findViewById(R.id.chkNoVideo);
        this.mOptionNoVideo = this.findViewById(R.id.optionNoVideo);
        this.mBtnGotoVanityUrl = (Button)this.findViewById(R.id.btnGotoVanityUrl);
        this.mBtnGotoMeetingId = (Button)this.findViewById(R.id.btnGotoMeetingId);
        this.mAutoCompleteEdtVanityUrl = (VanityUrlAutoCompleteTextView)this.findViewById(R.id.edtConfVanityUrl);
        this.mPanelConfNumber = this.findViewById(R.id.panelConfNumber);
        this.mPanelConfVanityUrl = this.findViewById(R.id.panelConfVanityUrl);
        if (Build.VERSION.SDK_INT < 11) {
            this.mAutoCompleteConfNumber.setGravity(3);
            this.mEdtScreenName.setGravity(3);
        }
        if (!this.isInEditMode()) {
            String name = PTApp.getInstance().getMyName();
            if (!StringUtil.isEmptyOrNull((String)name)) {
                this.mEdtScreenName.setText((CharSequence)name);
            } else {
                this.mEdtScreenName.setText((CharSequence)PTApp.getInstance().getDeviceUserName());
            }
            if (this.mEdtScreenName.getText().toString().trim().length() > 0) {
                this.mAutoCompleteConfNumber.setImeOptions(2);
                this.mAutoCompleteConfNumber.setOnEditorActionListener(this);
            }
            this.mEdtScreenName.setImeOptions(2);
            this.mEdtScreenName.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        }
        if (this.mChkNoAudio != null) {
            this.mChkNoAudio.setChecked(false);
            this.mOptionNoAudio.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mChkNoVideo != null) {
            this.mChkNoVideo.setChecked(this.getNotOpenCamera());
            this.mOptionNoVideo.setOnClickListener((View.OnClickListener)this);
        }
        this.mBtnJoin.setEnabled(false);
        this.mBtnJoin.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnGotoVanityUrl.setOnClickListener((View.OnClickListener)this);
        this.mBtnGotoMeetingId.setOnClickListener((View.OnClickListener)this);
        this.mBtnConfNumberDropdown = (ImageButton)this.findViewById(R.id.btnConfNumberDropdown);
        this.mBtnConfVanityUrlDropdown = (ImageButton)this.findViewById(R.id.btnConfVanityUrlDropdown);
        this.mBtnConfNumberDropdown.setOnClickListener((View.OnClickListener)this);
        this.mBtnConfVanityUrlDropdown.setOnClickListener((View.OnClickListener)this);
        if (!this.hasMeetingJoinHistory()) {
            this.mBtnConfNumberDropdown.setVisibility(8);
            this.mBtnConfVanityUrlDropdown.setVisibility(8);
        }
        if (this.mBtnCancel != null) {
            this.mBtnCancel.setOnClickListener((View.OnClickListener)this);
        }
        TextWatcher watcher = new TextWatcher(){

            public void afterTextChanged(Editable s) {
                JoinConfView.this.validateInput();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        };
        this.mAutoCompleteConfNumber.addTextChangedListener(watcher);
        this.mEdtScreenName.addTextChangedListener(watcher);
        this.mAutoCompleteEdtVanityUrl.addTextChangedListener(watcher);
        if (UIMgr.isLargeMode(this.getContext())) {
            this.mBtnBack.setVisibility(8);
            if (this.mBtnCancel != null) {
                this.mBtnCancel.setVisibility(0);
            }
        }
    }

    private boolean getNotOpenCamera() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return false;
        }
        return settingHelper.neverStartVideoWhenJoinMeeting();
    }

    private boolean hasMeetingJoinHistory() {
        ArrayList<CmmSavedMeeting> meetings = ConfNumberMgr.loadConfUrlFromDB();
        return meetings != null && meetings.size() != 0;
    }

    private void validateInput() {
        boolean isValidate;
        boolean bl = isValidate = this.mEdtScreenName.getText().length() > 0;
        if (this.mUIMode == 0) {
            isValidate &= this.validateConfNumber() || !StringUtil.isEmptyOrNull((String)this.mUrlAction);
        } else if (this.mUIMode == 1) {
            isValidate &= this.validateConfVanityURL() || !StringUtil.isEmptyOrNull((String)this.mUrlAction);
        }
        this.mBtnJoin.setEnabled(isValidate);
    }

    private boolean validateConfNumber() {
        return this.mAutoCompleteConfNumber.getText().length() >= 11 && this.mAutoCompleteConfNumber.getText().length() <= 13 && this.getConfNumber() > 0L;
    }

    private boolean validateConfVanityURL() {
        return ConfNumberMgr.isValidVanityUrl(this.getVanityUrl());
    }

    public void setTitle(int title) {
        this.mTxtTitle.setText(title);
    }

    public long getConfNumber() {
        String number = this.mAutoCompleteConfNumber.getText().toString();
        if ((number = number.replaceAll("\\s", "")).length() > 0) {
            try {
                return Long.parseLong(number);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        return 0L;
    }

    public void setConfNumber(String number) {
        this.mAutoCompleteConfNumber.setText(number);
        this.validateInput();
    }

    public void setUrlAction(String urlAction) {
        this.mUrlAction = urlAction;
        this.validateInput();
    }

    public String getScreenName() {
        return this.mEdtScreenName.getText().toString().trim();
    }

    public String getVanityUrl() {
        return this.mAutoCompleteEdtVanityUrl.getText().toString().toLowerCase(CompatUtils.getLocalDefault());
    }

    public void setScreenName(String name) {
        this.mEdtScreenName.setText((CharSequence)name);
        this.validateInput();
    }

    public void setListener(Listener l) {
        this.mListener = l;
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.btnJoin) {
            this.onClickJoin();
        } else if (id2 == R.id.btnBack || id2 == R.id.btnCancel) {
            this.onClickBack();
        } else if (id2 == R.id.optionNoAudio) {
            this.onClickNoAudio();
        } else if (id2 == R.id.optionNoVideo) {
            this.onClickNoVideo();
        } else if (id2 == R.id.btnGotoMeetingId) {
            this.onClickGotoMeetingId();
        } else if (id2 == R.id.btnGotoVanityUrl) {
            this.onClickGotoVanityUrl();
        } else if (id2 == R.id.btnConfNumberDropdown) {
            this.onClickConfNumberDropdown();
        } else if (id2 == R.id.btnConfVanityUrlDropdown) {
            this.onClickConfVanityUrlDropdown();
        }
    }

    private void onClickConfVanityUrlDropdown() {
        this.showConfUrlChooseDialog();
    }

    private void onClickConfNumberDropdown() {
        this.showConfUrlChooseDialog();
    }

    private void showConfUrlChooseDialog() {
        ArrayList<CmmSavedMeeting> meetings = ConfNumberMgr.loadConfUrlFromDB();
        if (meetings == null || meetings.size() == 0) {
            return;
        }
        Context context = this.getContext();
        if (context instanceof ZMActivity) {
            JoinConfRecentMeetingsDialog dialog = JoinConfRecentMeetingsDialog.showAsDialog(((ZMActivity)context).getSupportFragmentManager(), meetings);
            dialog.setOnMeetingItemSelectListener(new JoinConfRecentMeetingsDialog.OnMeetingItemSelectListener(){

                @Override
                public void onMeetingItemSelect(CmmSavedMeeting meeting) {
                    if (meeting == null) {
                        return;
                    }
                    String id2 = meeting.getmConfID();
                    if (ConfNumberMgr.isValidVanityUrl(id2)) {
                        JoinConfView.this.mAutoCompleteEdtVanityUrl.setText(id2);
                        JoinConfView.this.upateUIMode(1);
                    } else {
                        JoinConfView.this.mAutoCompleteConfNumber.setText(id2);
                        JoinConfView.this.upateUIMode(0);
                    }
                    JoinConfView.this.mEdtScreenName.requestFocus();
                    JoinConfView.this.mEdtScreenName.setSelection(JoinConfView.this.mEdtScreenName.length());
                }

                @Override
                public void onClearMeetingHistory() {
                    PTApp.getInstance().clearSavedMeetingList();
                    JoinConfView.this.mBtnConfNumberDropdown.setVisibility(8);
                    JoinConfView.this.mBtnConfVanityUrlDropdown.setVisibility(8);
                    JoinConfView.this.mAutoCompleteConfNumber.clearHistory();
                    JoinConfView.this.mAutoCompleteEdtVanityUrl.clearHistory();
                }
            });
        }
    }

    private void onClickGotoMeetingId() {
        this.upateUIMode(0);
    }

    private void upateUIMode(int uiMode) {
        this.mUIMode = uiMode;
        switch (this.mUIMode) {
            case 0: {
                this.mBtnGotoMeetingId.setVisibility(8);
                this.mBtnGotoVanityUrl.setVisibility(0);
                this.mPanelConfNumber.setVisibility(0);
                this.mPanelConfVanityUrl.setVisibility(8);
                this.mAutoCompleteConfNumber.requestFocus();
                break;
            }
            case 1: {
                this.mBtnGotoMeetingId.setVisibility(0);
                this.mBtnGotoVanityUrl.setVisibility(8);
                this.mPanelConfNumber.setVisibility(8);
                this.mPanelConfVanityUrl.setVisibility(0);
                this.mAutoCompleteEdtVanityUrl.requestFocus();
                break;
            }
        }
        this.validateInput();
    }

    private void onClickGotoVanityUrl() {
        this.upateUIMode(1);
    }

    private void onClickJoin() {
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            String message = this.getResources().getString(R.string.zm_alert_network_disconnected);
            ZMActivity activity = (ZMActivity)this.getContext();
            CannotJoinDialog.show(activity, message);
            return;
        }
        if (this.mListener != null) {
            String vanityUrl;
            UIUtil.closeSoftKeyboard((Context)this.getContext(), (View)this);
            final String screenName = this.getScreenName();
            final long confNumber = this.mUIMode == 0 ? this.getConfNumber() : 0L;
            String string2 = vanityUrl = this.mUIMode == 1 ? this.getVanityUrl() : "";
            if (this.mUIMode == 0 && !this.validateConfNumber()) {
                this.mAutoCompleteConfNumber.requestFocus();
                return;
            }
            if (this.mUIMode == 1 && !this.validateConfVanityURL()) {
                this.mAutoCompleteEdtVanityUrl.requestFocus();
                return;
            }
            if (StringUtil.isEmptyOrNull((String)screenName)) {
                this.mEdtScreenName.requestFocus();
                return;
            }
            if (!PTApp.getInstance().isWebSignedOn()) {
                PTApp.getInstance().setDeviceUserName(screenName);
            } else {
                PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
                if (profile != null && !screenName.equals(profile.getUserName())) {
                    PTApp.getInstance().setDeviceUserName(screenName);
                }
            }
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (JoinConfView.this.mListener == null) {
                        return;
                    }
                    if (JoinConfView.this.mUrlAction != null && JoinConfView.this.mUrlAction.length() > 0) {
                        JoinConfView.this.mListener.onJoinByUrl(JoinConfView.this.mUrlAction, screenName);
                    } else {
                        boolean noAudio = false;
                        boolean noVideo = false;
                        if (JoinConfView.this.mChkNoAudio != null) {
                            noAudio = JoinConfView.this.mChkNoAudio.isChecked();
                        }
                        if (JoinConfView.this.mChkNoVideo != null) {
                            noVideo = JoinConfView.this.mChkNoVideo.isChecked();
                        }
                        JoinConfView.this.mListener.onJoinByNumber(confNumber, screenName, vanityUrl, noAudio, noVideo);
                    }
                }
            }, 100L);
        }
    }

    private void onClickNoAudio() {
        this.mChkNoAudio.setChecked(!this.mChkNoAudio.isChecked());
    }

    private void onClickNoVideo() {
        this.mChkNoVideo.setChecked(!this.mChkNoVideo.isChecked());
    }

    private void onClickBack() {
        if (this.mListener != null) {
            UIUtil.closeSoftKeyboard((Context)this.getContext(), (View)this);
            this.mListener.onBack();
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        switch (actionId) {
            case 2: {
                this.onClickJoin();
                return true;
            }
        }
        return false;
    }

    public static class JoinConfRecentMeetingsDialog
    extends ZMDialogFragment
    implements View.OnClickListener {
        private static final String ARGS_KEY_MEETINGLIST = "args_key_meetinglist";
        private OnMeetingItemSelectListener mListener;

        public static JoinConfRecentMeetingsDialog showAsDialog(@NonNull FragmentManager fm, @NonNull ArrayList<CmmSavedMeeting> meetingList) {
            JoinConfRecentMeetingsDialog f = new JoinConfRecentMeetingsDialog();
            Bundle args = new Bundle();
            args.putSerializable(ARGS_KEY_MEETINGLIST, meetingList);
            f.setArguments(args);
            f.show(fm, JoinConfRecentMeetingsDialog.class.getName());
            return f;
        }

        public void setOnMeetingItemSelectListener(OnMeetingItemSelectListener listener) {
            this.mListener = listener;
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setView(this.createContent()).setTheme(R.style.ZMDialog_Material_Transparent).create();
            return dialog;
        }

        private View createContent() {
            ArrayList meetingList = (ArrayList)this.getArguments().getSerializable(ARGS_KEY_MEETINGLIST);
            ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material);
            View view = View.inflate((Context)contextThemeWrapper, (int)R.layout.zm_recent_meeting, null);
            view.findViewById(R.id.btnClearHistory).setOnClickListener((View.OnClickListener)this);
            LinearLayout mPanel = (LinearLayout)view.findViewById(R.id.panelMeetingNo);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, UIUtil.dip2px((Context)this.getActivity(), (float)35.0f));
            for (final CmmSavedMeeting meeting : meetingList) {
                View item = View.inflate((Context)this.getActivity(), (int)R.layout.zm_recent_meeting_item, null);
                TextView txtId = (TextView)item.findViewById(R.id.txtId);
                TextView txtTopic = (TextView)item.findViewById(R.id.txtTopic);
                String id2 = meeting.getmConfID();
                if (ConfNumberMgr.isValidVanityUrl(id2)) {
                    txtTopic.setText((CharSequence)id2);
                    txtId.setVisibility(8);
                } else {
                    Editable et = Editable.Factory.getInstance().newEditable((CharSequence)id2);
                    ConfNumberMgr.formatText(et, 0);
                    txtId.setText((CharSequence)et.toString());
                    txtTopic.setText((CharSequence)meeting.getmConfTopic());
                }
                mPanel.addView(item, (ViewGroup.LayoutParams)lp);
                item.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (JoinConfRecentMeetingsDialog.this.mListener != null) {
                            JoinConfRecentMeetingsDialog.this.mListener.onMeetingItemSelect(meeting);
                        }
                        JoinConfRecentMeetingsDialog.this.dismiss();
                    }
                });
            }
            return view;
        }

        public void onClick(View v) {
            if (v == null) {
                return;
            }
            int id2 = v.getId();
            if (id2 == R.id.btnClearHistory) {
                if (this.mListener != null) {
                    this.mListener.onClearMeetingHistory();
                }
                this.dismiss();
            }
        }

        public void dismiss() {
            this.finishFragment(true);
        }

        public static interface OnMeetingItemSelectListener {
            public void onMeetingItemSelect(CmmSavedMeeting var1);

            public void onClearMeetingHistory();
        }
    }

    public static class CannotJoinDialog
    extends ZMDialogFragment {
        public CannotJoinDialog() {
            this.setCancelable(true);
        }

        public static CannotJoinDialog getAuthFailedDialog(ZMActivity zmActivity) {
            return (CannotJoinDialog)zmActivity.getSupportFragmentManager().findFragmentByTag(CannotJoinDialog.class.getName());
        }

        public static void show(ZMActivity zmActivity, final String message) {
            zmActivity.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

                public void run(IUIElement ui) {
                    CannotJoinDialog dialog = new CannotJoinDialog();
                    Bundle args = new Bundle();
                    args.putString("message", message);
                    dialog.setArguments(args);
                    dialog.show(((ZMActivity)ui).getSupportFragmentManager(), CannotJoinDialog.class.getName());
                }
            });
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            String message = this.getArguments().getString("message");
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_alert_join_failed).setMessage(message).setNegativeButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
        }
    }

    public static interface Listener {
        public void onJoinByNumber(long var1, String var3, String var4, boolean var5, boolean var6);

        public void onJoinByUrl(String var1, String var2);

        public void onBack();
    }
}

