/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ResolveInfo;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.Spinner;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.videomeetings.R;

public class InviteSpinner
extends Spinner {
    private AdapterView.OnItemSelectedListener mOnItemSelectedlistener;

    @SuppressLint(value={"NewApi"})
    public InviteSpinner(Context context, AttributeSet attrs, int defStyle, int mode) {
        super(context, attrs, defStyle, mode);
    }

    public InviteSpinner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public InviteSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @SuppressLint(value={"NewApi"})
    public InviteSpinner(Context context, int mode) {
        super(context, mode);
    }

    public InviteSpinner(Context context) {
        super(context);
    }

    public void setSelection(int position) {
        super.setSelection(position);
        if (this.mOnItemSelectedlistener != null) {
            this.mOnItemSelectedlistener.onItemSelected((AdapterView)this, null, position, 0L);
        }
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener listener) {
        super.setOnItemSelectedListener(listener);
        this.mOnItemSelectedlistener = listener;
    }

    public static class CalendarAppsAdapter
    extends BaseAdapter {
        private ZMActivity mActivity;
        private List<CalendarAppItem> mList = new ArrayList<CalendarAppItem>();

        public CalendarAppsAdapter(ZMActivity activity) {
            this.mActivity = activity;
        }

        public void reloadAll() {
            this.mList.clear();
            List emailApps = AndroidAppUtil.queryEmailActivities((Context)this.mActivity);
            for (ResolveInfo info : emailApps) {
                this.mList.add(new CalendarAppItem(info, 1));
            }
            List smsApps = AndroidAppUtil.querySMSActivities((Context)this.mActivity);
            for (ResolveInfo info : smsApps) {
                this.mList.add(new CalendarAppItem(info, 2));
            }
            this.mList.add(new CalendarAppItem(null, 3));
        }

        public int getCount() {
            return this.mList.size();
        }

        public Object getItem(int position) {
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public void addAll(CalendarAppItem ... items) {
            for (CalendarAppItem item : items) {
                this.addItem(item);
            }
        }

        public void addItem(CalendarAppItem item) {
            this.mList.add(item);
        }

        public void clear() {
            this.mList.clear();
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null || !"selected".equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mActivity, (int)R.layout.zm_spinner_selected_item, null);
                convertView.setTag((Object)"selected");
            }
            this.bindView(position, convertView);
            return convertView;
        }

        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            if (convertView == null || !"dropdown".equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mActivity, (int)R.layout.zm_menu_item, null);
                convertView.setTag((Object)"dropdown");
            }
            this.bindView(position, convertView);
            return convertView;
        }

        private void bindView(int position, View view) {
            ImageView imgIcon = (ImageView)view.findViewById(R.id.imgIcon);
            TextView txtLabel = (TextView)view.findViewById(R.id.txtLabel);
            CalendarAppItem item = (CalendarAppItem)this.getItem(position);
            if (item.app instanceof ResolveInfo) {
                ResolveInfo info = item.app;
                txtLabel.setText((CharSequence)AndroidAppUtil.getApplicationLabel((Context)this.mActivity, (ResolveInfo)info));
                imgIcon.setImageDrawable(AndroidAppUtil.getApplicationIcon((Context)this.mActivity, (ResolveInfo)info));
                imgIcon.setVisibility(0);
            } else if (item.type == 3) {
                txtLabel.setText((CharSequence)this.mActivity.getString(R.string.zm_lbl_copy_to_clipboard));
                imgIcon.setImageResource(R.drawable.zm_copy);
            }
        }
    }

    public static class CalendarAppItem {
        public static final int TYPE_CALENDAR = 0;
        public static final int TYPE_EMAIL = 1;
        public static final int TYPE_SMS = 2;
        public static final int TYPE_COPY_TO_CLIPBOARD = 3;
        public ResolveInfo app;
        public int type = 0;

        public CalendarAppItem(ResolveInfo app, int type) {
            this.app = app;
            this.type = type;
        }
    }
}

