/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.InviteLocalContactsFragment;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.ContactsMatchHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.view.InviteLocalContactsListAdapter;
import com.zipow.videobox.view.LocalContactItem;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.CountryCodeUtil;
import us.zoom.androidlib.util.StringUtil;

public class InviteLocalContactsListView
extends ListView
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener {
    private static final String TAG = InviteLocalContactsListView.class.getSimpleName();
    private InviteLocalContactsListAdapter mAdapter;
    private String mFilter;
    private InviteLocalContactsFragment mFragment;
    private static List<LocalContactItem> gCachedNoneZoomItems = null;

    public static void cacheItems(InviteLocalContactsListAdapter adapter) {
        if (adapter == null) {
            return;
        }
        gCachedNoneZoomItems = adapter.cache();
    }

    public static void clearCaches() {
        gCachedNoneZoomItems = null;
    }

    public static boolean fillAdapterFromCache(InviteLocalContactsListAdapter adapter) {
        if (adapter == null) {
            return false;
        }
        if (gCachedNoneZoomItems != null) {
            adapter.setItems(gCachedNoneZoomItems);
            return true;
        }
        return false;
    }

    public InviteLocalContactsListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public InviteLocalContactsListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public InviteLocalContactsListView(Context context) {
        super(context);
        this.initView();
    }

    public void setParentFragment(InviteLocalContactsFragment fragment) {
        this.mFragment = fragment;
    }

    private void initView() {
        this.mAdapter = new InviteLocalContactsListAdapter(this.getContext(), this);
        if (this.isInEditMode()) {
            this._editmode_loadAllItems(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
        this.setOnItemLongClickListener(this);
    }

    private void _editmode_loadAllItems(InviteLocalContactsListAdapter adapter) {
        String isoCountryCode = CountryCodeUtil.getIsoCountryCode((Context)VideoBoxApplication.getInstance());
        String phoneCountryCode = CountryCodeUtil.isoCountryCode2PhoneCountryCode((String)isoCountryCode);
        for (int i = 0; i < 10; ++i) {
            LocalContactItem item = new LocalContactItem();
            item.setContactId(i + 10000);
            item.setScreenName("Non-zoom User " + i);
            item.setSortKey(item.getScreenName());
            item.addPhoneNumber("+861390000000" + String.valueOf(i), null, phoneCountryCode);
            item.setIsZoomUser(false);
            adapter.addItem(item);
        }
    }

    private void loadAllItemsForInvite(InviteLocalContactsListAdapter adapter) {
        if (!PTApp.getInstance().isPhoneNumberRegistered()) {
            adapter.setAddrBookEnabled(false);
            this.setFooterDividersEnabled(false);
            return;
        }
        adapter.setAddrBookEnabled(true);
        this.setFooterDividersEnabled(true);
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        if (InviteLocalContactsListView.fillAdapterFromCache(adapter)) {
            return;
        }
        ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
        if (contactsHelper == null) {
            return;
        }
        ArrayList<String> matchedNumbers = new ArrayList<String>();
        contactsHelper.getMatchedPhoneNumbers(matchedNumbers);
        Collator usCollator = Collator.getInstance(Locale.US);
        Collections.sort(matchedNumbers, usCollator);
        ABContactsCache cache = ABContactsCache.getInstance();
        if (!cache.isCached() && !cache.reloadAllContacts()) {
            return;
        }
        LocalContactItem item = null;
        String myNumber = contactsHelper.getVerifiedPhoneNumber();
        for (int i = 0; i < cache.getCachedContactsCount(); ++i) {
            ABContactsCache.Contact contact = cache.getCachedContact(i);
            int contactId = contact.contactId;
            String name = contact.displayName;
            String number = contact.number;
            String normalizedNumber = contact.normalizedNumber;
            String sortKey = contact.sortKey;
            if (normalizedNumber.equals(myNumber)) continue;
            if (this.mFilter != null && this.mFilter.length() > 0) {
                String lowerFilter = this.mFilter.toLowerCase(CompatUtils.getLocalDefault());
                String lowerName = name.toLowerCase(CompatUtils.getLocalDefault());
                if (!lowerName.contains(lowerFilter)) continue;
            }
            if (StringUtil.isEmptyOrNull((String)number)) continue;
            if (item == null) {
                item = this.newListItem(contactId, name, number, normalizedNumber, null, null, sortKey, matchedNumbers, usCollator);
                continue;
            }
            if (item.getContactId() == contactId) {
                int idx = Collections.binarySearch(matchedNumbers, normalizedNumber, usCollator);
                if (idx < 0 && !item.getIsZoomUser() || idx >= 0 && item.getIsZoomUser()) {
                    item.addPhoneNumber(number, normalizedNumber);
                    continue;
                }
                if (idx < 0 || item.getIsZoomUser()) continue;
                item.clearPhoneNumbers();
                item.addPhoneNumber(number, normalizedNumber);
                item.setIsZoomUser(true);
                continue;
            }
            adapter.addItem(item);
            item = this.newListItem(contactId, name, number, normalizedNumber, null, null, sortKey, matchedNumbers, usCollator);
        }
        if (item != null) {
            adapter.addItem(item);
        }
        adapter.sort();
        InviteLocalContactsListView.cacheItems(adapter);
    }

    private LocalContactItem newListItem(int contactId, String name, String number, String normalizedNumber, String jid, String email, String sortKey, ArrayList<String> matchedNumbers, Collator collator) {
        LocalContactItem item = new LocalContactItem();
        item.setContactId(contactId);
        item.setScreenName(name);
        item.setSortKey(sortKey);
        item.setNeedIndicateZoomUser(false);
        item.setJid(jid);
        item.setAccoutEmail(email);
        normalizedNumber = item.addPhoneNumber(number, normalizedNumber);
        int idx = Collections.binarySearch(matchedNumbers, normalizedNumber, collator);
        item.setIsZoomUser(idx >= 0);
        return item;
    }

    public void reloadAllItems() {
        this.mAdapter.clear();
        String savedFilter = this.mFilter;
        this.mFilter = null;
        this.loadAllItemsForInvite(this.mAdapter);
        this.mFilter = savedFilter;
        if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
            this.mAdapter.filter(this.mFilter);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public int getContactsItemCount() {
        return this.mAdapter.getContactsItemCount();
    }

    public void notifyDataSetChanged() {
        this.notifyDataSetChanged(false);
    }

    public void notifyDataSetChanged(boolean disableLazyLoadAvatar) {
        if (disableLazyLoadAvatar) {
            this.mAdapter.setLazyLoadAvatarDisabled(true);
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    InviteLocalContactsListView.this.mAdapter.setLazyLoadAvatarDisabled(false);
                }
            }, 1000L);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object obj = this.getItemAtPosition(position);
        if (obj == null) {
            return;
        }
        if (obj instanceof LocalContactItem) {
            LocalContactItem item = (LocalContactItem)obj;
            this.onItemClick(item);
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        return false;
    }

    private void onItemClick(LocalContactItem item) {
    }

    public void showUserActions(LocalContactItem item) {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        this.mFragment.showNonZoomUserActions(item);
    }

    public void onRestoreInstanceState(Parcelable state) {
        Parcelable superState = null;
        if (state instanceof Bundle) {
            Bundle allState = (Bundle)state;
            superState = allState.getParcelable("InviteLocalContactsListView.superState");
            this.mFilter = allState.getString("InviteLocalContactsListView.mFilter");
        } else {
            superState = state;
        }
        super.onRestoreInstanceState(superState);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable("InviteLocalContactsListView.superState", superState);
        bundle.putString("InviteLocalContactsListView.mFilter", this.mFilter);
        return bundle;
    }

    public void setFilter(String filter) {
        this.mFilter = filter;
    }

    public String getFilter() {
        return this.mFilter;
    }

    public void filter(String filter) {
        String oldFilter = this.mFilter;
        this.mFilter = filter;
        if (oldFilter == null) {
            oldFilter = "";
        }
        if (filter == null) {
            filter = "";
        }
        filter = filter.toLowerCase(CompatUtils.getLocalDefault());
        if ((oldFilter = oldFilter.toLowerCase(CompatUtils.getLocalDefault())).equals(filter)) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)filter)) {
            if (StringUtil.isEmptyOrNull((String)oldFilter) || filter.contains(oldFilter)) {
                this.mAdapter.filter(filter);
                this.mAdapter.notifyDataSetChanged();
            } else {
                this.reloadAllItems();
            }
        } else {
            this.reloadAllItems();
        }
    }

    public int startABMatching() {
        Context context = this.getContext();
        if (context == null) {
            return 11;
        }
        if (!PTApp.getInstance().isWebSignedOn()) {
            return 9;
        }
        return ContactsMatchHelper.getInstance().matchAllNumbers(context);
    }

    public void onPhoneABMatchUpdated(long result) {
        InviteLocalContactsListView.clearCaches();
        this.reloadAllItems();
    }

    public void updateUnreadMessageCountBubble() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void onClickBtnEnableAddrBook() {
        this.mFragment.enableAddrBook();
    }
}

