/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import com.zipow.videobox.util.IMBuddyItemComparator;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.view.InviteBuddyItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.QuickSearchListView;

public class InviteBuddyListAdapter
extends QuickSearchListView.QuickSearchListDataAdapter {
    private static final int ITEM_TYPE_NORMAL = 0;
    private List<InviteBuddyItem> mItems = new ArrayList<InviteBuddyItem>();
    private Context mContext;
    private MemCache<String, Bitmap> mAvatarCache;
    private boolean mLazyLoadAvatarDisabled = false;

    public InviteBuddyListAdapter(Context context) {
        assert (context != null);
        this.mContext = context;
    }

    public void clear() {
        this.mItems.clear();
    }

    public void setAvatarMemCache(MemCache<String, Bitmap> avatarCache) {
        this.mAvatarCache = avatarCache;
    }

    public void addItem(InviteBuddyItem item) {
        assert (item != null);
        this.mItems.add(item);
    }

    public void updateItem(InviteBuddyItem item) {
        assert (item != null);
        int position = this.findItem(item.userId);
        if (position >= 0) {
            this.mItems.set(position, item);
        } else {
            this.mItems.add(item);
        }
    }

    public int findItem(String userId) {
        if (userId == null) {
            return -1;
        }
        for (int i = 0; i < this.mItems.size(); ++i) {
            InviteBuddyItem item = this.mItems.get(i);
            if (!userId.equals(item.userId)) continue;
            return i;
        }
        return -1;
    }

    public void removeItem(String userId) {
        int position = this.findItem(userId);
        if (position >= 0) {
            this.removeItemAt(position);
        }
    }

    public void removeItemAt(int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return;
        }
        this.mItems.remove(position);
    }

    public int getCount() {
        return this.mItems.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.mItems.get(position);
    }

    public InviteBuddyItem getItemByJid(String jid) {
        for (InviteBuddyItem item : this.mItems) {
            if (!item.userId.equals(jid)) continue;
            return item;
        }
        return null;
    }

    public long getItemId(int position) {
        InviteBuddyItem item = (InviteBuddyItem)this.getItem(position);
        return item.userId.hashCode();
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public int getViewTypeCount() {
        return 1;
    }

    public void filter(String filter) {
        for (int i = this.mItems.size() - 1; i >= 0; --i) {
            boolean emailAccepted;
            InviteBuddyItem item = this.mItems.get(i);
            boolean nameAccepted = item.screenName != null && item.screenName.toLowerCase(CompatUtils.getLocalDefault()).contains(filter);
            boolean bl = emailAccepted = item.email != null && item.email.toLowerCase(CompatUtils.getLocalDefault()).contains(filter);
            if (nameAccepted || emailAccepted) continue;
            this.mItems.remove(i);
        }
    }

    public void setLazyLoadAvatarDisabled(boolean disabled) {
        this.mLazyLoadAvatarDisabled = disabled;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        View view = null;
        int type = this.getItemViewType(position);
        switch (type) {
            case 0: {
                view = this.createNormalItemView(position, convertView, parent, this.mLazyLoadAvatarDisabled);
            }
        }
        return view;
    }

    private View createNormalItemView(int position, View convertView, ViewGroup parent, boolean disableLazyloadAvatar) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        InviteBuddyItem item = (InviteBuddyItem)this.getItem(position);
        return item.getView(this.mContext, convertView, this.mAvatarCache, disableLazyloadAvatar);
    }

    public void sort() {
        Collections.sort(this.mItems, new IMBuddyItemComparator(CompatUtils.getLocalDefault(), false, true));
    }

    public String getItemSortKey(Object item) {
        if (item instanceof InviteBuddyItem) {
            InviteBuddyItem inItem = (InviteBuddyItem)item;
            String key = inItem.sortKey;
            if (StringUtil.isEmptyOrNull((String)key)) {
                key = inItem.email;
            }
            if (key == null) {
                key = "";
            }
            return key;
        }
        return "";
    }
}

