/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.ZoomContact;
import com.zipow.videobox.ptapp.delegate.PTAppDelegation;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.IMBuddyItem;
import com.zipow.videobox.view.InviteBuddyItemView;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.androidlib.util.StringUtil;

public class InviteBuddyItem
extends IMBuddyItem {
    private static final long serialVersionUID = 6027100775492919094L;
    public boolean isChecked = false;
    public boolean isPresenceSupported = true;
    private IMAddrBookItem mAddrBookItem;

    public InviteBuddyItem() {
    }

    public InviteBuddyItem(PTAppProtos.BuddyItem protoItem) {
        super(protoItem, 0);
    }

    public InviteBuddyItem(ZoomContact contact) {
        this.isPresenceSupported = false;
        this.userId = contact.getUserID();
        this.screenName = StringUtil.formatPersonName((String)contact.getFirstName(), (String)contact.getLastName(), (String)PTApp.getInstance().getRegionCodeForNameFormating());
        this.email = contact.getEmail();
        this.avatar = PTAppDelegation.getInstance().getFavoriteMgr().getLocalPicturePath(this.email);
        if (this.screenName.equals(this.email)) {
            this.screenName = "";
        }
        this.sortKey = !StringUtil.isEmptyOrNull((String)this.screenName) ? SortUtil.getSortKey((String)this.screenName, (Locale)CompatUtils.getLocalDefault()) : SortUtil.getSortKey((String)this.email, (Locale)CompatUtils.getLocalDefault());
    }

    public InviteBuddyItem(IMAddrBookItem addrBookItem) {
        this.mAddrBookItem = addrBookItem;
        if (addrBookItem != null) {
            this.isPresenceSupported = true;
            this.userId = String.valueOf(addrBookItem.getJid());
            this.screenName = addrBookItem.getScreenName();
            this.sortKey = SortUtil.getSortKey((String)this.screenName, (Locale)CompatUtils.getLocalDefault());
            this.email = addrBookItem.getAccountEmail();
            this.avatar = addrBookItem.getAvatarPath();
        }
    }

    public boolean isAddrBookItem() {
        return this.mAddrBookItem != null;
    }

    public IMAddrBookItem getAddrBookItem() {
        return this.mAddrBookItem;
    }

    @Override
    public View getView(Context context, View convertView, MemCache<String, Bitmap> avatarCache, boolean disableLazyloadAvatar) {
        InviteBuddyItemView view = null;
        view = convertView instanceof InviteBuddyItemView ? (InviteBuddyItemView)convertView : new InviteBuddyItemView(context);
        this.bindView(view, avatarCache, disableLazyloadAvatar);
        return view;
    }

    private void bindView(InviteBuddyItemView view, MemCache<String, Bitmap> avatarCache, boolean disableLazyloadAvatar) {
        view.setBuddyListItem(this, avatarCache, disableLazyloadAvatar);
    }
}

