/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v4.view.accessibility.AccessibilityEventCompat;
import android.support.v4.view.accessibility.AccessibilityRecordCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TabHost;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.IMChatActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.IMAddrBookListFragment;
import com.zipow.videobox.fragment.IMBuddyListFragment;
import com.zipow.videobox.fragment.IMChatFragment;
import com.zipow.videobox.fragment.IMFavoriteListFragment;
import com.zipow.videobox.fragment.IMMeetingFragment;
import com.zipow.videobox.fragment.MMChatsListFragment;
import com.zipow.videobox.fragment.SettingFragment;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.ptapp.ZoomProductHelper;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.sip.CallHistoryMgr;
import com.zipow.videobox.sip.server.SipCallManager;
import com.zipow.videobox.util.LoginUtil;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.util.UpgradeUtil;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMBuddyItem;
import com.zipow.videobox.view.IMViewPagerAdapter;
import com.zipow.videobox.view.ScheduledMeetingItem;
import com.zipow.videobox.view.mm.MMContentFragment;
import com.zipow.videobox.view.sip.PhoneCallFragment;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMIgnoreKeyboardLayout;
import us.zoom.androidlib.widget.ZMKeyboardDetector;
import us.zoom.androidlib.widget.ZMViewPager;
import us.zoom.thirdparty.login.facebook.FBSessionStore;
import us.zoom.videomeetings.R;

public class IMView
extends ZMIgnoreKeyboardLayout
implements View.OnClickListener,
ZMKeyboardDetector.KeyboardListener {
    private static final String TAB_ADDRBOOK = "AddressBook";
    private static final String TAB_MEETING = "Meeting";
    private static final String TAB_BUDDYLIST = "BuddyList";
    private static final String TAB_CONTENT = "Content";
    private static final String TAB_SIP = "SIP";
    private static final String TAB_SETTINGS = "Settings";
    private static final String TAB_CHATS = "Chats";
    private static final String TAG = IMView.class.getSimpleName();
    private Button mBtnReturnToConf2;
    private AvatarView mAvatar;
    private ViewGroup mPanelChatParent;
    private ZMViewPager mViewPager;
    private TabHost mTabHost;
    private TextView mTxtUnreadThirdPartyIMMsgCountTabBubble;
    private TextView mTxtUnreadChatsCountTabBubble;
    private TextView mTxtUnreadCallsCountTabBubble;
    private IMViewPagerAdapter mPagerAdapter;
    private TextView mSettingsNoteBubble;
    private String mMyName;
    private boolean mIsLargeMode = false;
    private int mLoginType = 102;
    private int mLoginVendor = 0;
    private boolean mHasTabBuddyList = false;
    private boolean mbHasContacts = false;
    private boolean mIsSIPPWDialogCancelByUser = false;
    private static long g_lastAuthFailedTime = 0L;

    public IMView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public IMView(Context context) {
        super(context);
        this.initView();
    }

    @SuppressLint(value={"NewApi"})
    public void announceAccessibility(String content) {
        Context context = this.getContext();
        AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        if (accessibilityManager == null || !accessibilityManager.isEnabled()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.announceForAccessibility(content);
            return;
        }
        int eventType = 8;
        AccessibilityEvent event = AccessibilityEvent.obtain((int)8);
        event.getText().add(content);
        event.setEnabled(true);
        event.setClassName((CharSequence)((Object)((Object)this)).getClass().getName());
        event.setPackageName((CharSequence)context.getPackageName());
        AccessibilityRecordCompat record = AccessibilityEventCompat.asRecord((AccessibilityEvent)event);
        record.setSource((View)this);
        accessibilityManager.sendAccessibilityEvent(event);
    }

    public void onResume() {
        if (this.mbHasContacts != PTApp.getInstance().hasContacts()) {
            this.updateUI(true);
        }
    }

    private void initView() {
        this.setOrientation(1);
        this.mIsLargeMode = UIMgr.isLargeMode(this.getContext());
        if (this.mIsLargeMode) {
            View.inflate((Context)this.getContext(), (int)R.layout.zm_imview_large, (ViewGroup)this);
        } else {
            View.inflate((Context)this.getContext(), (int)R.layout.zm_imview, (ViewGroup)this);
        }
        if (this.mIsLargeMode) {
            FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            if (PTApp.getInstance().isCurrentLoginTypeSupportIM()) {
                IMBuddyListFragment buddylistFragment = new IMBuddyListFragment();
                ft.replace(R.id.panelBuddyList, (Fragment)buddylistFragment, IMBuddyListFragment.class.getName());
                ft.setTransition(0);
                ft.commit();
            } else {
                IMFavoriteListFragment favoritelistFragment = new IMFavoriteListFragment();
                ft.replace(R.id.panelBuddyList, (Fragment)favoritelistFragment, IMFavoriteListFragment.class.getName());
                ft.setTransition(0);
                ft.commit();
            }
            ViewGroup panelRight = (ViewGroup)this.findViewById(R.id.panelRight);
            this.mPanelChatParent = (ViewGroup)panelRight.findViewById(R.id.panelChatParent);
            this.mPanelChatParent.setVisibility(8);
            this.mBtnReturnToConf2 = (Button)panelRight.findViewById(R.id.btnReturnToConf2);
            IMMeetingFragment meetingFragment = new IMMeetingFragment();
            ft = fm.beginTransaction();
            ft.replace(R.id.panelMeeting, (Fragment)meetingFragment, IMMeetingFragment.class.getName());
            ft.setTransition(0);
            ft.commit();
        } else {
            this.mTabHost = (TabHost)this.findViewById(0x1020012);
            this.mTabHost.setup();
            TabHost.TabContentFactory contentFactory = new TabHost.TabContentFactory(){

                public View createTabContent(String tag) {
                    return new View(IMView.this.getContext());
                }
            };
            int countTabs = 0;
            String defTab = null;
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (ResourcesUtil.getBoolean((View)this, (int)R.bool.zm_config_use_4_pies_meeting_tab, (boolean)false)) {
                this.mTabHost.addTab(this.mTabHost.newTabSpec(TAB_MEETING).setIndicator(this.createMeetingTabView()).setContent(contentFactory));
                ++countTabs;
                defTab = TAB_MEETING;
            } else {
                this.mTabHost.addTab(this.mTabHost.newTabSpec(TAB_CHATS).setIndicator(this.createChatsTabView()).setContent(contentFactory));
                ++countTabs;
                defTab = TAB_CHATS;
            }
            if (SipCallManager.getInstance().isSipCallEnabled()) {
                this.mTabHost.addTab(this.mTabHost.newTabSpec(TAB_SIP).setIndicator(this.createSipTabView()).setContent(contentFactory));
                ++countTabs;
            }
            this.mbHasContacts = false;
            if (PTApp.getInstance().hasContacts()) {
                this.mTabHost.addTab(this.mTabHost.newTabSpec(TAB_ADDRBOOK).setIndicator(this.createAddrBookTabView()).setContent(contentFactory));
                ++countTabs;
                this.mbHasContacts = true;
            }
            if (messenger != null) {
                boolean isContentEnable;
                boolean isE2E = messenger.e2eGetMyOption() == 2;
                boolean isIMDisable = messenger.imChatGetOption() == 2;
                MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
                boolean bl = isContentEnable = mgr != null && mgr.getFileContentMgmtOption() == 1;
                if (!isE2E && isContentEnable && !isIMDisable && !PTApp.getInstance().isFileTransferDisabled()) {
                    this.mTabHost.addTab(this.mTabHost.newTabSpec(TAB_CONTENT).setIndicator(this.createContentTabView()).setContent(contentFactory));
                    ++countTabs;
                }
            }
            this.mTabHost.addTab(this.mTabHost.newTabSpec(TAB_SETTINGS).setIndicator(this.createSettingsTabView()).setContent(contentFactory));
            ++countTabs;
            this.mViewPager = (ZMViewPager)this.findViewById(R.id.viewpager);
            this.mPagerAdapter = new IMViewPagerAdapter(((ZMActivity)this.getContext()).getSupportFragmentManager());
            this.mViewPager.setAdapter((PagerAdapter)this.mPagerAdapter);
            this.mViewPager.setOffscreenPageLimit(4);
            this.showTab(defTab);
            if (countTabs <= 1) {
                this.mTabHost.setVisibility(8);
            }
            this.mTabHost.setOnTabChangedListener(new TabHost.OnTabChangeListener(){

                public void onTabChanged(String tabId) {
                    ZMActivity activity = (ZMActivity)IMView.this.getContext();
                    if (activity != null && activity.isActive()) {
                        IMView.this.mViewPager.setCurrentItem(IMView.this.mTabHost.getCurrentTab(), true);
                        if (IMView.this.mTabHost.getCurrentTabView() != null) {
                            String content = IMView.this.getResources().getString(R.string.zm_description_tab_selected, new Object[]{IMView.this.mTabHost.getCurrentTabView().getContentDescription()});
                            IMView.this.announceAccessibility(content);
                        }
                    }
                }
            });
            this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

                public void onPageSelected(int position) {
                    Fragment fragment;
                    IMView.this.mTabHost.setCurrentTab(position);
                    UIUtil.closeSoftKeyboard((Context)IMView.this.getContext(), (View)IMView.this);
                    if (IMView.TAB_SETTINGS.equals(IMView.this.mTabHost.getCurrentTabTag())) {
                        if (SettingFragment.needShowNewTipsOnSettingsTab(IMView.this.getContext())) {
                            IMView.this.clearSettingsNoteBubble();
                        }
                    } else if (IMView.TAB_ADDRBOOK.equals(IMView.this.mTabHost.getCurrentTabTag())) {
                        boolean first = PreferenceUtil.readBooleanValue("first_open_contacts", true);
                        if (first) {
                            IMView.this.onFirstOpenContacts();
                        }
                        IMView.this.onSelectContactsPage();
                    } else if (IMView.TAB_SIP.equals(IMView.this.mTabHost.getCurrentTabTag())) {
                        IMView.this.updateUnreadCallsCountTabBubble();
                        IMView.this.mIsSIPPWDialogCancelByUser = false;
                        IMView.this.checkSIPLoginError();
                    }
                    if ((fragment = IMView.this.mPagerAdapter.getItem(position)) != null && fragment instanceof OnFragmentShowListener) {
                        ((OnFragmentShowListener)fragment).onShow();
                    }
                }
            });
        }
        if (this.mAvatar != null) {
            this.mAvatar.setOnClickListener(this);
        }
        if (this.mBtnReturnToConf2 != null) {
            this.mBtnReturnToConf2.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mPanelChatParent != null) {
            this.mPanelChatParent.setOnClickListener((View.OnClickListener)this);
        }
        if (!this.isInEditMode()) {
            IMHelper imHelper = PTApp.getInstance().getIMHelper();
            if (imHelper != null) {
                this.updateLocalStatus(imHelper.getIMLocalStatus());
            }
            this.updateButtons();
            this.showMyInfo();
        }
        this.mLoginType = PTApp.getInstance().getPTLoginType();
        this.mLoginVendor = this.getCurrentVendor();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (this.mPagerAdapter != null) {
            this.mPagerAdapter.onConfigurationChanged(newConfig);
        }
    }

    private View createTabView(String text, int iconResId) {
        View view = View.inflate((Context)this.getContext(), (int)R.layout.zm_tab_indicator, null);
        TextView txtTitle = (TextView)view.findViewById(R.id.title);
        ImageView icon = (ImageView)view.findViewById(R.id.icon);
        txtTitle.setText((CharSequence)text);
        if (iconResId > 0) {
            icon.setImageResource(iconResId);
        } else {
            icon.setVisibility(8);
        }
        return view;
    }

    private View createChatsTabView() {
        String label = this.getResources().getString(R.string.zm_tab_chats);
        String description = this.getResources().getString(R.string.zm_description_tab_chats);
        int iconRes = R.drawable.zm_icon_im;
        if (!PTApp.getInstance().hasZoomMessenger() || PTApp.getInstance().getZoomMessenger().imChatGetOption() == 2) {
            label = this.getResources().getString(R.string.zm_tab_chats_no_messenger);
            description = this.getResources().getString(R.string.zm_description_tab_chats_no_messenger);
            iconRes = R.drawable.zm_icon_meeting;
        }
        View view = this.createTabView(label, iconRes);
        view.setContentDescription((CharSequence)description);
        this.mTxtUnreadChatsCountTabBubble = (TextView)view.findViewById(R.id.txtNoteBubble);
        return view;
    }

    private View createAddrBookTabView() {
        View view;
        if (PTApp.getInstance().hasZoomMessenger()) {
            view = this.createTabView(this.getResources().getString(R.string.zm_tab_addrbook), R.drawable.zm_icon_contacts);
            view.setContentDescription((CharSequence)this.getResources().getString(R.string.zm_description_tab_addrbook));
        } else {
            view = this.createBuddyListTabView();
        }
        return view;
    }

    private View createContentTabView() {
        View view = this.createTabView(this.getResources().getString(R.string.zm_tab_content), R.drawable.zm_icon_contents);
        view.setContentDescription((CharSequence)this.getResources().getString(R.string.zm_description_tab_content));
        return view;
    }

    private View createSipTabView() {
        View view = this.createTabView(this.getResources().getString(R.string.zm_tab_sip_14480), R.drawable.zm_icon_sip);
        view.setContentDescription((CharSequence)this.getResources().getString(R.string.zm_description_tab_sip_14480));
        this.mTxtUnreadCallsCountTabBubble = (TextView)view.findViewById(R.id.txtNoteBubble);
        return view;
    }

    private View createMeetingTabView() {
        View view = this.createTabView(this.getResources().getString(R.string.zm_tab_meeting), R.drawable.zm_icon_meeting);
        view.setContentDescription((CharSequence)this.getResources().getString(R.string.zm_description_tab_meeting));
        return view;
    }

    private View createBuddyListTabView() {
        int strId = R.string.zm_tab_buddylist_google;
        int iconId = 0;
        String contentDescription = "";
        if (PTApp.getInstance().getPTLoginType() == 2) {
            strId = R.string.zm_tab_buddylist_google;
            iconId = R.drawable.zm_tab_icon_google;
            contentDescription = this.getResources().getString(R.string.zm_description_tab_buddylist_google);
        } else if (PTApp.getInstance().getPTLoginType() == 0) {
            strId = R.string.zm_tab_buddylist_facebook;
            iconId = R.drawable.zm_tab_icon_fb;
            contentDescription = this.getResources().getString(R.string.zm_description_tab_buddylist_facebook);
        }
        View view = this.createTabView(this.getResources().getString(strId), iconId);
        this.mTxtUnreadThirdPartyIMMsgCountTabBubble = (TextView)view.findViewById(R.id.txtNoteBubble);
        view.setContentDescription((CharSequence)contentDescription);
        return view;
    }

    private View createFavoriteContactsTabView() {
        View view = this.createTabView(this.getResources().getString(R.string.zm_tab_favorite_contacts), R.drawable.zm_icon_contacts);
        view.setContentDescription((CharSequence)this.getResources().getString(R.string.zm_description_tab_favorite_contacts));
        return view;
    }

    private View createSettingsTabView() {
        View view = this.createTabView(this.getResources().getString(R.string.zm_title_setting), R.drawable.zm_icon_settings);
        this.mSettingsNoteBubble = (TextView)view.findViewById(R.id.txtNoteBubble);
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.zm_ic_indicator_new);
        this.mSettingsNoteBubble.setBackgroundDrawable(drawable2);
        this.mSettingsNoteBubble.setText((CharSequence)"");
        this.mSettingsNoteBubble.setWidth(drawable2.getIntrinsicWidth());
        this.mSettingsNoteBubble.setHeight(drawable2.getIntrinsicHeight());
        this.updateSettingsNoteBubble();
        view.setContentDescription((CharSequence)this.getResources().getString(R.string.zm_description_tab_setting));
        return view;
    }

    public void updateSettingsNoteBubble() {
        if (this.mSettingsNoteBubble == null) {
            return;
        }
        if (SettingFragment.needShowNewTipsOnSettingsTab(this.getContext())) {
            this.mSettingsNoteBubble.setVisibility(0);
        } else {
            this.mSettingsNoteBubble.setVisibility(8);
        }
    }

    public void onSipCallEvent(int event, String callId) {
        Fragment fragment;
        this.updateUnreadCallsCountTabBubble();
        if (this.mPagerAdapter != null && (fragment = this.mPagerAdapter.getItem(this.mViewPager.getCurrentItem())) instanceof PhoneCallFragment && !this.mIsSIPPWDialogCancelByUser) {
            this.checkSIPLoginError();
        }
    }

    private void checkSIPLoginError() {
        if (SipCallManager.PasswordInputDialog.getPasswordInputDialog((FragmentActivity)this.getContext()) != null) {
            return;
        }
        SipCallManager mgr = SipCallManager.getInstance();
        if (!mgr.needIputPassword()) {
            return;
        }
        if (!PTApp.getInstance().isWebSignedOn()) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood() && messenger.isForceSignout()) {
            return;
        }
        SipCallManager.PasswordInputDialog.show((ZMActivity)this.getContext()).setOnCancelClick(new SipCallManager.PasswordInputDialog.OnCancelClickListener(){

            @Override
            public void OnCancelClick() {
                IMView.this.mIsSIPPWDialogCancelByUser = true;
            }
        });
    }

    private void clearSettingsNoteBubble() {
        SettingFragment.saveNewTipsOnSettingsTabCleared();
        this.updateSettingsNoteBubble();
    }

    public boolean isLargeMode() {
        return this.mIsLargeMode;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setIgnoreKeyboardOpen(true);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void onKeyboardOpen() {
        IMBuddyListFragment buddyListFragment = this.getBuddyListFragment();
        IMFavoriteListFragment favListFragment = this.getFavoriteListFragment();
        IMAddrBookListFragment addrBookFragment = this.getAddrBookListFragment();
        MMChatsListFragment chatsListFragment = this.getChatsListFragment();
        PhoneCallFragment phoneCallFragment = this.getRecentCallFragment();
        if (buddyListFragment != null) {
            buddyListFragment.onKeyboardOpen();
        }
        if (favListFragment != null) {
            favListFragment.onKeyboardOpen();
        }
        if (addrBookFragment != null) {
            addrBookFragment.onKeyboardOpen();
        }
        if (chatsListFragment != null) {
            chatsListFragment.onKeyboardOpen();
        }
        if (phoneCallFragment != null) {
            phoneCallFragment.onKeyboardOpen();
        }
    }

    public void onKeyboardClosed() {
        IMBuddyListFragment buddyListFragment = this.getBuddyListFragment();
        IMFavoriteListFragment favListFragment = this.getFavoriteListFragment();
        IMAddrBookListFragment addrBookFragment = this.getAddrBookListFragment();
        MMChatsListFragment chatsListFragment = this.getChatsListFragment();
        PhoneCallFragment phoneCallFragment = this.getRecentCallFragment();
        if (buddyListFragment != null) {
            buddyListFragment.onKeyboardClosed();
        }
        if (favListFragment != null) {
            favListFragment.onKeyboardClosed();
        }
        if (addrBookFragment != null) {
            addrBookFragment.onKeyboardClosed();
        }
        if (chatsListFragment != null) {
            chatsListFragment.onKeyboardClosed();
        }
        if (phoneCallFragment != null) {
            phoneCallFragment.onKeyboardClosed();
        }
    }

    public boolean onBackPressed() {
        IMAddrBookListFragment addrBookFragment = this.getAddrBookListFragment();
        if (addrBookFragment != null && addrBookFragment.handleBackPressed()) {
            return true;
        }
        PhoneCallFragment phoneCallFragment = this.getRecentCallFragment();
        return phoneCallFragment != null && phoneCallFragment.handleBackPressed();
    }

    private void updateButtons() {
        if (PTApp.getInstance().hasActiveCall() && VideoBoxApplication.getInstance().isConfProcessRunning()) {
            if (this.mBtnReturnToConf2 != null) {
                this.mBtnReturnToConf2.setVisibility(0);
            }
        } else if (this.mBtnReturnToConf2 != null) {
            this.mBtnReturnToConf2.setVisibility(8);
        }
        this.updateUnreadThirdPartyIMMsgCountTabBubble();
        this.updateUnreadChatsCountTabBubble();
        this.updateUnreadCallsCountTabBubble();
    }

    private void updateUnreadThirdPartyIMMsgCountTabBubble() {
        if (this.mTxtUnreadThirdPartyIMMsgCountTabBubble == null) {
            return;
        }
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper != null) {
            int count = imHelper.getUnreadMsgCount();
            if (count == 0) {
                this.mTxtUnreadThirdPartyIMMsgCountTabBubble.setVisibility(8);
            } else {
                this.mTxtUnreadThirdPartyIMMsgCountTabBubble.setText((CharSequence)(count < 100 ? String.valueOf(count) : "99+"));
                this.mTxtUnreadThirdPartyIMMsgCountTabBubble.setVisibility(0);
            }
        }
    }

    private void updateUnreadChatsCountTabBubble() {
        if (this.mTxtUnreadChatsCountTabBubble == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && messenger.imChatGetOption() != 2) {
            int count = messenger.getTotalUnreadMessageCount() + messenger.getUnreadRequestCount() + messenger.getTotalMarkedUnreadMsgCount();
            if (count == 0) {
                this.mTxtUnreadChatsCountTabBubble.setVisibility(8);
            } else {
                this.mTxtUnreadChatsCountTabBubble.setText((CharSequence)(count < 100 ? String.valueOf(count) : "99+"));
                this.mTxtUnreadChatsCountTabBubble.setVisibility(0);
            }
        }
    }

    private void updateUnreadCallsCountTabBubble() {
        if (this.mTxtUnreadCallsCountTabBubble == null) {
            return;
        }
        SipCallManager sipCallManager = SipCallManager.getInstance();
        if (sipCallManager.needIputPassword()) {
            this.mTxtUnreadCallsCountTabBubble.setText((CharSequence)"!");
            this.mTxtUnreadCallsCountTabBubble.setVisibility(0);
            return;
        }
        CallHistoryMgr mgr = PTApp.getInstance().getCallHistoryMgr();
        if (mgr == null) {
            return;
        }
        if (!TAB_SIP.equals(this.mTabHost.getCurrentTabTag())) {
            int count = mgr.getMissedCallInCount();
            if (count == 0) {
                this.mTxtUnreadCallsCountTabBubble.setVisibility(8);
            } else {
                this.mTxtUnreadCallsCountTabBubble.setText((CharSequence)(count < 100 ? String.valueOf(count) : "99+"));
                this.mTxtUnreadCallsCountTabBubble.setVisibility(0);
            }
        } else {
            mgr.clearMissedCallIn();
            this.mTxtUnreadCallsCountTabBubble.setVisibility(8);
        }
    }

    private void updateLocalStatus() {
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper != null) {
            this.updateLocalStatus(imHelper.getIMLocalStatus());
        }
    }

    private void updateLocalStatus(int status) {
    }

    public void showBuddyList() {
        if (!UIMgr.isLargeMode(this.getContext())) {
            if (this.mHasTabBuddyList) {
                this.showTab(TAB_BUDDYLIST);
            } else {
                this.showContacts();
            }
        }
    }

    public void showChatsList() {
        this.showTab(TAB_CHATS);
    }

    public void showContacts() {
        this.showTab(TAB_ADDRBOOK);
    }

    public void showChatUI(IMBuddyItem buddyItem) {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return;
        }
        if (this.mIsLargeMode) {
            FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
            IMChatFragment chatFragment = this.getChatFragment();
            if ((buddyItem == null || buddyItem.userId == null) && chatFragment != null) {
                this.mPanelChatParent.setVisibility(8);
                try {
                    fm.beginTransaction().remove((Fragment)chatFragment).commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (chatFragment != null && buddyItem.userId.equals(chatFragment.getChatToUserId())) {
                return;
            }
            this.mPanelChatParent.setVisibility(0);
            chatFragment = new IMChatFragment();
            Bundle args = new Bundle();
            args.putSerializable("buddyItem", (Serializable)buddyItem);
            args.putString("myName", this.mMyName);
            chatFragment.setArguments(args);
            FragmentTransaction ft = fm.beginTransaction();
            ft.replace(R.id.panelChat, (Fragment)chatFragment, IMChatFragment.class.getName());
            ft.setTransition(4099);
            ft.commit();
        } else {
            if (buddyItem == null) {
                return;
            }
            Intent i = new Intent(this.getContext(), IMChatActivity.class);
            i.setFlags(131072);
            i.putExtra("buddyItem", (Serializable)buddyItem);
            i.putExtra("myName", profile.getUserName());
            ((ZMActivity)this.getContext()).startActivityForResult(i, 100);
        }
    }

    public IMChatFragment getChatFragment() {
        IMChatFragment f = (IMChatFragment)((ZMActivity)this.getContext()).getSupportFragmentManager().findFragmentByTag(IMChatFragment.class.getName());
        return f;
    }

    public IMBuddyListFragment getBuddyListFragment() {
        IMBuddyListFragment buddyListFragment;
        if (this.mViewPager != null && (buddyListFragment = (IMBuddyListFragment)this.mPagerAdapter.getItemById(3)) != null && buddyListFragment.getView() != null) {
            return buddyListFragment;
        }
        buddyListFragment = (IMBuddyListFragment)((ZMActivity)this.getContext()).getSupportFragmentManager().findFragmentByTag(IMBuddyListFragment.class.getName());
        return buddyListFragment;
    }

    public IMMeetingFragment getMeetingFragment() {
        IMMeetingFragment meetingFragment;
        if (this.mViewPager != null && (meetingFragment = (IMMeetingFragment)this.mPagerAdapter.getItemById(2)) != null && meetingFragment.getView() != null) {
            return meetingFragment;
        }
        meetingFragment = (IMMeetingFragment)((ZMActivity)this.getContext()).getSupportFragmentManager().findFragmentByTag(IMMeetingFragment.class.getName());
        return meetingFragment;
    }

    public IMFavoriteListFragment getFavoriteListFragment() {
        IMFavoriteListFragment favoriteListFragment;
        if (this.mViewPager != null && (favoriteListFragment = (IMFavoriteListFragment)this.mPagerAdapter.getItemById(5)) != null && favoriteListFragment.getView() != null) {
            return favoriteListFragment;
        }
        favoriteListFragment = (IMFavoriteListFragment)((ZMActivity)this.getContext()).getSupportFragmentManager().findFragmentByTag(IMFavoriteListFragment.class.getName());
        return favoriteListFragment;
    }

    public SettingFragment getSettingFragment() {
        SettingFragment fragment;
        if (this.mViewPager != null && (fragment = (SettingFragment)this.mPagerAdapter.getItemById(4)) != null && fragment.getView() != null) {
            return fragment;
        }
        return null;
    }

    public IMAddrBookListFragment getAddrBookListFragment() {
        IMAddrBookListFragment fragment;
        if (this.mViewPager != null && (fragment = (IMAddrBookListFragment)this.mPagerAdapter.getItemById(0)) != null && fragment.getView() != null) {
            return fragment;
        }
        fragment = (IMAddrBookListFragment)((ZMActivity)this.getContext()).getSupportFragmentManager().findFragmentByTag(IMAddrBookListFragment.class.getName());
        return fragment;
    }

    public MMChatsListFragment getChatsListFragment() {
        MMChatsListFragment fragment;
        if (this.mViewPager != null && (fragment = (MMChatsListFragment)this.mPagerAdapter.getItemById(6)) != null && fragment.getView() != null) {
            return fragment;
        }
        fragment = (MMChatsListFragment)((ZMActivity)this.getContext()).getSupportFragmentManager().findFragmentByTag(MMChatsListFragment.class.getName());
        return fragment;
    }

    public PhoneCallFragment getRecentCallFragment() {
        PhoneCallFragment fragment;
        if (this.mViewPager != null && (fragment = (PhoneCallFragment)this.mPagerAdapter.getItemById(8)) != null && fragment.getView() != null) {
            return fragment;
        }
        fragment = (PhoneCallFragment)((ZMActivity)this.getContext()).getSupportFragmentManager().findFragmentByTag(PhoneCallFragment.class.getName());
        return fragment;
    }

    public MMContentFragment getContentFragment() {
        MMContentFragment fragment;
        if (this.mViewPager != null && (fragment = (MMContentFragment)this.mPagerAdapter.getItemById(7)) != null && fragment.getView() != null) {
            return fragment;
        }
        fragment = (MMContentFragment)((ZMActivity)this.getContext()).getSupportFragmentManager().findFragmentByTag(MMContentFragment.class.getName());
        return fragment;
    }

    public void updateUI() {
        this.updateUI(false);
    }

    public void updateUI(boolean forceReloadView) {
        int curVendor = this.getCurrentVendor();
        if (forceReloadView || this.mLoginType != PTApp.getInstance().getPTLoginType() || this.mLoginVendor != curVendor) {
            this.reloadView();
        }
        this.showMyInfo();
        this.updateButtons();
        this.updateLocalStatus();
        IMChatFragment chatFragment = this.getChatFragment();
        if (chatFragment != null) {
            this.mPanelChatParent.setVisibility(0);
        }
        this.updateSettingsNoteBubble();
    }

    private int getCurrentVendor() {
        int curVendor = 0;
        ZoomProductHelper productHelper = PTApp.getInstance().getZoomProductHelper();
        if (productHelper != null) {
            curVendor = productHelper.getCurrentVendor();
        }
        return curVendor;
    }

    public void reloadView() {
        this.removeAllViews();
        this.mPagerAdapter.clear();
        this.mPagerAdapter.notifyDataSetChanged();
        this.initView();
    }

    public void onActivityDestroy() {
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable("IMView.superState", superState);
        if (this.mViewPager != null) {
            bundle.putInt("IMView.tabPage", this.mViewPager.getCurrentItem());
        }
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Parcelable superState = null;
        if (state instanceof Bundle) {
            Bundle allState = (Bundle)state;
            superState = allState.getParcelable("IMView.superState");
            int tabPage = allState.getInt("IMView.tabPage");
            if (tabPage >= 0) {
                if (this.mViewPager != null) {
                    this.mViewPager.setCurrentItem(tabPage, false);
                }
                if (this.mTabHost != null) {
                    this.mTabHost.setCurrentTab(tabPage);
                }
            }
        } else {
            superState = state;
        }
        super.onRestoreInstanceState(superState);
    }

    public void onIMReceived(PTAppProtos.IMMessage message) {
        IMChatFragment f = this.getChatFragment();
        if (f != null) {
            f.onIMReceived(message);
        }
        this.updateUnreadThirdPartyIMMsgCountTabBubble();
    }

    public void onIMBuddyPresence(PTAppProtos.BuddyItem item) {
        IMChatFragment f = this.getChatFragment();
        if (f != null) {
            f.onIMBuddyPresence(item);
        }
    }

    public void onIMBuddyPic(PTAppProtos.BuddyItem item) {
        IMChatFragment f = this.getChatFragment();
        if (f != null) {
            f.onIMBuddyPic(item);
        }
    }

    public void onIMBuddySort() {
    }

    public void onMyInfoReady() {
        this.showMyInfo();
        IMMeetingFragment meetingFragment = this.getMeetingFragment();
        if (meetingFragment != null) {
            meetingFragment.onMyInfoReady();
        }
    }

    public void onMyPictureReady() {
        this.showMyInfo();
        IMMeetingFragment meetingFragment = this.getMeetingFragment();
        if (meetingFragment != null) {
            meetingFragment.onMyPictureReady();
        }
    }

    public void onIndicateZoomMessengerBuddyListUpdated() {
        this.updateUnreadChatsCountTabBubble();
    }

    public void onZoomMessengerNotifySubscribeRequest() {
        this.updateUnreadChatsCountTabBubble();
    }

    private void showMyInfo() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null && !StringUtil.isEmptyOrNull((String)profile.getPictureLocalPath())) {
            String avatar = profile.getPictureLocalPath();
            if (this.mAvatar != null) {
                this.mAvatar.setAvatar(avatar);
            }
            PreferenceUtil.saveStringValue("local_avatar", avatar);
        } else {
            String avatar = PreferenceUtil.readStringValue("local_avatar", "");
            if (avatar.length() > 0) {
                String zoomUserId;
                IMHelper imHelper = PTApp.getInstance().getIMHelper();
                String jid = imHelper != null ? imHelper.getJIDMyself() : null;
                String string2 = zoomUserId = profile != null ? profile.getUserID() : null;
                if (!StringUtil.isEmptyOrNull((String)jid) && avatar.indexOf(jid) >= 0 || !StringUtil.isEmptyOrNull((String)zoomUserId) && avatar.indexOf(zoomUserId) >= 0) {
                    if (this.mAvatar != null) {
                        this.mAvatar.setAvatar(avatar);
                    }
                } else {
                    if (this.mAvatar != null) {
                        this.mAvatar.setAvatar((String)null);
                    }
                    if (jid != null || zoomUserId != null) {
                        PreferenceUtil.saveStringValue("local_avatar", "");
                    }
                }
            }
        }
        if (profile != null) {
            this.mMyName = profile.getUserName();
        }
    }

    public void onCallStatusChanged(long result) {
        IMChatFragment f;
        switch ((int)result) {
            case 1: 
            case 2: {
                if (this.mBtnReturnToConf2 == null) break;
                this.mBtnReturnToConf2.setVisibility(0);
                break;
            }
            default: {
                if (this.mBtnReturnToConf2 == null) break;
                this.mBtnReturnToConf2.setVisibility(8);
            }
        }
        if ((f = this.getChatFragment()) != null) {
            f.onCallStatusChanged(result);
        }
    }

    public void onCallPlistChanged() {
        IMChatFragment f = this.getChatFragment();
        if (f != null) {
            f.onCallPlistChanged();
        }
    }

    public void onIMLocalStatusChanged(int status) {
        this.updateLocalStatus(status);
    }

    public void onIMLogin(long result) {
        switch ((int)result) {
            case 0: {
                this.updateLocalStatus(4);
                break;
            }
            case 3: {
                this.updateLocalStatus(0);
                int loginType = PTApp.getInstance().getPTLoginType();
                if (loginType == 97) break;
                if (result == 3L && loginType == 0) {
                    FBSessionStore.clear((String)"facebook-session", (Context)this.getContext());
                }
                PTApp.getInstance().setRencentJid("");
                PTApp.getInstance().logout(1);
                PTApp.getInstance().setWebSignedOn(false);
                if (g_lastAuthFailedTime == 0L || System.currentTimeMillis() - g_lastAuthFailedTime < 5000L) {
                    this.showLoginUIForTokenExpired(true);
                } else {
                    this.showLoginUIForTokenExpired(false);
                }
                g_lastAuthFailedTime = System.currentTimeMillis();
                break;
            }
            default: {
                this.updateLocalStatus(5);
            }
        }
    }

    public void onWebLogin(long result) {
        this.updateUI(true);
    }

    public void onGoogleWebAccessFail() {
        this.updateLocalStatus(5);
    }

    public void onZoomMessengerMessageReceived() {
        this.updateUnreadChatsCountTabBubble();
    }

    public void onZoomMessengerChatSessionListUpdate() {
        this.updateUnreadChatsCountTabBubble();
    }

    public void onZoomMessengerNotifyChatSessionUnreadUpdate() {
        this.updateUnreadChatsCountTabBubble();
    }

    public void onZoomMessengerIndicateRevokeMessageResult(String actionOwner, String sessionId, String guid, String recallMsgId, boolean result) {
        this.updateUnreadChatsCountTabBubble();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnReturnToConf2) {
            this.onClickBtnReturnToConf();
        } else if (id2 == R.id.avatarViewRight) {
            this.onClickAvatarView(v.getId());
        } else if (id2 == R.id.panelChatParent) {
            this.onClickPanelChatParent();
        }
    }

    private void showLoginUIForTokenExpired(boolean autoLogin) {
        PTApp.getInstance().setTokenExpired(true);
        LoginUtil.showLoginUI(this.getContext(), autoLogin, -999);
    }

    private void onClickBtnReturnToConf() {
        ConfActivity.returnToConf(this.getContext());
    }

    private void onClickAvatarView(int viewId) {
        if (this.mIsLargeMode) {
            FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
            SettingFragment.show(fm, viewId);
        }
    }

    private void onClickPanelChatParent() {
        IMBuddyListFragment buddyListFragment = this.getBuddyListFragment();
        if (buddyListFragment != null && buddyListFragment.isFocusedOnSearchField()) {
            UIUtil.closeSoftKeyboard((Context)this.getContext(), (View)this);
        }
        this.showChatUI(null);
    }

    public boolean closeTips() {
        boolean ret = false;
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        SettingFragment f = SettingFragment.getSettingFragment(fm);
        if (f != null) {
            f.dismiss();
            ret = true;
        }
        return ret;
    }

    public void onSubscriptionRequest() {
    }

    public void onSubscriptionUpdate() {
    }

    public boolean onSearchRequested() {
        if (this.mPagerAdapter == null || this.mViewPager == null) {
            return false;
        }
        Fragment f = this.mPagerAdapter.getItem(this.mViewPager.getCurrentItem());
        IMBuddyListFragment buddyListFragment = this.getBuddyListFragment();
        if (buddyListFragment != null && f == buddyListFragment) {
            return buddyListFragment.onSearchRequested();
        }
        IMFavoriteListFragment favoriteListFragment = this.getFavoriteListFragment();
        if (favoriteListFragment != null && f == favoriteListFragment) {
            return favoriteListFragment.onSearchRequested();
        }
        IMAddrBookListFragment addrbookListFragment = this.getAddrBookListFragment();
        if (addrbookListFragment != null && f == addrbookListFragment) {
            return addrbookListFragment.onSearchRequested();
        }
        MMChatsListFragment chatsListFragment = this.getChatsListFragment();
        if (chatsListFragment != null && f == chatsListFragment) {
            return chatsListFragment.onSearchRequested();
        }
        return true;
    }

    public void onScheduleSuccess(ScheduledMeetingItem item) {
        IMMeetingFragment meetingFragment = this.getMeetingFragment();
        if (meetingFragment != null) {
            meetingFragment.onScheduleSuccess(item);
        }
    }

    public void onAddressBookEnabled(boolean enabled) {
        this.reloadView();
        if (this.mTabHost != null && this.mViewPager != null) {
            if (enabled) {
                this.showTab(TAB_ADDRBOOK);
            } else {
                this.showTab(TAB_SETTINGS);
            }
        }
    }

    public void onMMSessionDeleted(String sessionId) {
        IMAddrBookListFragment addrFragment;
        this.updateUnreadChatsCountTabBubble();
        MMChatsListFragment chatsFragment = this.getChatsListFragment();
        if (chatsFragment != null) {
            chatsFragment.onSessionDeleted(sessionId);
        }
        if ((addrFragment = this.getAddrBookListFragment()) != null) {
            addrFragment.onSessionDelete(sessionId);
        }
    }

    private void showTab(String tabTag) {
        if (this.mTabHost != null) {
            this.mTabHost.setCurrentTabByTag(tabTag);
            this.mViewPager.setCurrentItem(this.mTabHost.getCurrentTab(), false);
        }
    }

    public void onNewVersionReady() {
        this.updateSettingsNoteBubble();
    }

    private void onFirstOpenContacts() {
        IMAddrBookListFragment f;
        PreferenceUtil.saveBooleanValue("first_open_contacts", false);
        if (!PTApp.getInstance().isPhoneNumberRegistered() && (f = this.getAddrBookListFragment()) != null) {
            f.enableAddrBook();
        }
    }

    private void onSelectContactsPage() {
        IMAddrBookListFragment f = this.getAddrBookListFragment();
        if (f != null) {
            f.onSelected();
        }
    }

    public static class StartHangoutFailedDialog
    extends ZMDialogFragment {
        public static void show(FragmentManager fragmentMgr, String tag, int errorCode) {
            Bundle args = new Bundle();
            args.putInt("errorCode", errorCode);
            StartHangoutFailedDialog dlg = new StartHangoutFailedDialog();
            dlg.setArguments(args);
            dlg.show(fragmentMgr, tag);
        }

        public StartHangoutFailedDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            int errorCode = args != null ? args.getInt("errorCode") : -1;
            String message = this.errorCodeToMessage(this.getActivity().getResources(), errorCode);
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_alert_start_conf_failed).setMessage(message);
            if (errorCode != 8) {
                builder.setNegativeButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
            } else {
                builder.setPositiveButton(R.string.zm_btn_update, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        StartHangoutFailedDialog.this.updateClient();
                    }
                }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
            }
            return builder.create();
        }

        private String errorCodeToMessage(Resources res, int errorCode) {
            String message = "";
            int resId = 0;
            switch (errorCode) {
                case 8: {
                    resId = R.string.zm_msg_conffail_needupdate_confirm;
                    message = res.getString(resId);
                    break;
                }
                default: {
                    resId = R.string.zm_msg_conffail_unknownerror_confirm;
                    message = res.getString(resId, new Object[]{errorCode});
                }
            }
            return message;
        }

        private void updateClient() {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity != null) {
                UpgradeUtil.upgrade(activity);
            }
        }
    }

    public static interface OnFragmentShowListener {
        public void onShow();
    }
}

