/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.videobox.JoinByURLActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.util.TimeFormatUtil;
import com.zipow.videobox.util.ZMFacebookUtils;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMMessageItem;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class IMMessageView
extends LinearLayout {
    private static final String TAG = IMMessageView.class.getSimpleName();
    private TextView mTxtScreenName;
    private TextView mTxtTime;
    private TextView mTxtMessage;
    private AvatarView mAvatarView;
    private String mMessage;
    private boolean mIsIncomingMessage = true;

    public IMMessageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public IMMessageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public IMMessageView(Context context) {
        super(context);
        this.initView();
    }

    public IMMessageView(Context context, boolean isIncomingMessage) {
        super(context);
        this.mIsIncomingMessage = isIncomingMessage;
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mTxtTime = (TextView)this.findViewById(R.id.txtTime);
        this.mTxtMessage = (TextView)this.findViewById(R.id.txtMessage);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mTxtMessage.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                IMMessageView.this.showMessageContextMenu();
                return true;
            }
        });
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)(this.mIsIncomingMessage ? R.layout.zm_im_message_from : R.layout.zm_im_message_to), (ViewGroup)this);
    }

    public void setScreenName(CharSequence name) {
        if (name != null && this.mTxtScreenName != null) {
            this.mTxtScreenName.setText(name);
        }
    }

    public void setTime(long time) {
        String sTime = null;
        sTime = this.isInEditMode() ? "00:00 am" : TimeFormatUtil.formatTime(this.getContext(), time);
        if (this.mTxtTime != null) {
            this.mTxtTime.setText((CharSequence)sTime);
        }
    }

    public void setMessage(CharSequence message) {
        if (message == null) {
            return;
        }
        this.mMessage = message.toString();
        if (this.mTxtMessage != null) {
            this.mTxtMessage.setText(message);
            this.mTxtMessage.setMovementMethod((MovementMethod)new LinkMovementMethod(){

                public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
                    try {
                        return super.onTouchEvent(widget, buffer, event);
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            });
        }
        this.hookZoomURL(this.mTxtMessage);
    }

    public void setAvatar(String avatar) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(avatar);
        }
    }

    public void setMessageItem(IMMessageItem item) {
        this.setScreenName(item.fromScreenName);
        this.setTime(item.messageTime);
        this.setMessage(item.message);
        if (!this.isInEditMode()) {
            this.setAvatar(ZMFacebookUtils.getVCardFileName(PTApp.getInstance().getPTLoginType(), item.fromJid));
        }
    }

    private void hookZoomURL(TextView tv) {
        if (tv == null) {
            return;
        }
        CharSequence text = tv.getText();
        if (text instanceof Spannable) {
            Spannable spannable = (Spannable)text;
            URLSpan[] urls = tv.getUrls();
            if (urls == null || urls.length < 1) {
                return;
            }
            for (int i = 0; i < urls.length; ++i) {
                URLSpan span = urls[i];
                String url = span.getURL();
                if (url.startsWith("http://https://") || url.startsWith("http://http://")) {
                    url = url.substring(7);
                }
                if (!this.isZoomURL(url)) continue;
                final String zoomUrl = url;
                URLSpan newSpan = new URLSpan(zoomUrl){

                    public void onClick(View widget) {
                        IMMessageView.this.joinByURL(zoomUrl);
                    }
                };
                int start = spannable.getSpanStart((Object)span);
                int end = spannable.getSpanEnd((Object)span);
                int flags = spannable.getSpanFlags((Object)span);
                if (start < 0 || end <= start) continue;
                spannable.removeSpan((Object)span);
                spannable.setSpan((Object)newSpan, start, end, flags);
            }
        }
    }

    private void joinByURL(String url) {
        Intent intent = new Intent(this.getContext(), JoinByURLActivity.class);
        intent.setAction("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)url));
        this.getContext().startActivity(intent);
    }

    private boolean isZoomURL(String url) {
        return url.matches("https?://.+\\.zoom\\.us/[j|w]/.+");
    }

    private void showMessageContextMenu() {
        Activity activity = (Activity)this.getContext();
        if (activity == null) {
            return;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
        menuAdapter.addItem((IZMMenuItem)new MessageContextMenuItem(activity.getString(R.string.zm_mm_lbl_copy_message), 0));
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MessageContextMenuItem item = (MessageContextMenuItem)((Object)menuAdapter.getItem(which));
                IMMessageView.this.onSelectContextMenuItem(item);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onSelectContextMenuItem(MessageContextMenuItem item) {
        switch (item.getAction()) {
            case 0: {
                if (StringUtil.isEmptyOrNull((String)this.mMessage)) break;
                AndroidAppUtil.copyText((Context)this.getContext(), (CharSequence)this.mMessage);
            }
        }
    }

    static class MessageContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_COPY = 0;

        public MessageContextMenuItem(String label, int action) {
            super(action, label);
        }
    }
}

