/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.util.TimeFormatUtil;
import com.zipow.videobox.view.IMMessageView;
import us.zoom.videomeetings.R;

public class IMMessageItem {
    public static final int ITEM_TYPE_NORMAL_RECEIVED = 0;
    public static final int ITEM_TYPE_NORMAL_SENT = 1;
    public static final int ITEM_TYPE_CALLINVITATION_RECEIVED = 2;
    public static final int ITEM_TYPE_CALLINVITATION_SENT = 3;
    public static final int ITEM_TYPE_CALLHANGUP_RECEIVED = 4;
    public static final int ITEM_TYPE_CALLHANGUP_SENT = 5;
    public static final int ITEM_TYPE_SHAREINVITATION_RECEIVED = 6;
    public static final int ITEM_TYPE_SHAREINVITATION_SENT = 7;
    public static final int ITEM_TYPE_SHAREHANGUP_RECEIVED = 8;
    public static final int ITEM_TYPE_SHAREHANGUP_SENT = 9;
    public static final int ITEM_TYPE_DATE = 10;
    public String fromScreenName;
    public String fromJid;
    public String toScreenName;
    public String toJid;
    public String message;
    public long messageTime;
    public int messageType = 0;
    public long nativeHandle = 0L;

    public View getView(Context context, View convertView) {
        View view = null;
        switch (this.messageType) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                view = this.createNormalItemView(context, convertView, false);
                break;
            }
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                view = this.createNormalItemView(context, convertView, true);
                break;
            }
            case 10: {
                view = this.createDateItemView(context, convertView);
            }
        }
        return view;
    }

    private void bindItemView(IMMessageView view) {
        view.setMessageItem(this);
    }

    private View createNormalItemView(Context context, View convertView, boolean isInComingMessage) {
        String tag;
        IMMessageView view = null;
        String string2 = tag = isInComingMessage ? "IncomingMessage" : "OutMessage";
        if (convertView instanceof IMMessageView && tag.equals(convertView.getTag())) {
            view = (IMMessageView)convertView;
        } else {
            view = new IMMessageView(context, isInComingMessage);
            view.setTag(tag);
        }
        this.bindItemView(view);
        return view;
    }

    private View createDateItemView(Context context, View convertView) {
        View view = null;
        if (convertView != null && "DateTime".equals(convertView.getTag())) {
            view = convertView;
        } else {
            view = View.inflate((Context)context, (int)R.layout.zm_im_message_item_date, null);
            view.setTag((Object)"DateTime");
        }
        TextView textView = (TextView)view.findViewById(R.id.txtMessage);
        if (textView != null) {
            String sTime = TimeFormatUtil.formatDateTime(context, this.messageTime, false);
            if (sTime == null || sTime.indexOf("null") >= 0) {
                sTime = "Monday, 00:00 am";
            }
            textView.setText((CharSequence)sTime);
        }
        return view;
    }
}

