/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.BuddyInviteActivity;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.IMChatActivity;
import com.zipow.videobox.fragment.BuddyInviteFragment;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.IMSession;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTBuddyHelper;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.IMBuddyItem;
import com.zipow.videobox.view.IMBuddyListAdapter;
import com.zipow.videobox.view.IMView;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class IMBuddyListView
extends ListView
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener {
    private static final String TAG = IMBuddyListView.class.getSimpleName();
    private IMBuddyListAdapter mAdapter;
    private String mFilter;
    private boolean mShowOfflineUser = true;

    public IMBuddyListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public IMBuddyListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public IMBuddyListView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.mAdapter = new IMBuddyListAdapter(this.getContext());
        if (this.isInEditMode()) {
            this._editmode_loadAllBuddyItems(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
        this.setOnItemLongClickListener(this);
    }

    private void _editmode_loadAllBuddyItems(IMBuddyListAdapter adapter) {
        for (int i = 0; i < 20; ++i) {
            IMBuddyItem item = new IMBuddyItem();
            item.screenName = "Buddy " + i;
            item.userId = String.valueOf(i);
            adapter.addItem(item);
        }
    }

    private void loadAllBuddyItems(IMBuddyListAdapter adapter) {
        this.mShowOfflineUser = this.getShowOfflineBuddies();
        PTBuddyHelper buddyHelper = PTApp.getInstance().getBuddyHelper();
        if (buddyHelper == null) {
            return;
        }
        if (this.mFilter != null && this.mFilter.length() > 0) {
            String lowerFilter = this.mFilter.toLowerCase(CompatUtils.getLocalDefault());
            int count = buddyHelper.getBuddyItemCount();
            for (int i = 0; i < count; ++i) {
                PTAppProtos.BuddyItem protoItem = buddyHelper.getBuddyItem(i);
                if (protoItem == null || protoItem.getScreenName().toLowerCase(CompatUtils.getLocalDefault()).indexOf(lowerFilter) < 0) continue;
                IMBuddyItem item = new IMBuddyItem(protoItem);
                adapter.addItem(item);
            }
            adapter.sort(false);
        } else {
            int count = buddyHelper.getBuddyItemCount();
            for (int i = 0; i < count; ++i) {
                PTAppProtos.BuddyItem protoItem = buddyHelper.getBuddyItem(i);
                if (protoItem == null) continue;
                int unreadMsgCount = this.getUnreadMessageCount(protoItem.getJid());
                if (!this.mShowOfflineUser && !protoItem.getIsOnline() && unreadMsgCount <= 0) continue;
                IMBuddyItem item = new IMBuddyItem(protoItem, unreadMsgCount);
                adapter.addItem(item);
            }
            adapter.sort(true);
        }
    }

    private boolean getShowOfflineBuddies() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            return settingHelper.getShowOfflineBuddies();
        }
        return false;
    }

    private int getUnreadMessageCount(String jid) {
        IMHelper helper = PTApp.getInstance().getIMHelper();
        IMSession session = helper.getSessionBySessionName(jid);
        if (session == null) {
            return 0;
        }
        return session.getUnreadMessageCount();
    }

    public void updateBuddyItem(PTAppProtos.BuddyItem protoItem) {
        if (protoItem == null) {
            return;
        }
        if (this.mFilter != null && this.mFilter.length() > 0) {
            String name = protoItem.getScreenName();
            if (StringUtil.isEmptyOrNull((String)name)) {
                return;
            }
            String lowerFilter = this.mFilter.toLowerCase(CompatUtils.getLocalDefault());
            if (name.toLowerCase(CompatUtils.getLocalDefault()).indexOf(lowerFilter) >= 0) {
                int unreadMsgCount = this.getUnreadMessageCount(protoItem.getJid());
                IMBuddyItem item = new IMBuddyItem(protoItem, unreadMsgCount);
                this.mAdapter.updateItem(item);
                this.mAdapter.sort(false);
            } else {
                this.mAdapter.removeItem(protoItem.getJid());
            }
            this.mAdapter.notifyDataSetChanged();
        } else {
            int unreadMsgCount = this.getUnreadMessageCount(protoItem.getJid());
            if (this.mShowOfflineUser || protoItem.getIsOnline() || unreadMsgCount > 0) {
                IMBuddyItem item = new IMBuddyItem(protoItem, unreadMsgCount);
                this.mAdapter.updateItem(item);
                this.mAdapter.sort(true);
            } else {
                this.mAdapter.removeItem(protoItem.getJid());
            }
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void updateBuddyItem(String jid) {
        PTBuddyHelper buddyHelper = PTApp.getInstance().getBuddyHelper();
        if (buddyHelper == null) {
            return;
        }
        PTAppProtos.BuddyItem protoItem = buddyHelper.getBuddyItemByJid(jid);
        if (protoItem == null) {
            return;
        }
        this.updateBuddyItem(protoItem);
    }

    public void reloadAllBuddyItems() {
        this.mAdapter.clear();
        this.loadAllBuddyItems(this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
    }

    public void sort() {
        this.mAdapter.sort(this.mFilter == null || this.mFilter.length() == 0);
        this.mAdapter.notifyDataSetChanged();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object obj = this.getItemAtPosition(position);
        if (obj == null || !(obj instanceof IMBuddyItem)) {
            return;
        }
        IMBuddyItem item = (IMBuddyItem)obj;
        if (!item.isPending && !item.isNoneFriend) {
            this.showChatUI(item);
        } else {
            IMBuddyListView.showBuddyInviteUI((ZMActivity)this.getContext(), item);
        }
    }

    private void showChatUI(IMBuddyItem buddyItem) {
        if (buddyItem == null) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return;
        }
        if (UIMgr.isLargeMode((Context)activity)) {
            ((IMActivity)this.getContext()).showChatUI(buddyItem);
        } else {
            Intent i = new Intent((Context)activity, IMChatActivity.class);
            i.setFlags(131072);
            i.putExtra("buddyItem", (Serializable)buddyItem);
            i.putExtra("myName", profile.getUserName());
            activity.startActivityForResult(i, activity instanceof IMActivity ? 100 : 0);
        }
    }

    private static void showBuddyInviteUI(ZMActivity activity, IMBuddyItem buddyItem) {
        if (buddyItem == null) {
            return;
        }
        if (activity == null) {
            return;
        }
        if (UIMgr.isLargeMode((Context)activity)) {
            FragmentManager fm = activity.getSupportFragmentManager();
            BuddyInviteFragment.showDialog(fm, buddyItem.userId);
        } else {
            BuddyInviteActivity.show(activity, activity instanceof IMActivity ? 102 : 0, buddyItem.userId);
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        Object obj = this.getItemAtPosition(position);
        if (!(obj instanceof IMBuddyItem)) {
            return false;
        }
        IMBuddyItem item = (IMBuddyItem)obj;
        ContextMenuFragment.show(((ZMActivity)this.getContext()).getSupportFragmentManager(), item);
        return true;
    }

    public void onRestoreInstanceState(Parcelable state) {
        Parcelable superState = null;
        if (state instanceof Bundle) {
            Bundle allState = (Bundle)state;
            superState = allState.getParcelable("IMBuddyListView.superState");
            this.mFilter = allState.getString("IMBuddyListView.mFilter");
        } else {
            superState = state;
        }
        super.onRestoreInstanceState(superState);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable("IMBuddyListView.superState", superState);
        bundle.putString("IMBuddyListView.mFilter", this.mFilter);
        return bundle;
    }

    public void setFilter(String filter) {
        this.mFilter = filter;
    }

    public String getFilter() {
        return this.mFilter;
    }

    public void filter(String filter) {
        if (filter == null) {
            filter = "";
        }
        filter = filter.trim().toLowerCase(CompatUtils.getLocalDefault());
        String oldFilter = this.mFilter;
        this.mFilter = filter;
        if (oldFilter == null) {
            oldFilter = "";
        }
        if (oldFilter.equals(filter)) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)filter)) {
            if (!StringUtil.isEmptyOrNull((String)oldFilter) && filter.contains(oldFilter)) {
                this.mAdapter.filter(filter);
                this.mAdapter.notifyDataSetChanged();
            } else {
                this.reloadAllBuddyItems();
            }
        } else {
            this.reloadAllBuddyItems();
        }
    }

    public void refreshContextMenu() {
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        ContextMenuFragment contextMenu = (ContextMenuFragment)fm.findFragmentByTag(ContextMenuFragment.class.getName());
        if (contextMenu != null) {
            contextMenu.refresh();
        }
    }

    public static class RemoveBuddyConfirmDialog
    extends ZMDialogFragment {
        private static final String ARG_BUDDYITEM = "buddyItem";

        public RemoveBuddyConfirmDialog() {
            this.setCancelable(true);
        }

        public static void show(FragmentManager fm, IMBuddyItem buddyItem) {
            Bundle args = new Bundle();
            args.putSerializable(ARG_BUDDYITEM, (Serializable)buddyItem);
            RemoveBuddyConfirmDialog f = new RemoveBuddyConfirmDialog();
            f.setArguments(args);
            f.show(fm, RemoveBuddyConfirmDialog.class.getName());
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            IMBuddyItem buddyItem = (IMBuddyItem)args.getSerializable(ARG_BUDDYITEM);
            String message = this.getActivity().getString(R.string.zm_msg_remove_buddy_confirm, new Object[]{buddyItem == null ? "" : buddyItem.screenName});
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(message).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    RemoveBuddyConfirmDialog.this.onClickOK();
                }
            }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            }).create();
        }

        private void onClickOK() {
            Bundle args = this.getArguments();
            IMBuddyItem buddyItem = (IMBuddyItem)args.getSerializable(ARG_BUDDYITEM);
            IMHelper imHelper = PTApp.getInstance().getIMHelper();
            if (imHelper != null && buddyItem != null) {
                imHelper.unsubscribeBuddy(buddyItem.userId);
            }
        }
    }

    static class ContextMenuItem
    extends ZMSimpleMenuItem {
        public ContextMenuItem(int action, String label) {
            super(action, label);
        }
    }

    public static class ContextMenuFragment
    extends ZMDialogFragment {
        public static final int MI_VIDEO_CALL = 0;
        public static final int MI_PHONE_CALL = 1;
        public static final int MI_REMOVE_BUDDY = 2;
        public static final int MI_INVITE_AGAIN = 3;
        private static final String ARG_BUDDYITEM = "buddyItem";
        private ZMMenuAdapter<ContextMenuItem> mAdapter;

        public static void show(FragmentManager fm, IMBuddyItem buddyItem) {
            Bundle args = new Bundle();
            args.putSerializable(ARG_BUDDYITEM, (Serializable)buddyItem);
            ContextMenuFragment f = new ContextMenuFragment();
            f.setArguments(args);
            f.show(fm, ContextMenuFragment.class.getName());
        }

        public ContextMenuFragment() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            IMBuddyItem buddyItem = (IMBuddyItem)this.getArguments().getSerializable(ARG_BUDDYITEM);
            this.mAdapter = this.createUpdateAdapter();
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(buddyItem == null ? "" : buddyItem.screenName).setAdapter(this.mAdapter, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ContextMenuFragment.this.onSelectItem(which);
                }
            }).create();
            dialog.setCanceledOnTouchOutside(true);
            return dialog;
        }

        private ZMMenuAdapter<ContextMenuItem> createUpdateAdapter() {
            int loginType = PTApp.getInstance().getPTLoginType();
            boolean isGoogleLogin = loginType == 2;
            IMBuddyItem buddyItem = (IMBuddyItem)this.getArguments().getSerializable(ARG_BUDDYITEM);
            ContextMenuItem[] items = null;
            if (isGoogleLogin && buddyItem != null && (buddyItem.isPending || buddyItem.isNoneFriend)) {
                items = new ContextMenuItem[]{new ContextMenuItem(2, this.getActivity().getText(R.string.zm_mi_remove_buddy).toString()), new ContextMenuItem(3, this.getActivity().getText(R.string.zm_mi_invite_again).toString())};
            } else if (this.isInCall()) {
                items = new ContextMenuItem[isGoogleLogin ? 2 : 1];
                items[0] = new ContextMenuItem(0, this.getActivity().getText(this.getConfMenuItemText(buddyItem)).toString());
                if (isGoogleLogin) {
                    items[1] = new ContextMenuItem(2, this.getActivity().getText(R.string.zm_mi_remove_buddy).toString());
                }
            } else {
                items = new ContextMenuItem[isGoogleLogin ? 3 : 2];
                items[0] = new ContextMenuItem(0, this.getActivity().getText(R.string.zm_btn_video_call).toString());
                items[1] = new ContextMenuItem(1, this.getActivity().getText(R.string.zm_btn_audio_call).toString());
                if (isGoogleLogin) {
                    items[2] = new ContextMenuItem(2, this.getActivity().getText(R.string.zm_mi_remove_buddy).toString());
                }
            }
            if (this.mAdapter == null) {
                this.mAdapter = new ZMMenuAdapter((Context)((ZMActivity)this.getActivity()), false);
            } else {
                this.mAdapter.clear();
            }
            this.mAdapter.addAll((IZMMenuItem[])items);
            return this.mAdapter;
        }

        public void refresh() {
            this.createUpdateAdapter().notifyDataSetChanged();
        }

        private int getConfMenuItemText(IMBuddyItem buddyItem) {
            int callStatus = PTApp.getInstance().getCallStatus();
            switch (callStatus) {
                case 2: {
                    if (PTApp.getInstance().probeUserStatus(buddyItem.userId)) {
                        return R.string.zm_mi_return_to_conf;
                    }
                    return R.string.zm_mi_invite_to_conf;
                }
                case 1: {
                    return R.string.zm_mi_return_to_conf;
                }
            }
            return R.string.zm_mi_start_conf;
        }

        private boolean isInCall() {
            int callStatus = PTApp.getInstance().getCallStatus();
            switch (callStatus) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        private void onSelectItem(int which) {
            ContextMenuItem menuItem = (ContextMenuItem)((Object)this.mAdapter.getItem(which));
            IMBuddyItem buddyItem = (IMBuddyItem)this.getArguments().getSerializable(ARG_BUDDYITEM);
            switch (menuItem.getAction()) {
                case 2: {
                    this.onSelectRemoveBuddy(buddyItem);
                    break;
                }
                case 3: {
                    this.onSelectInviteAgain(buddyItem);
                    break;
                }
                case 0: {
                    this.onSelectVideoCall(buddyItem);
                    break;
                }
                case 1: {
                    this.onSelectPhoneCall(buddyItem);
                }
            }
        }

        private void onSelectVideoCall(IMBuddyItem buddyItem) {
            int callStatus = PTApp.getInstance().getCallStatus();
            switch (callStatus) {
                case 2: {
                    if (PTApp.getInstance().probeUserStatus(buddyItem.userId)) {
                        this.returnToConf();
                        break;
                    }
                    this.inviteToConf(buddyItem);
                    break;
                }
                case 1: {
                    this.returnToConf();
                    break;
                }
                default: {
                    this.startConf(buddyItem, true);
                }
            }
        }

        private void onSelectPhoneCall(IMBuddyItem buddyItem) {
            int callStatus = PTApp.getInstance().getCallStatus();
            switch (callStatus) {
                case 2: {
                    if (PTApp.getInstance().probeUserStatus(buddyItem.userId)) {
                        this.returnToConf();
                        break;
                    }
                    this.inviteToConf(buddyItem);
                    break;
                }
                case 1: {
                    this.returnToConf();
                    break;
                }
                default: {
                    this.startConf(buddyItem, false);
                }
            }
        }

        private void startConf(IMBuddyItem buddyItem, boolean videoCall) {
            FragmentActivity activity = this.getActivity();
            if (activity == null) {
                return;
            }
            int ret = ConfActivity.inviteToVideoCall((Context)activity, buddyItem.userId, videoCall ? 1 : 0);
            if (ret != 0) {
                IMView.StartHangoutFailedDialog.show(((ZMActivity)activity).getSupportFragmentManager(), IMView.StartHangoutFailedDialog.class.getName(), ret);
            }
        }

        private void inviteToConf(IMBuddyItem buddyItem) {
            PTApp ptApp = PTApp.getInstance();
            String meetingId = ptApp.getActiveCallId();
            if (StringUtil.isEmptyOrNull((String)meetingId)) {
                return;
            }
            FragmentActivity activity = this.getActivity();
            if (activity == null) {
                return;
            }
            int ret = ptApp.inviteBuddiesToConf(new String[]{buddyItem.userId}, null, meetingId, 0L, activity.getString(R.string.zm_msg_invitation_message_template));
            if (ret == 0) {
                ConfActivity.returnToConf((Context)activity);
            }
        }

        private void returnToConf() {
            FragmentActivity activity = this.getActivity();
            if (activity == null) {
                return;
            }
            ConfActivity.returnToConf((Context)activity);
        }

        private void onSelectRemoveBuddy(IMBuddyItem buddyItem) {
            RemoveBuddyConfirmDialog.show(this.getFragmentManager(), buddyItem);
        }

        private void onSelectInviteAgain(IMBuddyItem buddyItem) {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            IMBuddyListView.showBuddyInviteUI(activity, buddyItem);
        }
    }
}

