/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.zipow.videobox.util.IMBuddyItemComparator;
import com.zipow.videobox.view.IMBuddyItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.QuickSearchListView;

public class IMBuddyListAdapter
extends QuickSearchListView.QuickSearchListDataAdapter {
    private static final int ITEM_TYPE_NORMAL = 0;
    private List<IMBuddyItem> mItems = new ArrayList<IMBuddyItem>();
    private Context mContext;

    public IMBuddyListAdapter(Context context) {
        assert (context != null);
        this.mContext = context;
    }

    public void clear() {
        this.mItems.clear();
    }

    public void addItem(IMBuddyItem item) {
        assert (item != null);
        this.mItems.add(item);
    }

    public void updateItem(IMBuddyItem item) {
        assert (item != null);
        int position = this.findItem(item.userId);
        if (position >= 0) {
            this.mItems.set(position, item);
        } else {
            this.mItems.add(item);
        }
    }

    public int findItem(String userId) {
        if (userId == null) {
            return -1;
        }
        for (int i = 0; i < this.mItems.size(); ++i) {
            IMBuddyItem item = this.mItems.get(i);
            if (!userId.equals(item.userId)) continue;
            return i;
        }
        return -1;
    }

    public void removeItem(String userId) {
        int position = this.findItem(userId);
        if (position >= 0) {
            this.removeItemAt(position);
        }
    }

    public void removeItemAt(int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return;
        }
        this.mItems.remove(position);
    }

    public int getCount() {
        return this.mItems.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.mItems.get(position);
    }

    public IMBuddyItem getItemByJid(String jid) {
        for (IMBuddyItem item : this.mItems) {
            if (!item.userId.equals(jid)) continue;
            return item;
        }
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public int getViewTypeCount() {
        return 1;
    }

    public void filter(String filter) {
        for (int i = this.mItems.size() - 1; i >= 0; --i) {
            IMBuddyItem item = this.mItems.get(i);
            if (!StringUtil.isEmptyOrNull((String)item.screenName) && item.screenName.toLowerCase(CompatUtils.getLocalDefault()).contains(filter)) continue;
            this.mItems.remove(i);
        }
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        IMBuddyItem item = (IMBuddyItem)this.getItem(position);
        return item.getView(this.mContext, convertView, null, false);
    }

    public void sort(boolean compareUnreadMsgCount) {
        Collections.sort(this.mItems, new IMBuddyItemComparator(CompatUtils.getLocalDefault(), compareUnreadMsgCount, true));
    }

    public String getItemSortKey(Object item) {
        if (item instanceof IMBuddyItem) {
            IMBuddyItem abItem = (IMBuddyItem)item;
            String key = abItem.sortKey;
            if (StringUtil.isEmptyOrNull((String)key)) {
                key = abItem.email;
            }
            if (key == null) {
                key = "";
            }
            return key;
        }
        return "";
    }
}

