/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMBuddyItem;
import us.zoom.videomeetings.R;

public class IMBuddyItemView
extends LinearLayout {
    private IMBuddyItem mItem;
    private TextView mTxtScreenName;
    private TextView mTxtInvited;
    private ImageView mImgPresence;
    private TextView mTxtUnreadMessageCount;
    private AvatarView mAvatarView;

    public IMBuddyItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public IMBuddyItemView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mImgPresence = (ImageView)this.findViewById(R.id.imgPresence);
        this.mTxtUnreadMessageCount = (TextView)this.findViewById(R.id.txtUnreadMessageCount);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mTxtInvited = (TextView)this.findViewById(R.id.txtInvited);
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_im_buddy_item, (ViewGroup)this);
    }

    public void setScreenName(CharSequence name) {
        if (name != null) {
            this.mTxtScreenName.setText(name);
        }
    }

    public void setAvatar(String imgPathName, int presence) {
        this.mAvatarView.setAvatar(imgPathName, presence);
    }

    public void setPresence(int presence) {
        switch (presence) {
            case 0: {
                this.mImgPresence.setImageResource(R.drawable.zm_status_available);
                this.mImgPresence.setContentDescription((CharSequence)this.mImgPresence.getResources().getString(R.string.zm_description_mm_presence_available));
                this.mTxtScreenName.setTextColor(this.getResources().getColor(R.color.zm_im_buddyname_online));
                break;
            }
            case 3: {
                this.mImgPresence.setImageResource(R.drawable.zm_status_dnd);
                this.mImgPresence.setContentDescription((CharSequence)this.mImgPresence.getResources().getString(R.string.zm_description_mm_presence_dnd_19903));
                this.mTxtScreenName.setTextColor(this.getResources().getColor(R.color.zm_im_buddyname_online));
                break;
            }
            case 4: {
                this.mImgPresence.setImageResource(R.drawable.zm_status_dnd);
                this.mImgPresence.setContentDescription((CharSequence)this.mImgPresence.getResources().getString(R.string.zm_description_mm_presence_xa_19903));
                this.mTxtScreenName.setTextColor(this.getResources().getColor(R.color.zm_im_buddyname_online));
                break;
            }
            case 2: {
                this.mImgPresence.setImageResource(R.drawable.zm_status_idle);
                this.mImgPresence.setContentDescription((CharSequence)this.mImgPresence.getResources().getString(R.string.zm_description_mm_presence_idle));
                this.mTxtScreenName.setTextColor(this.getResources().getColor(R.color.zm_im_buddyname_online));
                break;
            }
            default: {
                this.mImgPresence.setImageResource(R.drawable.zm_offline);
                this.mImgPresence.setContentDescription((CharSequence)this.mImgPresence.getResources().getString(R.string.zm_description_mm_presence_offline));
                this.mTxtScreenName.setTextColor(this.getResources().getColor(R.color.zm_im_buddyname_offline));
            }
        }
    }

    public void setUnreadMessageCount(int count) {
        this.mTxtUnreadMessageCount.setVisibility(count <= 0 ? 8 : 0);
        if (count <= 99) {
            this.mTxtUnreadMessageCount.setText((CharSequence)String.valueOf(count));
        } else {
            this.mTxtUnreadMessageCount.setText((CharSequence)"99+");
        }
    }

    public void setBuddyListItem(IMBuddyItem item) {
        if (item == null) {
            return;
        }
        this.mItem = item;
        this.setScreenName(this.mItem.screenName);
        this.setPresence(this.mItem.presence);
        this.setAvatar(this.mItem.avatar, this.mItem.presence);
        this.setUnreadMessageCount(item.unreadMessageCount);
        if (item.isNoneFriend) {
            this.mTxtInvited.setVisibility(8);
            this.mImgPresence.setVisibility(8);
        } else if (item.isPending) {
            this.mTxtInvited.setVisibility(0);
            this.mImgPresence.setVisibility(8);
        } else {
            this.mTxtInvited.setVisibility(8);
            this.mImgPresence.setVisibility(0);
        }
    }
}

