/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.IMSession;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.view.IMBuddyItemView;
import java.io.Serializable;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.androidlib.util.StringUtil;

public class IMBuddyItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String userId;
    public String screenName;
    public String sortKey;
    public String email;
    public int presence;
    public String avatar;
    public int unreadMessageCount = 0;
    public boolean isPending = false;
    public boolean isNoneFriend = false;

    public IMBuddyItem() {
    }

    public IMBuddyItem(PTAppProtos.BuddyItem protoItem) {
        this.parseFromProtoItem(protoItem, -1);
    }

    public IMBuddyItem(PTAppProtos.BuddyItem protoItem, int unreadMessageCount) {
        this.parseFromProtoItem(protoItem, unreadMessageCount);
    }

    public IMBuddyItem parseFromProtoItem(PTAppProtos.BuddyItem protoItem) {
        return this.parseFromProtoItem(protoItem, -1);
    }

    public IMBuddyItem parseFromProtoItem(PTAppProtos.BuddyItem protoItem, int unreadMessageCount) {
        this.screenName = protoItem.getScreenName();
        this.userId = protoItem.getJid();
        this.presence = protoItem.getPresence();
        this.avatar = protoItem.getLocalPicturePath();
        this.isPending = protoItem.getIsPending();
        this.isNoneFriend = protoItem.getIsNoneFriend();
        this.sortKey = SortUtil.getSortKey((String)this.screenName, (Locale)CompatUtils.getLocalDefault());
        if (StringUtil.isEmptyOrNull((String)this.avatar)) {
            this.avatar = protoItem.getPicture();
        }
        if (unreadMessageCount >= 0) {
            this.unreadMessageCount = unreadMessageCount;
        } else if (VideoBoxApplication.getInstance().isPTApp()) {
            this.unreadMessageCount = this.getUnreadMessageCount(protoItem.getJid());
        }
        return this;
    }

    private int getUnreadMessageCount(String jid) {
        IMHelper helper = PTApp.getInstance().getIMHelper();
        IMSession session = helper.getSessionBySessionName(jid);
        if (session == null) {
            return 0;
        }
        return session.getUnreadMessageCount();
    }

    public View getView(Context context, View convertView, MemCache<String, Bitmap> avatarCache, boolean disableLazyloadAvatar) {
        IMBuddyItemView view = null;
        view = convertView instanceof IMBuddyItemView ? (IMBuddyItemView)convertView : new IMBuddyItemView(context);
        this.bindView(view);
        return view;
    }

    private void bindView(IMBuddyItemView view) {
        view.setBuddyListItem(this);
    }
}

