/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.IMAddrBookListView;
import com.zipow.videobox.view.mm.IMAddrBookItemComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

public class IMAddrBookListAdapter
extends QuickSearchListView.QuickSearchListDataAdapter {
    public static final char SEARCH_MODE_SORT_KEY = Short.MAX_VALUE;
    private static final String TAG = IMAddrBookListAdapter.class.getSimpleName();
    private static final int ITEM_TYPE_NORMAL = 0;
    private static final int ITEM_TYPE_OTHER_CONTACTS = 1;
    private static final int ITEM_TYPE_SEARCH_MORE = 2;
    private List<IMAddrBookItem> mItems = new ArrayList<IMAddrBookItem>();
    private HashMap<String, IMAddrBookItem> mSearchMap = new HashMap();
    private List<String> mWaitRefreshJids = new ArrayList<String>();
    private Context mContext;
    private IMAddrBookListView mListView;
    private ItemOtherContacts mItemAccountContacts = null;
    private String mItemSearchMore = "searchMode";
    private boolean mLazyLoadAvatarDisabled = false;
    private String mFilter = null;
    private boolean mHasWebSearchResults = false;

    public IMAddrBookListAdapter(Context context, IMAddrBookListView listView) {
        assert (context != null);
        this.mContext = context;
        this.mListView = listView;
        this.initItemAccountContacts();
    }

    private void initItemAccountContacts() {
        switch (PTApp.getInstance().getPTLoginType()) {
            case 100: {
                break;
            }
            case 101: {
                break;
            }
            case 2: {
                if (!PTApp.getInstance().isGoogleImEnabled()) break;
                this.mItemAccountContacts = new ItemOtherContacts(1);
                break;
            }
            case 0: {
                if (!PTApp.getInstance().isFacebookImEnabled()) break;
                this.mItemAccountContacts = new ItemOtherContacts(2);
            }
        }
    }

    public List<IMAddrBookItem> cache() {
        ArrayList<IMAddrBookItem> items = new ArrayList<IMAddrBookItem>();
        items.addAll(this.mItems);
        return items;
    }

    public void addItems(Collection<IMAddrBookItem> items) {
        for (IMAddrBookItem item : items) {
            if (item.isZoomRoomContact() || item.getIsRobot()) continue;
            this.mItems.add(item);
            this.mSearchMap.put(item.getJid(), item);
        }
        Collections.sort(this.mItems, new IMAddrBookItemComparator(CompatUtils.getLocalDefault()));
    }

    public void addItems(Collection<IMAddrBookItem> items, boolean includeOfflineBuddies, String filter) {
        if (filter != null) {
            filter = filter.toLowerCase(CompatUtils.getLocalDefault());
        }
        this.mFilter = filter;
        this.mItems.clear();
        this.mSearchMap.clear();
        if (includeOfflineBuddies && StringUtil.isEmptyOrNull((String)filter)) {
            for (IMAddrBookItem item : items) {
                if (TextUtils.isEmpty((CharSequence)item.getScreenName()) || item.isZoomRoomContact() || item.getIsRobot()) continue;
                this.mItems.add(item);
                this.mSearchMap.put(item.getJid(), item);
            }
            return;
        }
        for (IMAddrBookItem item : items) {
            if (TextUtils.isEmpty((CharSequence)item.getScreenName()) || item.isZoomRoomContact() || item.getIsRobot()) continue;
            if (!StringUtil.isEmptyOrNull((String)filter)) {
                String name = item.getScreenName();
                String email = item.getAccountEmail();
                if ((name == null || !name.toLowerCase(CompatUtils.getLocalDefault()).contains(filter)) && (email == null || !email.toLowerCase(CompatUtils.getLocalDefault()).contains(filter))) continue;
                this.mItems.add(item);
                this.mSearchMap.put(item.getJid(), item);
                continue;
            }
            if (includeOfflineBuddies) {
                this.mItems.add(item);
                this.mSearchMap.put(item.getJid(), item);
                continue;
            }
            if (!item.getIsDesktopOnline() && !item.getIsMobileOnline()) continue;
            this.mItems.add(item);
            this.mSearchMap.put(item.getJid(), item);
        }
        Collections.sort(this.mItems, new IMAddrBookItemComparator(CompatUtils.getLocalDefault()));
    }

    public void clear() {
        this.mItems.clear();
        this.mSearchMap.clear();
    }

    public void addItem(IMAddrBookItem item) {
        assert (item != null);
        if (TextUtils.isEmpty((CharSequence)item.getScreenName()) || item.isZoomRoomContact() || item.getIsRobot()) {
            return;
        }
        if (!this.hasItemWithJid(item.getJid())) {
            this.mItems.add(item);
            this.mSearchMap.put(item.getJid(), item);
        }
    }

    public boolean hasItemWithJid(String jid) {
        return this.mSearchMap.get(jid) != null;
    }

    public int getCount() {
        int count = this.mItems.size();
        if (this.mItemAccountContacts != null) {
            ++count;
        }
        if (this.hasSearchMoreItem()) {
            ++count;
        }
        return count;
    }

    private boolean hasSearchMoreItem() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        int coworkers = messenger.getCoWorkersCount();
        return !this.mHasWebSearchResults && this.mFilter != null && this.mFilter.length() >= 3 && coworkers >= 199;
    }

    public void setHasWebSearchResults(boolean hasWebSearchResults) {
        this.mHasWebSearchResults = hasWebSearchResults;
    }

    public int getContactsItemCount() {
        return this.mItems.size();
    }

    public List<String> getWaitRefreshJids() {
        return this.mWaitRefreshJids;
    }

    public void clearWaitRefreshJids() {
        this.mWaitRefreshJids.clear();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        if (this.mItemAccountContacts != null && position == 0) {
            return this.mItemAccountContacts;
        }
        if (this.hasSearchMoreItem() && position == this.getCount() - 1) {
            return this.mItemSearchMore;
        }
        return this.mItems.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        if (this.mItemAccountContacts != null && position == 0) {
            return 1;
        }
        if (this.hasSearchMoreItem() && position == this.getCount() - 1) {
            return 2;
        }
        return 0;
    }

    public int getViewTypeCount() {
        return 4;
    }

    public void setLazyLoadAvatarDisabled(boolean disabled) {
        this.mLazyLoadAvatarDisabled = disabled;
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            View view = new View(this.mContext);
            return view;
        }
        Object obj = this.getItem(position);
        if (obj instanceof IMAddrBookItem) {
            IMAddrBookItem item = (IMAddrBookItem)obj;
            this.mWaitRefreshJids.add(item.getJid());
            return item.getView(this.mContext, convertView, this.mLazyLoadAvatarDisabled, false);
        }
        if (obj instanceof ItemOtherContacts) {
            ItemOtherContacts item = (ItemOtherContacts)obj;
            return item.getView(this.mContext, convertView, parent);
        }
        if (this.mItemSearchMore.equals(obj)) {
            return this.getSearchMoreItem(this.mContext, convertView, parent);
        }
        View view = new View(this.mContext);
        return view;
    }

    private View getSearchMoreItem(Context context, View convertView, ViewGroup parent) {
        View view = null;
        if (convertView != null && this.mItemSearchMore.equals(convertView.getTag())) {
            view = convertView;
        } else {
            LayoutInflater inflater = LayoutInflater.from((Context)context);
            view = inflater.inflate(R.layout.zm_addrbook_item_search_more, parent, false);
            view.setTag((Object)this.mItemSearchMore);
        }
        View btnSearchMore = view.findViewById(R.id.btnSearchMore);
        btnSearchMore.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IMAddrBookListAdapter.this.onClickSearchMore();
            }
        });
        return view;
    }

    private void onClickSearchMore() {
        if (this.mListView != null) {
            this.mListView.onClickSearchMore();
        }
    }

    public void filter(String filter) {
        this.mFilter = filter;
        if (!StringUtil.isEmptyOrNull((String)filter)) {
            this.filter(this.mItems, filter);
        }
    }

    private void filter(List<IMAddrBookItem> list, String filter) {
        for (int i = list.size() - 1; i >= 0; --i) {
            boolean emailAccepted;
            IMAddrBookItem item = list.get(i);
            String screenName = item.getScreenName();
            String email = item.getAccountEmail();
            boolean nameAccepted = screenName != null && screenName.toLowerCase(CompatUtils.getLocalDefault()).contains(filter);
            boolean bl = emailAccepted = email != null && email.toLowerCase(CompatUtils.getLocalDefault()).contains(filter);
            if (nameAccepted || emailAccepted) continue;
            list.remove(i);
        }
    }

    public String getItemSortKey(Object item) {
        if (item instanceof IMAddrBookItem) {
            IMAddrBookItem abItem = (IMAddrBookItem)item;
            String key = abItem.getSortKey();
            if (key == null) {
                key = "";
            }
            return key;
        }
        if (this.mItemSearchMore.equals(item)) {
            return String.valueOf(Short.MAX_VALUE);
        }
        return "*";
    }

    public static class ItemOtherContacts {
        public static final int TYPE_ZOOM_CONTACTS = 0;
        public static final int TYPE_GOOGLE_CONTACTS = 1;
        public static final int TYPE_FACEBOOK_CONTACTS = 2;
        public int type = 0;

        public ItemOtherContacts(int type) {
            this.type = type;
        }

        public View getView(Context context, View convertView, ViewGroup parent) {
            IMHelper imHelper;
            View view = null;
            if (convertView != null && "ItemOtherContacts".equals(convertView.getTag())) {
                view = convertView;
            } else {
                if (context == null) {
                    return null;
                }
                LayoutInflater factory = LayoutInflater.from((Context)context);
                view = factory.inflate(R.layout.zm_addrbook_item_other_contacts, parent, false);
                view.setTag((Object)"ItemOtherContacts");
            }
            TextView txtTitle = (TextView)view.findViewById(R.id.txtTitle);
            ImageView icon = (ImageView)view.findViewById(R.id.icon);
            switch (this.type) {
                case 0: {
                    txtTitle.setText(R.string.zm_lbl_zoom_contacts);
                    icon.setImageResource(R.drawable.zm_ic_other_contacts_fav);
                    break;
                }
                case 1: {
                    txtTitle.setText(R.string.zm_lbl_google_contacts);
                    icon.setImageResource(R.drawable.zm_ic_other_contacts_google);
                    break;
                }
                case 2: {
                    txtTitle.setText(R.string.zm_lbl_facebook_contacts);
                    icon.setImageResource(R.drawable.zm_ic_other_contacts_fb);
                }
            }
            TextView txtNoteBubble = (TextView)view.findViewById(R.id.txtNoteBubble);
            if (txtNoteBubble != null && (imHelper = PTApp.getInstance().getIMHelper()) != null) {
                int count = imHelper.getUnreadMsgCount();
                if (count == 0) {
                    txtNoteBubble.setVisibility(8);
                } else {
                    txtNoteBubble.setText((CharSequence)(count < 100 ? String.valueOf(count) : "99+"));
                    txtNoteBubble.setVisibility(0);
                }
            }
            return view;
        }
    }
}

