/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.meeting.confhelper.FeccComponent;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class FeccMessageButtonTip
extends ZMTipFragment
implements View.OnClickListener {
    private TextView mTxtButton;
    private long mUserId;

    public static void show(FragmentManager fragmentMgr, String tag, long userId, String message, String button) {
        FeccMessageButtonTip.show(fragmentMgr, tag, userId, message, button, 0L);
    }

    public static void show(FragmentManager fragmentMgr, String tag, long userId, String message, String button, long time) {
        FeccMessageButtonTip.show(fragmentMgr, tag, userId, -1, 0, message, button, 0, 0, time);
    }

    public static void show(FragmentManager fragmentMgr, String tag, long userId, int gravity, int margin, String message, String button) {
        FeccMessageButtonTip.show(fragmentMgr, tag, userId, gravity, margin, message, button, 0L);
    }

    public static void show(FragmentManager fragmentMgr, String tag, long userId, int gravity, int padding, String message, String button, long time) {
        FeccMessageButtonTip.show(fragmentMgr, tag, userId, gravity, padding, message, button, 0, 0, time);
    }

    public static void show(FragmentManager fragmentMgr, String tag, long userId, String message, String button, int anchor, int arrowDirection) {
        FeccMessageButtonTip.show(fragmentMgr, tag, userId, -1, 0, message, button, anchor, arrowDirection, 0L);
    }

    public static void show(FragmentManager fragmentMgr, String tag, long userId, int gravity, int padding, String message, String button, int anchor, int arrowDirection, long time) {
        Bundle args = new Bundle();
        args.putLong("userId", userId);
        args.putString("message", message);
        args.putString("button", button);
        args.putInt("anchor", anchor);
        args.putInt("arrowDirection", arrowDirection);
        args.putInt("gravity", gravity);
        args.putInt("padding", padding);
        FeccMessageButtonTip tip = new FeccMessageButtonTip();
        tip.setArguments(args);
        tip.show(fragmentMgr, tag, time);
    }

    public static boolean hasTip(FragmentManager fragmentMgr, String tag) {
        Fragment tip = fragmentMgr.findFragmentByTag(tag);
        return tip != null && tip instanceof FeccMessageButtonTip;
    }

    public static boolean dismiss(FragmentManager fragmentMgr, String tag) {
        Fragment tip = fragmentMgr.findFragmentByTag(tag);
        if (tip != null && tip instanceof FeccMessageButtonTip) {
            ((FeccMessageButtonTip)tip).dismiss();
            return true;
        }
        return false;
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        this.mUserId = args.getLong("userId");
        String message = args.getString("message");
        String button = args.getString("button");
        int anchor = args.getInt("anchor");
        int arrowDirection = args.getInt("arrowDirection");
        int gravity = args.getInt("gravity", -1);
        int padding = args.getInt("padding", 0);
        View view = layoutInflater.inflate(R.layout.zm_fecc_message_button_tip, null);
        TextView txtMessage = (TextView)view.findViewById(R.id.txtMessage);
        this.mTxtButton = (TextView)view.findViewById(R.id.txtButton);
        if (this.mTxtButton != null) {
            this.mTxtButton.setOnClickListener((View.OnClickListener)this);
        }
        txtMessage.setFocusable(false);
        txtMessage.setText((CharSequence)message);
        if (StringUtil.isEmptyOrNull((String)button)) {
            this.mTxtButton.setVisibility(8);
        } else {
            this.mTxtButton.setText((CharSequence)button);
        }
        View viewAnchor = this.getActivity().findViewById(anchor);
        ZMTip tip = new ZMTip(context);
        tip.setLayoutGravity(gravity, padding);
        tip.addView(view);
        tip.setAnchor(viewAnchor, arrowDirection);
        tip.setBackgroundColor(context.getResources().getColor(R.color.zm_message_tip_background));
        tip.setBorderColor(context.getResources().getColor(R.color.zm_message_tip_border));
        tip.setShadow(4.0f, 0, 0, context.getResources().getColor(R.color.zm_message_tip_shadow));
        return tip;
    }

    public void onClick(View v) {
        if (v == this.mTxtButton) {
            this.onClickTextButton();
        }
    }

    private void onClickTextButton() {
        FeccComponent feccComponent;
        this.dismiss();
        ConfActivity activity = (ConfActivity)this.getActivity();
        if (activity != null && (feccComponent = activity.getmFeccComponent()) != null) {
            feccComponent.onFeccUserApproved(this.mUserId);
        }
    }
}

