/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.zipow.videobox.util.FavoriteItemComparator;
import com.zipow.videobox.view.FavoriteItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.QuickSearchListView;

class FavoriteListAdapter
extends QuickSearchListView.QuickSearchListDataAdapter {
    private static final int ITEM_TYPE_NORMAL = 0;
    private List<FavoriteItem> mItems = new ArrayList<FavoriteItem>();
    private Context mContext;

    public FavoriteListAdapter(Context context) {
        assert (context != null);
        this.mContext = context;
    }

    public void clear() {
        this.mItems.clear();
    }

    public void addItem(FavoriteItem item) {
        this.updateItem(item);
    }

    public void updateItem(FavoriteItem item) {
        assert (item != null);
        int position = this.findItem(item.getUserID());
        if (position >= 0) {
            this.mItems.set(position, item);
        } else {
            this.mItems.add(item);
        }
    }

    public int findItem(String userId) {
        if (userId == null) {
            return -1;
        }
        for (int i = 0; i < this.mItems.size(); ++i) {
            FavoriteItem item = this.mItems.get(i);
            if (!userId.equals(item.getUserID())) continue;
            return i;
        }
        return -1;
    }

    public void removeItem(String userId) {
        int position = this.findItem(userId);
        if (position >= 0) {
            this.removeItemAt(position);
        }
    }

    public void removeItemAt(int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return;
        }
        this.mItems.remove(position);
    }

    public int getCount() {
        return this.mItems.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.mItems.get(position);
    }

    public FavoriteItem getItemByJid(String jid) {
        for (FavoriteItem item : this.mItems) {
            if (!item.getUserID().equals(jid)) continue;
            return item;
        }
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public int getViewTypeCount() {
        return 1;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        FavoriteItem item = (FavoriteItem)this.getItem(position);
        return item.getView(this.mContext, convertView);
    }

    public void sort(boolean compareUnreadMsgCount) {
        Collections.sort(this.mItems, new FavoriteItemComparator(CompatUtils.getLocalDefault()));
    }

    public String getItemSortKey(Object item) {
        if (item instanceof FavoriteItem) {
            FavoriteItem fvItem = (FavoriteItem)item;
            String key = fvItem.getSortKey();
            if (StringUtil.isEmptyOrNull((String)key)) {
                key = fvItem.getEmail();
            }
            if (key == null) {
                key = "";
            }
            return key;
        }
        return "";
    }
}

