/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.view.View;
import com.zipow.videobox.ptapp.FavoriteMgr;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomContact;
import com.zipow.videobox.view.FavoriteItemView;
import java.io.Serializable;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.androidlib.util.StringUtil;

public class FavoriteItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ZoomContact mZoomContact;
    private String mScreenName = "";
    private String mSortKey = "";

    public FavoriteItem() {
    }

    public FavoriteItem(ZoomContact contact) {
        this.mZoomContact = contact;
        String name = StringUtil.formatPersonName((String)this.mZoomContact.getFirstName(), (String)this.mZoomContact.getLastName(), (String)PTApp.getInstance().getRegionCodeForNameFormating());
        this.mScreenName = name.equals(this.getEmail()) ? "" : name;
        this.mSortKey = StringUtil.isEmptyOrNull((String)this.mScreenName) ? SortUtil.getSortKey((String)this.getEmail(), (Locale)CompatUtils.getLocalDefault()) : SortUtil.getSortKey((String)this.mScreenName, (Locale)CompatUtils.getLocalDefault());
    }

    public ZoomContact getZoomContact() {
        return this.mZoomContact;
    }

    public String getScreenName() {
        return this.mScreenName;
    }

    public String getSortKey() {
        return this.mSortKey;
    }

    public String getEmail() {
        if (this.mZoomContact == null) {
            return "";
        }
        return this.mZoomContact.getEmail();
    }

    public String getUserID() {
        if (this.mZoomContact == null) {
            return "";
        }
        return this.mZoomContact.getUserID();
    }

    public String getAvatar() {
        if (this.mZoomContact == null) {
            return null;
        }
        try {
            FavoriteMgr favoriteMgr = PTApp.getInstance().getFavoriteMgr();
            if (favoriteMgr != null) {
                return favoriteMgr.getLocalPicturePath(this.mZoomContact.getEmail());
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public View getView(Context context, View convertView) {
        FavoriteItemView view = null;
        view = convertView instanceof FavoriteItemView ? (FavoriteItemView)convertView : new FavoriteItemView(context);
        this.bindView(view);
        return view;
    }

    private void bindView(FavoriteItemView view) {
        view.setFavoriteItem(this);
    }
}

