/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.TextView;
import com.zipow.videobox.view.mm.sticker.CommonEmojiHelper;

public class EmojiTextView
extends TextView
implements CommonEmojiHelper.OnEmojiPackageInstallListener {
    public EmojiTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public EmojiTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public EmojiTextView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
    }

    protected void onAttachedToWindow() {
        CommonEmojiHelper.getInstance().addListener(this);
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        CommonEmojiHelper.getInstance().removeListener(this);
        super.onDetachedFromWindow();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        CommonEmojiHelper helper = CommonEmojiHelper.getInstance();
        text = helper.formatImgEmojiSize(this.getTextSize(), text, false);
        super.setText(text, type);
    }

    @Override
    public void onEmojiPkgDownload(int progress) {
    }

    @Override
    public void onEmojiPkgInstalled() {
        CharSequence text = this.getText();
        CommonEmojiHelper helper = CommonEmojiHelper.getInstance();
        text = helper.formatImgEmojiSize(this.getTextSize(), text, true);
        super.setText(text);
    }

    @Override
    public void onEmojiPkgDownloadFailed() {
    }
}

