/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.TextView;
import com.zipow.videobox.view.ConfToolbar;
import com.zipow.videobox.view.ConfToolsPanel;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class ConfToolsPanelLarge
extends ConfToolsPanel {
    public ConfToolsPanelLarge(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public ConfToolsPanelLarge(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ConfToolsPanelLarge(Context context) {
        super(context);
    }

    @Override
    public void showToolbar(boolean show, boolean animation) {
        final ConfToolbar toolbar = (ConfToolbar)this.findViewById(R.id.confToolbar);
        if (toolbar.getVisibility() == 0 == show) {
            return;
        }
        if (!animation) {
            toolbar.setVisibility(show ? 0 : 8);
            this.mbVisible = show;
            ConfToolsPanel.Listener l = this.getListener();
            if (l != null) {
                l.onToolbarVisiblilyChanged(show);
            }
            return;
        }
        if (!show) {
            this.mbVisible = false;
            ConfToolsPanel.Listener l = this.getListener();
            if (l != null) {
                l.onToolbarVisiblilyChanged(false);
            }
        }
        TranslateAnimation anim2 = null;
        if (show) {
            this.setVisibility(0);
            toolbar.setVisibility(0);
            anim2 = new TranslateAnimation(0.0f, 0.0f, (float)(-this.getHeight()), 0.0f);
            anim2.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    ConfToolsPanelLarge.this.mbVisible = true;
                    ConfToolsPanel.Listener l = ConfToolsPanelLarge.this.getListener();
                    if (l != null) {
                        l.onToolbarVisiblilyChanged(true);
                    }
                }
            });
        } else {
            anim2 = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-this.getHeight()));
            anim2.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    ConfToolsPanelLarge.this.setVisibility(8);
                    toolbar.setVisibility(8);
                }
            });
        }
        anim2.setInterpolator((Interpolator)new DecelerateInterpolator());
        anim2.setDuration(0L);
        this.startAnimation((Animation)anim2);
    }

    @Override
    public void setConfNumber(long confNumber) {
        TextView txtTitle = (TextView)this.findViewById(R.id.txtTitle);
        txtTitle.setText((CharSequence)this.getContext().getString(R.string.zm_title_conf_long, new Object[]{StringUtil.formatConfNumber((long)confNumber)}));
    }
}

