/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.PListButton;
import com.zipow.videobox.view.ToolbarButton;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.videomeetings.R;

public class ConfToolbar
extends LinearLayout
implements View.OnClickListener {
    private static final String TAG = ConfToolbar.class.getSimpleName();
    public static final int BUTTON_ALL = 255;
    public static final int BUTTON_VIDEO = 1;
    public static final int BUTTON_AUDIO = 2;
    public static final int BUTTON_SHARE = 4;
    public static final int BUTTON_PARTICIPANTS = 8;
    public static final int BUTTON_LEAVE = 16;
    public static final int BUTTON_MORE = 32;
    public static final int BUTTON_RAISEHAND = 64;
    public static final int BUTTON_QA = 128;
    public static final int BUTTON_CHATS = 256;
    public static final int BUTTON_VIEWONLY = 448;
    private static final int DISPLAY_ANIM_DURATION = 200;
    private Listener mListener;
    private ToolbarButton mBtnVideo;
    private ToolbarButton mBtnAudio;
    private PListButton mBtnPList;
    private ToolbarButton mBtnLeave;
    private ToolbarButton mBtnShare;
    private ToolbarButton mBtnStopShare;
    private ToolbarButton mBtnMore;
    private ToolbarButton mBtnRaiseHand;
    private ToolbarButton mBtnLowerHand;
    private ToolbarButton mBtnQA;
    private PListButton mBtnChats;
    private boolean mbAudioMuted = false;
    private boolean mbVideoMuted = false;
    private long mAudioType = 0L;
    private int mButtons = 255;

    public ConfToolbar(Context context) {
        this(context, null);
    }

    public ConfToolbar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
        this.setFocusable(false);
    }

    public boolean hasEnableBUtton(int btnBit) {
        return (this.mButtons & btnBit) > 0;
    }

    private void init() {
        if (this.isInEditMode() || !UIMgr.isLargeMode(this.getContext())) {
            View.inflate((Context)this.getContext(), (int)R.layout.zm_conf_toolbar, (ViewGroup)this);
        } else {
            View.inflate((Context)this.getContext(), (int)R.layout.zm_conf_toolbar_large, (ViewGroup)this);
        }
        this.mBtnAudio = (ToolbarButton)this.findViewById(R.id.btnAudio);
        this.mBtnVideo = (ToolbarButton)this.findViewById(R.id.btnVideo);
        this.mBtnLeave = (ToolbarButton)this.findViewById(R.id.btnLeave);
        this.mBtnPList = (PListButton)this.findViewById(R.id.btnPList);
        this.mBtnShare = (ToolbarButton)this.findViewById(R.id.btnShare);
        this.mBtnStopShare = (ToolbarButton)this.findViewById(R.id.btnStopShare);
        this.mBtnMore = (ToolbarButton)this.findViewById(R.id.btnMore);
        this.mBtnRaiseHand = (ToolbarButton)this.findViewById(R.id.btnRaiseHand);
        this.mBtnLowerHand = (ToolbarButton)this.findViewById(R.id.btnLowerHand);
        this.mBtnQA = (ToolbarButton)this.findViewById(R.id.btnQA);
        this.mBtnChats = (PListButton)this.findViewById(R.id.btnChats);
        if (this.mBtnAudio != null) {
            this.mBtnAudio.setOnClickListener(this);
        }
        if (this.mBtnVideo != null) {
            this.mBtnVideo.setOnClickListener(this);
        }
        if (this.mBtnLeave != null) {
            this.mBtnLeave.setOnClickListener(this);
        }
        if (this.mBtnPList != null) {
            this.mBtnPList.setOnClickListener(this);
        }
        if (this.mBtnShare != null) {
            this.mBtnShare.setOnClickListener(this);
        }
        if (this.mBtnStopShare != null) {
            this.mBtnStopShare.setOnClickListener(this);
        }
        if (this.mBtnMore != null) {
            this.mBtnMore.setOnClickListener(this);
        }
        if (this.mBtnRaiseHand != null) {
            this.mBtnRaiseHand.setOnClickListener(this);
        }
        if (this.mBtnLowerHand != null) {
            this.mBtnLowerHand.setOnClickListener(this);
        }
        if (this.mBtnQA != null) {
            this.mBtnQA.setOnClickListener(this);
        }
        if (this.mBtnChats != null) {
            this.mBtnChats.setOnClickListener(this);
        }
    }

    public void setListener(Listener l) {
        this.mListener = l;
    }

    public void setAudioMuted(boolean muted) {
        if (this.mBtnAudio == null) {
            return;
        }
        boolean bOriginalMuted = this.mbAudioMuted;
        this.mbAudioMuted = muted;
        if (this.mAudioType == 2L) {
            this.mBtnAudio.setImageResource(R.drawable.zm_btn_audio_none);
            if (bOriginalMuted != this.mbAudioMuted && AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getContext())) {
                this.mBtnAudio.setContentDescription(this.getContext().getString(R.string.zm_description_toolbar_btn_status_audio_disconnect));
                this.mBtnAudio.sendAccessibilityEvent(8);
            }
        } else {
            if (this.mAudioType == 1L) {
                this.mBtnAudio.setImageResource(this.mbAudioMuted ? R.drawable.zm_btn_unmute_phone : R.drawable.zm_btn_mute_phone);
            } else {
                this.mBtnAudio.setImageResource(this.mbAudioMuted ? R.drawable.zm_btn_unmute_audio : R.drawable.zm_btn_mute_audio);
            }
            if (bOriginalMuted != this.mbAudioMuted) {
                this.mBtnAudio.setContentDescription(this.getContext().getString(this.mbAudioMuted ? R.string.zm_description_toolbar_btn_status_audio_unmuted_17843 : R.string.zm_description_toolbar_btn_status_audio_muted_17843));
                this.mBtnAudio.sendAccessibilityEvent(8);
            } else if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getContext()) && AccessibilityUtil.getIsAccessibilityFocused((View)this.mBtnAudio)) {
                AccessibilityUtil.announceNoInterruptForAccessibilityCompat((View)this.mBtnAudio, (int)(this.mbAudioMuted ? R.string.zm_description_toolbar_btn_status_audio_already_muted_17843 : R.string.zm_description_toolbar_btn_status_audio_already_unmuted_17843));
            }
        }
        if (!UIMgr.isLargeMode(this.getContext())) {
            this.mBtnAudio.setText(R.string.zm_btn_audio);
        }
    }

    public void setVideoMuted(boolean muted) {
        if (this.mBtnVideo == null) {
            return;
        }
        boolean bOriginalMuted = this.mbVideoMuted;
        this.mbVideoMuted = muted;
        this.mBtnVideo.setImageResource(muted ? R.drawable.zm_btn_unmute_video : R.drawable.zm_btn_mute_video);
        if (bOriginalMuted != this.mbVideoMuted) {
            this.mBtnVideo.setContentDescription(this.getContext().getString(this.mbVideoMuted ? R.string.zm_description_toolbar_btn_status_video_unmuted_17843 : R.string.zm_description_toolbar_btn_status_video_muted_17843));
            this.mBtnVideo.sendAccessibilityEvent(8);
        } else if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getContext()) && AccessibilityUtil.getIsAccessibilityFocused((View)this.mBtnVideo)) {
            AccessibilityUtil.announceNoInterruptForAccessibilityCompat((View)this.mBtnVideo, (int)(this.mbVideoMuted ? R.string.zm_description_toolbar_btn_status_video_already_muted_17843 : R.string.zm_description_toolbar_btn_status_video_already_unmuted_17843));
        }
        this.mBtnVideo.setText(R.string.zm_btn_video);
    }

    public void setChatsButton(int countUnreadMsg) {
        if (this.mBtnChats != null && this.mBtnChats.getVisibility() == 0) {
            this.mBtnChats.setUnreadMessageCount(countUnreadMsg);
        } else if (this.mBtnPList != null) {
            this.mBtnPList.setUnreadMessageCount(countUnreadMsg);
        }
    }

    public void setQANoteMsgButton(int count) {
        if (this.mBtnQA == null) {
            return;
        }
        this.mBtnQA.setNoteMessage(count == 0 ? null : (count < 100 ? String.valueOf(count) : "99+"));
    }

    public void setButtons(int buttonsMask) {
        if (!UIMgr.isLargeMode(this.getContext())) {
            buttonsMask &= 0xFFFFFFEF;
        }
        this.mButtons = buttonsMask;
        if (this.mBtnAudio != null) {
            this.mBtnAudio.setVisibility((buttonsMask & 2) != 0 ? 0 : 8);
        }
        if (this.mBtnVideo != null) {
            this.mBtnVideo.setVisibility((buttonsMask & 1) != 0 ? 0 : 8);
        }
        if (this.mBtnLeave != null) {
            this.mBtnLeave.setVisibility((buttonsMask & 0x10) != 0 ? 0 : 8);
        }
        if (this.mBtnPList != null) {
            this.mBtnPList.setVisibility((buttonsMask & 8) != 0 ? 0 : 8);
        }
        if (this.mBtnShare != null) {
            this.mBtnShare.setVisibility((buttonsMask & 4) != 0 && !this.isSharing() ? 0 : 8);
        }
        if (this.mBtnStopShare != null) {
            this.mBtnStopShare.setVisibility((buttonsMask & 4) != 0 && this.isSharing() ? 0 : 8);
        }
        if (this.mBtnMore != null) {
            this.mBtnMore.setVisibility((buttonsMask & 0x20) != 0 ? 0 : 8);
        }
        if (this.mBtnRaiseHand != null) {
            this.mBtnRaiseHand.setVisibility((buttonsMask & 0x40) != 0 ? 0 : 8);
            if ((buttonsMask & 0x40) == 0) {
                this.mBtnLowerHand.setVisibility(8);
            }
        }
        if (this.mBtnQA != null) {
            this.mBtnQA.setVisibility((buttonsMask & 0x80) != 0 ? 0 : 8);
        }
        if (this.mBtnChats != null) {
            this.mBtnChats.setVisibility((buttonsMask & 0x100) != 0 ? 0 : 8);
        }
    }

    private boolean isSharing() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return false;
        }
        return shareMgr.getShareStatus() == 2;
    }

    public int getButtons() {
        return this.mButtons;
    }

    public void setHostRole(boolean isHost) {
        if (this.mBtnPList != null) {
            this.mBtnPList.setHostRole(isHost);
        }
    }

    public void setAudioType(long audioType) {
        if (this.mBtnAudio == null) {
            return;
        }
        long originalAudioType = this.mAudioType;
        this.mAudioType = audioType;
        if (this.mAudioType == 2L) {
            this.mBtnAudio.setImageResource(R.drawable.zm_btn_audio_none);
            if (originalAudioType != this.mAudioType) {
                this.mBtnAudio.setContentDescription(this.getContext().getString(R.string.zm_description_toolbar_btn_status_audio_disconnect));
                this.mBtnAudio.sendAccessibilityEvent(8);
            }
        } else {
            if (this.mAudioType == 1L) {
                this.mBtnAudio.setImageResource(this.mbAudioMuted ? R.drawable.zm_btn_unmute_phone : R.drawable.zm_btn_mute_phone);
            } else {
                this.mBtnAudio.setImageResource(this.mbAudioMuted ? R.drawable.zm_btn_unmute_audio : R.drawable.zm_btn_mute_audio);
            }
            if (originalAudioType != this.mAudioType) {
                this.mBtnAudio.setContentDescription(this.getContext().getString(this.mbAudioMuted ? R.string.zm_description_toolbar_btn_status_audio_unmuted_17843 : R.string.zm_description_toolbar_btn_status_audio_muted_17843));
                this.mBtnAudio.sendAccessibilityEvent(8);
            } else if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getContext()) && AccessibilityUtil.getIsAccessibilityFocused((View)this.mBtnAudio)) {
                AccessibilityUtil.announceNoInterruptForAccessibilityCompat((View)this.mBtnAudio, (int)(this.mbAudioMuted ? R.string.zm_description_toolbar_btn_status_audio_already_muted_17843 : R.string.zm_description_toolbar_btn_status_audio_already_unmuted_17843));
            }
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.btnAudio) {
            if (this.mListener != null) {
                this.mListener.onClickBtnAudio();
            }
        } else if (id2 == R.id.btnVideo) {
            if (this.mListener != null) {
                this.mListener.onClickBtnVideo();
            }
        } else if (id2 == R.id.btnLeave) {
            if (this.mListener != null) {
                this.mListener.onClickLeave();
            }
        } else if (id2 == R.id.btnPList) {
            if (this.mListener != null) {
                this.mListener.onClickParticipants();
            }
        } else if (id2 == R.id.btnShare) {
            if (this.mListener != null) {
                this.mListener.onClickShare();
            }
        } else if (id2 == R.id.btnStopShare) {
            if (this.mListener != null) {
                this.mListener.onClickStopShare();
            }
        } else if (id2 == R.id.btnMore) {
            if (this.mListener != null) {
                this.mListener.onClickMore();
            }
        } else if (id2 == R.id.btnRaiseHand) {
            if (this.mListener != null) {
                this.mListener.onClickAttendeeRaiseHand();
            }
        } else if (id2 == R.id.btnLowerHand) {
            if (this.mListener != null) {
                this.mListener.onClickAttendeeLowerHand();
            }
        } else if (id2 == R.id.btnQA) {
            if (this.mListener != null) {
                this.mListener.onClickQA();
            }
        } else if (id2 == R.id.btnChats && this.mListener != null) {
            this.mListener.onClickChats();
        }
    }

    public void showRaiseHand() {
        if (this.mBtnLowerHand != null) {
            this.mBtnLowerHand.setVisibility(8);
        }
        if (this.mBtnRaiseHand != null) {
            this.mBtnRaiseHand.setVisibility(0);
        }
    }

    public void showLowerHand() {
        if (this.mBtnLowerHand != null) {
            this.mBtnLowerHand.setVisibility(0);
        }
        if (this.mBtnRaiseHand != null) {
            this.mBtnRaiseHand.setVisibility(8);
        }
    }

    public void disableRaiseHand() {
        if (this.mBtnRaiseHand != null) {
            this.mBtnRaiseHand.setVisibility(8);
        }
        if (this.mBtnLowerHand != null) {
            this.mBtnLowerHand.setVisibility(8);
        }
    }

    public void show(boolean show, boolean animation) {
        if (this.getVisibility() == 0 == show) {
            return;
        }
        if (animation) {
            TranslateAnimation anim2 = null;
            if (show) {
                this.setVisibility(0);
                anim2 = new TranslateAnimation(0.0f, 0.0f, (float)this.getHeight(), 0.0f);
                anim2.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }

                    public void onAnimationEnd(Animation animation) {
                        if (ConfToolbar.this.mListener != null) {
                            ConfToolbar.this.mListener.onToolbarVisiblilyChanged(true);
                        }
                    }
                });
            } else {
                anim2 = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)this.getHeight());
                anim2.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }

                    public void onAnimationEnd(Animation animation) {
                        ConfToolbar.this.setVisibility(8);
                        if (ConfToolbar.this.mListener != null) {
                            ConfToolbar.this.mListener.onToolbarVisiblilyChanged(false);
                        }
                    }
                });
            }
            anim2.setInterpolator((Interpolator)new DecelerateInterpolator());
            anim2.setDuration(200L);
            this.startAnimation((Animation)anim2);
        } else {
            this.setVisibility(show ? 0 : 8);
            if (this.mListener != null) {
                this.mListener.onToolbarVisiblilyChanged(show);
            }
        }
    }

    public void focusFirstVisibleButton() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = this.getChildAt(i);
            if (view == null || view.getVisibility() != 0) continue;
            view.requestFocus();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void focus(int type) {
        switch (type) {
            case 2: {
                if (this.mBtnAudio != null) {
                    this.mBtnAudio.requestFocus();
                }
            }
            case 1: {
                if (this.mBtnVideo != null) {
                    this.mBtnVideo.requestFocus();
                }
            }
            case 4: {
                if (this.mBtnShare == null || this.mBtnStopShare == null) ** GOTO lbl19
                if (this.mBtnShare.getVisibility() != 0) ** GOTO lbl16
                this.mBtnShare.requestFocus();
                ** GOTO lbl19
lbl16:
                // 1 sources

                if (this.mBtnStopShare.getVisibility() == 0) {
                    this.mBtnStopShare.requestFocus();
                }
            }
lbl19:
            // 6 sources

            case 8: {
                if (this.mBtnPList != null) {
                    this.mBtnPList.requestFocus();
                }
            }
            case 32: {
                if (this.mBtnMore != null) {
                    this.mBtnMore.requestFocus();
                }
            }
            case 64: {
                if (this.mBtnRaiseHand == null || this.mBtnLowerHand == null) ** GOTO lbl36
                if (this.mBtnRaiseHand.getVisibility() != 0) ** GOTO lbl33
                this.mBtnRaiseHand.requestFocus();
                ** GOTO lbl36
lbl33:
                // 1 sources

                if (this.mBtnLowerHand.getVisibility() == 0) {
                    this.mBtnLowerHand.requestFocus();
                }
            }
lbl36:
            // 6 sources

            case 128: {
                if (this.mBtnQA != null) {
                    this.mBtnQA.requestFocus();
                }
            }
            case 256: {
                if (this.mBtnQA != null) {
                    this.mBtnQA.requestFocus();
                }
            }
            case 16: {
                if (this.mBtnLeave == null) break;
                this.mBtnLeave.requestFocus();
            }
        }
    }

    public static interface Listener {
        public void onClickBtnAudio();

        public void onClickBtnVideo();

        public void onClickParticipants();

        public void onClickLeave();

        public void onClickShare();

        public void onClickStopShare();

        public void onClickMore();

        public void onClickAttendeeRaiseHand();

        public void onClickAttendeeLowerHand();

        public void onClickQA();

        public void onClickChats();

        public void onToolbarVisiblilyChanged(boolean var1);
    }
}

