/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AutoCompleteTextView;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.videobox.CmmSavedMeeting;
import com.zipow.videobox.view.ConfNumberMgr;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class ConfNumberAutoCompleteTextView
extends AutoCompleteTextView {
    private static MyKeyListener mKeyListener = new MyKeyListener();
    public static final int FORMAT_TYPE_DEFAULT = 0;
    public static final int FORMAT_TYPE_34X = 1;
    public static final int FORMAT_TYPE_43X = 2;
    private int mFormatType = 0;
    private TextWatcher mTextChangedListener;

    public ConfNumberAutoCompleteTextView(Context context) {
        super(context);
        this.init();
    }

    public ConfNumberAutoCompleteTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ConfNumberAutoCompleteTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.setKeyListener((KeyListener)mKeyListener);
        this.mTextChangedListener = new TextWatcher(){
            boolean bAppend = false;
            boolean bDelete = false;
            boolean bInsert = false;
            int bStart = 0;

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                this.bAppend = s.length() == start && count == 0;
                this.bDelete = count > 0 && after == 0;
                this.bInsert = s.length() > start && count == 0;
                this.bStart = start;
            }

            public void afterTextChanged(Editable s) {
                ConfNumberAutoCompleteTextView.this.removeTextChangedListener(this);
                int selection = Selection.getSelectionEnd((CharSequence)s);
                Editable et = ConfNumberAutoCompleteTextView.this.getEditableText();
                ConfNumberMgr.formatText(et, ConfNumberAutoCompleteTextView.this.mFormatType);
                int formatSel = Selection.getSelectionEnd((CharSequence)et);
                if (formatSel > 0 && formatSel <= et.length()) {
                    if (this.bDelete && et.charAt(formatSel - 1) == ' ' && s.charAt(selection - 1) != ' ') {
                        --formatSel;
                    }
                    if (this.bInsert && this.bStart < formatSel && et.charAt(formatSel - 1) == ' ') {
                        --formatSel;
                    }
                }
                Selection.setSelection((Spannable)et, (int)formatSel);
                ConfNumberAutoCompleteTextView.this.addTextChangedListener(this);
            }
        };
        this.addTextChangedListener(this.mTextChangedListener);
        ArrayList<CmmSavedMeeting> meetings = new ArrayList<CmmSavedMeeting>();
        if (!this.isInEditMode()) {
            meetings.addAll(ConfNumberMgr.loadConfNumberFromDB());
        }
        AutoCompleteAdapter adapter = new AutoCompleteAdapter(this.getContext(), R.layout.zm_simple_dropdown_item_1line, meetings);
        this.setAdapter((ListAdapter)adapter);
    }

    public void clearHistory() {
        AutoCompleteAdapter adapter = new AutoCompleteAdapter(this.getContext(), R.layout.zm_simple_dropdown_item_1line, new ArrayList<CmmSavedMeeting>());
        this.setAdapter((ListAdapter)adapter);
    }

    public void setFormatType(int formatType) {
        this.mFormatType = formatType;
        if (this.mTextChangedListener != null) {
            this.removeTextChangedListener(this.mTextChangedListener);
        }
        Editable et = this.getEditableText();
        ConfNumberMgr.formatText(et, this.mFormatType);
        if (this.mTextChangedListener != null) {
            this.addTextChangedListener(this.mTextChangedListener);
        }
    }

    public int getFormatType() {
        return this.mFormatType;
    }

    private class AutoCompleteAdapter
    extends BaseAdapter
    implements Filterable {
        private ArrayList<CmmSavedMeeting> mOriginalValues;
        private AutoCompleteFilter mFilter;
        private List<CmmSavedMeeting> mValues;
        private Context mContext;
        private LayoutInflater mInflater;
        private int mResource;
        private final Object mLock = new Object();

        public AutoCompleteAdapter(Context context, int resource, List<CmmSavedMeeting> objects) {
            this.init(context, resource, objects);
        }

        private void init(Context context, int resource, List<CmmSavedMeeting> objects) {
            this.mContext = context;
            this.mInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            this.mResource = resource;
            this.mValues = objects;
        }

        public int getCount() {
            return this.mValues.size();
        }

        public String getItem(int position) {
            CmmSavedMeeting item = this.getObjectItem(position);
            if (item == null) {
                return "";
            }
            String id2 = item.getmConfID();
            if (id2 == null) {
                return "";
            }
            Editable et = Editable.Factory.getInstance().newEditable((CharSequence)id2);
            ConfNumberMgr.formatText(et, ConfNumberAutoCompleteTextView.this.mFormatType);
            return et.toString();
        }

        private CmmSavedMeeting getObjectItem(int position) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            return this.mValues.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View view = convertView == null ? this.mInflater.inflate(this.mResource, parent, false) : convertView;
            CmmSavedMeeting item = this.getObjectItem(position);
            if (item != null) {
                Editable et = Editable.Factory.getInstance().newEditable((CharSequence)item.getmConfID());
                ConfNumberMgr.formatText(et, ConfNumberAutoCompleteTextView.this.mFormatType);
                TextView txtId = (TextView)view.findViewById(R.id.txtId);
                TextView txtTopic = (TextView)view.findViewById(R.id.txtTopic);
                txtId.setText((CharSequence)et.toString());
                txtTopic.setText((CharSequence)item.getmConfTopic());
            }
            return view;
        }

        public Filter getFilter() {
            if (this.mFilter == null) {
                this.mFilter = new AutoCompleteFilter();
            }
            return this.mFilter;
        }

        private class AutoCompleteFilter
        extends Filter {
            private AutoCompleteFilter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Filter.FilterResults performFiltering(CharSequence prefix) {
                Filter.FilterResults results = new Filter.FilterResults();
                if (AutoCompleteAdapter.this.mOriginalValues == null) {
                    Object object = AutoCompleteAdapter.this.mLock;
                    synchronized (object) {
                        AutoCompleteAdapter.this.mOriginalValues = new ArrayList(AutoCompleteAdapter.this.mValues);
                    }
                }
                if (prefix == null || prefix.length() == 0) {
                    ArrayList list;
                    Object object = AutoCompleteAdapter.this.mLock;
                    synchronized (object) {
                        list = new ArrayList(AutoCompleteAdapter.this.mOriginalValues);
                    }
                    results.values = list;
                    results.count = list.size();
                } else {
                    ArrayList values;
                    String prefixString = prefix.toString();
                    prefixString = prefixString.replaceAll("\\D", "");
                    Object object = AutoCompleteAdapter.this.mLock;
                    synchronized (object) {
                        values = new ArrayList(AutoCompleteAdapter.this.mOriginalValues);
                    }
                    int count = values.size();
                    ArrayList<CmmSavedMeeting> newValues = new ArrayList<CmmSavedMeeting>();
                    for (int i = 0; i < count; ++i) {
                        CmmSavedMeeting value = (CmmSavedMeeting)values.get(i);
                        String confId = value.getmConfID();
                        if (StringUtil.isEmptyOrNull((String)confId) || !confId.startsWith(prefixString)) continue;
                        newValues.add(value);
                    }
                    results.values = newValues;
                    results.count = newValues.size();
                }
                return results;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                AutoCompleteAdapter.this.mValues = (List)results.values;
                if (results.count > 0) {
                    AutoCompleteAdapter.this.notifyDataSetChanged();
                } else {
                    AutoCompleteAdapter.this.notifyDataSetInvalidated();
                }
            }
        }
    }

    private static class MyKeyListener
    extends DigitsKeyListener {
        private static final char[] mAcceptedChars = "0123456789 ".toCharArray();

        public MyKeyListener() {
            super(false, false);
        }

        protected char[] getAcceptedChars() {
            return mAcceptedChars;
        }
    }
}

