/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.ConfChatMessage;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.view.ConfChatItem;
import com.zipow.videobox.view.ConfChatListAdapter;
import java.util.ArrayList;
import java.util.List;

public class ConfChatListViewOld
extends ListView {
    private ConfChatListAdapter mAdapter;
    private List<String> mPendingItems = new ArrayList<String>();
    private Runnable mNewMsgRefreshTask;
    private Handler mHandler = new Handler();
    private static final int TIME_NEW_MESSAGE_REFRESH_DELAY = 1000;

    public ConfChatListViewOld(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public ConfChatListViewOld(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ConfChatListViewOld(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.mAdapter = new ConfChatListAdapter(this.getContext());
        if (this.isInEditMode()) {
            this._editmode_loadAllMessageItems(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    private void _editmode_loadAllMessageItems(ConfChatListAdapter adapter) {
        for (int i = 0; i < 5; ++i) {
            ConfChatItem item = new ConfChatItem();
            item.senderName = i % 2 == 0 ? "Zoom" : "Reed Yang";
            item.content = "Hi, Zoom! I like you!";
            item.time = System.currentTimeMillis();
            item.type = i % 2 == 0 ? 0 : 1;
            adapter.addItem(item);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int lastVisiblePos = this.getLastVisiblePosition();
        super.onLayout(changed, l, t, r, b);
        if (!changed) {
            return;
        }
        if (lastVisiblePos >= 0) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ConfChatListViewOld.this.scrollToBottom(true);
                }
            });
        }
    }

    public void loadMessages(long userId) {
        ConfMgr confMgr = ConfMgr.getInstance();
        String[] msgIds = confMgr.getChatMessagesByUser(userId, false);
        ConfChatItem item = null;
        if (msgIds != null) {
            for (int i = 0; i < msgIds.length; ++i) {
                ConfChatMessage message = confMgr.getChatMessageItemByID(msgIds[i]);
                if (message == null) continue;
                confMgr.setChatMessageAsReaded(msgIds[i]);
                if (item != null && message.getTimeStamp() - item.time <= 60000L && item.sender == message.getSenderID() && message.getReceiverID() == item.receiver) {
                    item.content = item.content + "\n" + message.getMessageContent();
                    continue;
                }
                if (item != null) {
                    this.mAdapter.addItem(item);
                }
                item = new ConfChatItem(message);
            }
        }
        if (item != null) {
            this.mAdapter.addItem(item);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void onChatMessageReceived(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        boolean fromMe = confStatus != null && confStatus.isMyself(sender);
        this.addChatMessage(msgID, fromMe);
    }

    private void addChatMessage(String msgId, boolean isMeSend) {
        this.mPendingItems.add(msgId);
        if (this.mNewMsgRefreshTask == null) {
            this.mNewMsgRefreshTask = new Runnable(){

                @Override
                public void run() {
                    ConfMgr confMgr = ConfMgr.getInstance();
                    if (confMgr == null) {
                        return;
                    }
                    if (ConfChatListViewOld.this.mPendingItems.size() > 0) {
                        for (String msgID : ConfChatListViewOld.this.mPendingItems) {
                            ConfChatItem item;
                            ConfChatMessage message = confMgr.getChatMessageItemByID(msgID);
                            if (message == null) {
                                return;
                            }
                            int count = ConfChatListViewOld.this.mAdapter.getCount();
                            boolean addNew = true;
                            if (count > 0 && (item = (ConfChatItem)ConfChatListViewOld.this.mAdapter.getItem(count - 1)) != null && message.getTimeStamp() - item.time <= 60000L && item.sender == message.getSenderID() && item.receiver == message.getReceiverID()) {
                                item.content = item.content + "\n" + message.getMessageContent();
                                addNew = false;
                            }
                            if (!addNew) continue;
                            item = new ConfChatItem(message);
                            ConfChatListViewOld.this.mAdapter.addItem(item);
                        }
                        ConfChatListViewOld.this.mAdapter.notifyDataSetChanged();
                        ConfChatListViewOld.this.scrollToBottom(false);
                    }
                    ConfChatListViewOld.this.mPendingItems.clear();
                    ConfChatListViewOld.this.mHandler.postDelayed(ConfChatListViewOld.this.mNewMsgRefreshTask, 1000L);
                }
            };
            this.mHandler.post(this.mNewMsgRefreshTask);
        } else if (isMeSend) {
            this.mHandler.removeCallbacks(this.mNewMsgRefreshTask);
            this.mNewMsgRefreshTask.run();
            this.mHandler.postDelayed(this.mNewMsgRefreshTask, 1000L);
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mNewMsgRefreshTask != null) {
            this.mHandler.removeCallbacks(this.mNewMsgRefreshTask);
            this.mNewMsgRefreshTask = null;
        }
        super.onDetachedFromWindow();
    }

    public void scrollToBottom(boolean force) {
        int lastVisiblePos = this.getLastVisiblePosition();
        final int lastPos = this.getCount() - 1;
        if (force) {
            if (lastPos == lastVisiblePos && this.getChildCount() == 1) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        int topPadding = 0;
                        View item = ConfChatListViewOld.this.getChildAt(0);
                        if (item == null) {
                            return;
                        }
                        if (item.getHeight() > ConfChatListViewOld.this.getHeight()) {
                            topPadding = ConfChatListViewOld.this.getHeight() - item.getHeight();
                        }
                        ConfChatListViewOld.this.setSelectionFromTop(lastPos, topPadding);
                    }
                });
            } else {
                this.setSelection(lastPos);
            }
        } else if (lastPos - lastVisiblePos < 5) {
            if (lastPos == lastVisiblePos && this.getChildCount() == 1) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        int topPadding = 0;
                        View item = ConfChatListViewOld.this.getChildAt(0);
                        if (item == null) {
                            return;
                        }
                        if (item.getHeight() > ConfChatListViewOld.this.getHeight()) {
                            topPadding = ConfChatListViewOld.this.getHeight() - item.getHeight();
                        }
                        if (Build.VERSION.SDK_INT >= 16) {
                            ConfChatListViewOld.this.smoothScrollToPositionFromTop(lastPos, topPadding);
                        } else {
                            ConfChatListViewOld.this.setSelectionFromTop(lastPos, topPadding);
                        }
                    }
                });
            } else if (Build.VERSION.SDK_INT >= 16) {
                this.smoothScrollToPosition(lastPos);
            } else {
                this.setSelection(lastPos);
            }
        }
    }
}

