/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zipow.videobox.view.ConfChatItem;
import java.util.ArrayList;
import java.util.List;

public class ConfChatListAdapter
extends BaseAdapter {
    public static final int ITEM_TYPE_PUBLIC = 0;
    public static final int ITEM_TYPE_PRIVATE = 1;
    private List<ConfChatItem> items = new ArrayList<ConfChatItem>();
    private Context mContext;

    public ConfChatListAdapter(Context context) {
        assert (context != null);
        this.mContext = context;
    }

    public void clear() {
        this.items.clear();
    }

    public void addItem(ConfChatItem item) {
        assert (item != null);
        int position = this.findItem(item.id);
        if (position >= 0) {
            this.items.set(position, item);
        } else {
            this.items.add(item);
        }
    }

    public int findItem(String msgId) {
        if (msgId == null) {
            return -1;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            ConfChatItem item = this.items.get(i);
            if (!msgId.equals(item.id)) continue;
            return i;
        }
        return -1;
    }

    public int getCount() {
        return this.items.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        int type = 0;
        ConfChatItem item = (ConfChatItem)this.getItem(position);
        if (item != null) {
            type = item.type;
        }
        return type;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        ConfChatItem item = (ConfChatItem)this.getItem(position);
        if (item == null) {
            return null;
        }
        return item.getView(this.mContext, convertView);
    }
}

