/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.ZoomChatInWebinar;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.ZMConfUtil;
import com.zipow.videobox.view.ConfChatAttendeeItem;
import java.util.ArrayList;
import java.util.List;
import us.zoom.videomeetings.R;

public class ConfChatBuddyListView
extends ListView {
    private WebinarChatBuddyAdapter mWebinarChatBuddyAdapter;
    private boolean needRefresh = false;
    private static final int MSG_REFRESH = 1;
    private static final int DEFALUT_ROLE = -1;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (ConfChatBuddyListView.this.needRefresh) {
                        ConfChatBuddyListView.this.loadAllItems();
                        ConfChatBuddyListView.this.needRefresh = false;
                    }
                    this.sendEmptyMessageDelayed(1, 1000L);
                    break;
                }
            }
        }
    };

    public ConfChatBuddyListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public ConfChatBuddyListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ConfChatBuddyListView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mWebinarChatBuddyAdapter = new WebinarChatBuddyAdapter(this.getContext());
        this.setAdapter((ListAdapter)this.mWebinarChatBuddyAdapter);
        this.loadAllItems();
        this.mHandler.sendEmptyMessageDelayed(1, 1000L);
    }

    protected void onDetachedFromWindow() {
        this.mHandler.removeMessages(1);
        super.onDetachedFromWindow();
    }

    public void onUserAdded(String jid) {
        this.needRefresh = true;
    }

    public void onUserRemoved(String jid) {
        this.needRefresh = true;
    }

    public void onChattedAttendeeUpdated(long nodeId) {
        this.needRefresh = true;
    }

    public boolean onUserEvent(int eventType, long userId, int flag) {
        this.needRefresh = true;
        return true;
    }

    public void onAttendeeStatusChange() {
        this.needRefresh = true;
    }

    public void onHostOrCoHostChanged() {
        this.needRefresh = true;
    }

    public void onUserGuestStatusChanged() {
        this.needRefresh = true;
    }

    public void loadAllItems() {
        List<ZoomQABuddy> attendees;
        ZoomChatInWebinar webinarChat;
        ConfChatAttendeeItem item;
        ConfMgr confMgr = ConfMgr.getInstance();
        CmmConfContext confContext = confMgr.getConfContext();
        if (confContext == null) {
            return;
        }
        CmmConfStatus cmmConfStatus = confMgr.getConfStatusObj();
        if (cmmConfStatus == null) {
            return;
        }
        this.mWebinarChatBuddyAdapter.clearAll();
        boolean isWebinar = confContext.isWebinar();
        boolean isAttendee = false;
        int priviledge = confMgr.getConfStatusObj().getAttendeeChatPriviledge();
        if (isWebinar) {
            ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
            isAttendee = qacomponent == null || qacomponent.isWebinarAttendee();
        } else {
            CmmUser myself = ConfMgr.getInstance().getMyself();
            if (myself != null) {
                isAttendee = !myself.isHost() && !myself.isCoHost();
            }
        }
        ArrayList<ConfChatAttendeeItem> temp = new ArrayList<ConfChatAttendeeItem>();
        if (priviledge == 3) {
            ConfChatAttendeeItem item2;
            if (!isAttendee) {
                item2 = new ConfChatAttendeeItem(this.getContext().getString(R.string.zm_webinar_txt_everyone), null, 0L, -1);
                this.mWebinarChatBuddyAdapter.addWebinarAttendeeItem(item2);
            }
            if (confContext.isPrivateChatOFF()) {
                this.mWebinarChatBuddyAdapter.notifyDataSetChanged();
                return;
            }
            CmmUserList userList = confMgr.getUserList();
            if (userList == null) {
                return;
            }
            ZoomQAComponent qaComponent = confMgr.getQAComponent();
            if (qaComponent == null) {
                return;
            }
            int count = userList.getUserCount();
            for (int i = 0; i < count; ++i) {
                CmmUser user = userList.getUserAt(i);
                if (user == null) continue;
                long nodeId = user.getNodeId();
                if (isAttendee && !user.isHost() && !user.isCoHost() || user.isMMRUser() || cmmConfStatus.isMyself(nodeId) || user.isH323User() || user.isPureCallInUser() || user.inSilentMode() || user.isViewOnlyUserCanTalk()) continue;
                item2 = new ConfChatAttendeeItem(user.getScreenName(), qaComponent.getUserJIDByNodeID(nodeId), nodeId, -1);
                temp.add(item2);
            }
            if (temp.size() != 0) {
                for (ConfChatAttendeeItem i : temp) {
                    this.mWebinarChatBuddyAdapter.addWebinarAttendeeItem(i);
                }
            }
            this.mWebinarChatBuddyAdapter.notifyDataSetChanged();
            return;
        }
        if (priviledge == 2) {
            item = new ConfChatAttendeeItem(this.getContext().getString(R.string.zm_webinar_txt_all_panelists), null, 1L, -1);
            this.mWebinarChatBuddyAdapter.addWebinarAttendeeItem(item);
            if (!isAttendee) {
                item = new ConfChatAttendeeItem(this.getContext().getString(R.string.zm_mi_panelists_and_attendees_11380), null, 0L, -1);
                this.mWebinarChatBuddyAdapter.addWebinarAttendeeItem(item);
            }
        } else if (isWebinar) {
            item = new ConfChatAttendeeItem(this.getContext().getString(R.string.zm_webinar_txt_all_panelists), null, 1L, -1);
            this.mWebinarChatBuddyAdapter.addWebinarAttendeeItem(item);
            item = new ConfChatAttendeeItem(this.getContext().getString(R.string.zm_mi_panelists_and_attendees_11380), null, 0L, -1);
            this.mWebinarChatBuddyAdapter.addWebinarAttendeeItem(item);
        } else {
            item = new ConfChatAttendeeItem(this.getContext().getString(R.string.zm_webinar_txt_everyone), null, 0L, -1);
            this.mWebinarChatBuddyAdapter.addWebinarAttendeeItem(item);
        }
        if (confContext.isPrivateChatOFF()) {
            this.mWebinarChatBuddyAdapter.notifyDataSetChanged();
            return;
        }
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null || qacomponent.isWebinarAttendee()) {
            return;
        }
        CmmUserList userList = confMgr.getUserList();
        if (userList == null) {
            return;
        }
        CmmConfStatus confStatus = confMgr.getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        ZoomQAComponent qaComponent = confMgr.getQAComponent();
        if (qaComponent == null) {
            return;
        }
        int count = userList.getUserCount();
        for (int i = 0; i < count; ++i) {
            CmmUser user = userList.getUserAt(i);
            if (user == null) continue;
            long nodeId = user.getNodeId();
            if (user.isMMRUser() || confStatus.isMyself(nodeId) || user.isH323User() || user.isPureCallInUser() || user.inSilentMode() || user.isViewOnlyUserCanTalk()) continue;
            item = new ConfChatAttendeeItem(user.getScreenName(), qaComponent.getUserJIDByNodeID(nodeId), nodeId, -1);
            temp.add(item);
        }
        if (temp.size() != 0) {
            if (isWebinar) {
                item = new ConfChatAttendeeItem(this.getContext().getString(R.string.zm_webinar_txt_lable_panelists), null, -1L, -1);
                this.mWebinarChatBuddyAdapter.addWebinarAttendeeItem(item);
            }
            for (ConfChatAttendeeItem i : temp) {
                this.mWebinarChatBuddyAdapter.addWebinarAttendeeItem(i);
            }
        }
        if ((webinarChat = confMgr.getChatInWebinar()) == null) {
            this.mWebinarChatBuddyAdapter.notifyDataSetChanged();
            return;
        }
        if ((isAttendee && priviledge == 1 || !isAttendee) && (attendees = webinarChat.getChattedAttendees()) != null) {
            if (attendees.size() > 0) {
                item = new ConfChatAttendeeItem(this.getContext().getString(R.string.zm_webinar_txt_lable_attendees), null, -1L, -1);
                this.mWebinarChatBuddyAdapter.addWebinarAttendeeItem(item);
            }
            for (ZoomQABuddy attendee : attendees) {
                item = new ConfChatAttendeeItem(attendee);
                this.mWebinarChatBuddyAdapter.addWebinarAttendeeItem(item);
            }
        }
        this.mWebinarChatBuddyAdapter.notifyDataSetChanged();
    }

    static class WebinarChatBuddyAdapter
    extends BaseAdapter {
        private List<ConfChatAttendeeItem> mitems = new ArrayList<ConfChatAttendeeItem>();
        private Context mContext;

        WebinarChatBuddyAdapter(Context context) {
            this.mContext = context;
        }

        public void clearAll() {
            this.mitems.clear();
        }

        public int getCount() {
            return this.mitems.size();
        }

        public void addWebinarAttendeeItem(ConfChatAttendeeItem item) {
            if (item == null) {
                return;
            }
            this.mitems.add(item);
        }

        public Object getItem(int position) {
            return this.mitems.get(position);
        }

        public int getViewTypeCount() {
            return 2;
        }

        private View newGroupHeaderView(int position, String item, View convertView, ViewGroup parent) {
            View view = null;
            if (convertView != null && "us.zoom.androidlib.widget.QuickSearchListView.header".equals(convertView.getTag())) {
                view = convertView;
            } else {
                LayoutInflater factory = LayoutInflater.from((Context)this.mContext);
                view = factory.inflate(R.layout.zm_quick_search_list_items_header, parent, false);
                view.setTag((Object)"us.zoom.androidlib.widget.QuickSearchListView.header");
            }
            TextView txtHeader = (TextView)view.findViewById(R.id.txtHeader);
            if (txtHeader != null) {
                txtHeader.setText((CharSequence)item);
            }
            return view;
        }

        private View bindView(int position, ConfChatAttendeeItem item, View convertView, ViewGroup parent) {
            if (convertView == null || !"webinarattendees".equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_qa_webinar_attendee_item, null);
                convertView.setTag((Object)"webinarattendees");
            }
            View view = null;
            if ("webinarattendees".equals(convertView.getTag())) {
                view = convertView;
            } else {
                LayoutInflater factory = LayoutInflater.from((Context)this.mContext);
                view = factory.inflate(R.layout.zm_quick_search_list_items_header, parent, false);
                view.setTag((Object)"webinarattendees");
            }
            TextView txtName = (TextView)convertView.findViewById(R.id.txtName);
            TextView txtRole = (TextView)convertView.findViewById(R.id.txtRole);
            ImageView imgRaiseHand = (ImageView)convertView.findViewById(R.id.imgRaiseHand);
            txtName.setText((CharSequence)item.name);
            imgRaiseHand.setVisibility(8);
            convertView.setBackgroundResource(R.color.zm_transparent);
            if (item.nodeID != 0L && item.nodeID != 1L) {
                ConfMgr confMgr = ConfMgr.getInstance();
                CmmUser user = confMgr.getUserById(item.nodeID);
                if (user == null) {
                    ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(item.nodeID);
                    if (buddy != null && ConfLocalHelper.isGuest(buddy) && !ConfLocalHelper.isGuestForMyself()) {
                        convertView.setBackgroundResource(R.drawable.zm_list_selector_guest);
                    }
                    return convertView;
                }
                txtRole.setVisibility(0);
                if (ConfLocalHelper.isGuest(user) && !ConfLocalHelper.isGuestForMyself()) {
                    convertView.setBackgroundResource(R.drawable.zm_list_selector_guest);
                }
                if (ConfUI.getInstance().isDisplayAsHost(item.nodeID)) {
                    txtRole.setText((CharSequence)this.mContext.getResources().getString(R.string.zm_lbl_role_host));
                } else if (ConfUI.getInstance().isDisplayAsCohost(item.nodeID)) {
                    txtRole.setText((CharSequence)this.mContext.getResources().getString(R.string.zm_lbl_role_cohost));
                } else {
                    txtRole.setVisibility(8);
                }
            } else {
                txtRole.setVisibility(8);
            }
            return convertView;
        }

        public int getItemViewType(int position) {
            ConfChatAttendeeItem item = (ConfChatAttendeeItem)this.getItem(position);
            return item != null && item.nodeID != -1L ? 0 : 1;
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ConfChatAttendeeItem item = (ConfChatAttendeeItem)this.getItem(position);
            if (this.getItemViewType(position) == 1) {
                return this.newGroupHeaderView(position, item == null ? "" : item.name, convertView, parent);
            }
            return this.bindView(position, item, convertView, parent);
        }
    }
}

