/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmAttentionTrackMgr;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.ZMConfUtil;
import com.zipow.videobox.view.BaseAttendeeItem;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class ConfChatAttendeeItem
extends BaseAttendeeItem {
    private static final long serialVersionUID = 1L;
    public static final int BUDDY_YTPE_LABEL = -1;
    public static final int BUDDY_YTPE_EVERYONE = 0;
    public static final int BUDDY_YTPE_PANELIST = 1;
    public String name;
    public String jid;
    public String email;
    public long nodeID;
    public int role;
    public boolean isShowGuest;
    public boolean isAttentionMode = false;
    private String sortKey;

    public ConfChatAttendeeItem(String name, String Jid, long nodeId, int Role) {
        this.set(name, Jid, null, nodeId, Role, false);
    }

    public ConfChatAttendeeItem(ZoomQABuddy buddy, String sortKey) {
        if (buddy != null) {
            this.name = buddy.getName();
            this.jid = buddy.getJID();
            this.email = buddy.getEmail();
            this.nodeID = buddy.getNodeID();
            this.role = buddy.getRole();
            this.isShowGuest = ConfLocalHelper.isGuest(buddy) && !ConfLocalHelper.isGuestForMyself();
            this.isAttentionMode = buddy.isInAttentionMode();
            this.isSupportTempTalk = buddy.isAttendeeSupportTemporarilyFeature();
            this.sortKey = sortKey;
            if (this.isSupportTempTalk) {
                this.isAllowTalked = buddy.isAttendeeCanTalk();
                this.updateAudio(this.nodeID);
            }
        }
    }

    public ConfChatAttendeeItem(ZoomQABuddy buddy) {
        if (buddy != null) {
            this.isShowGuest = ConfLocalHelper.isGuest(buddy) && !ConfLocalHelper.isGuestForMyself();
            this.set(buddy.getName(), buddy.getJID(), buddy.getEmail(), buddy.getNodeID(), buddy.getRole(), buddy.isInAttentionMode());
            this.isSupportTempTalk = buddy.isAttendeeSupportTemporarilyFeature();
            if (this.isSupportTempTalk) {
                this.isAllowTalked = buddy.isAttendeeCanTalk();
                this.updateAudio(this.nodeID);
            }
        }
    }

    public ConfChatAttendeeItem(CmmUser user) {
        if (user != null) {
            this.isShowGuest = ConfLocalHelper.isGuest(user) && !ConfLocalHelper.isGuestForMyself();
            this.set(user.getScreenName(), null, user.getEmail(), user.getNodeId(), -1, user.isInAttentionMode());
        }
    }

    private void set(String name, String Jid, String email, long nodeId, int Role, boolean isAttentionMode) {
        this.name = name;
        this.jid = Jid;
        this.email = email;
        this.nodeID = nodeId;
        this.role = Role;
        this.isAttentionMode = isAttentionMode;
        this.sortKey = SortUtil.getSortKey((String)name, (Locale)CompatUtils.getLocalDefault());
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String key) {
        this.sortKey = key;
    }

    public static ConfChatAttendeeItem getWebinarAttendeeItemByNodeId(long nodeId) {
        ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(nodeId);
        if (buddy == null) {
            return null;
        }
        if (buddy.getRole() != 0) {
            return null;
        }
        return new ConfChatAttendeeItem(buddy);
    }

    public View getView(Context context, View convertView) {
        if (convertView == null || !"webinar".equals(convertView.getTag())) {
            convertView = View.inflate((Context)context, (int)R.layout.zm_qa_webinar_attendee_email_item, null);
            convertView.setTag((Object)"webinar");
        }
        this.bindView(context, convertView);
        return convertView;
    }

    public String getSendContentDescription(Context context) {
        if (this.nodeID == 0L) {
            return context.getString(R.string.zm_lbl_content_send_to, new Object[]{context.getString(R.string.zm_webinar_txt_everyone)});
        }
        if (this.nodeID == 1L) {
            return context.getString(R.string.zm_lbl_content_send_to, new Object[]{context.getString(R.string.zm_webinar_txt_all_panelists)});
        }
        if (!StringUtil.isEmptyOrNull((String)this.name)) {
            return context.getString(R.string.zm_lbl_content_send_to, new Object[]{this.name});
        }
        return context.getString(R.string.zm_btn_send);
    }

    private void bindView(Context context, View convertView) {
        boolean isShare;
        ZoomQABuddy buddy;
        if (convertView == null) {
            return;
        }
        TextView txtName = (TextView)convertView.findViewById(R.id.txtName);
        TextView txtRole = (TextView)convertView.findViewById(R.id.txtRole);
        TextView txtEmail = (TextView)convertView.findViewById(R.id.txtEmail);
        ImageView imgAudio = (ImageView)convertView.findViewById(R.id.imgAudio);
        ImageView imgRaiseHand = (ImageView)convertView.findViewById(R.id.imgRaiseHand);
        ImageView imgAttention = (ImageView)convertView.findViewById(R.id.imgAttention);
        txtName.setText((CharSequence)this.name);
        if (StringUtil.isEmptyOrNull((String)this.email) && (buddy = ZMConfUtil.getZoomQABuddyByNodeId(this.nodeID)) != null) {
            this.email = buddy.getEmail();
        }
        txtEmail.setText((CharSequence)this.email);
        txtEmail.setVisibility(StringUtil.isEmptyOrNull((String)this.email) ? 8 : 0);
        convertView.setBackgroundResource(this.isShowGuest ? R.drawable.zm_list_selector_guest : R.color.zm_transparent);
        txtRole.setVisibility(8);
        imgRaiseHand.setVisibility(ConfLocalHelper.isHaisedHand(this.jid) ? 0 : 8);
        CmmAttentionTrackMgr mgr = ConfMgr.getInstance().getAttentionTrackAPI();
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        boolean bl = isShare = shareMgr != null && (shareMgr.getShareStatus() == 3 || shareMgr.getShareStatus() == 2);
        if (isShare && mgr != null && mgr.isConfAttentionTrackEnabled()) {
            imgAttention.setVisibility(this.isAttentionMode ? 4 : 0);
        } else {
            imgAttention.setVisibility(8);
        }
        if (this.isSupportTempTalk && this.audioType != 2L) {
            imgAudio.setVisibility(0);
            imgAudio.setContentDescription((CharSequence)context.getString(this.audioOn ? R.string.zm_description_plist_status_audio_on : R.string.zm_description_plist_status_audio_off));
            imgAudio.setImageResource(ZMConfUtil.getAudioImageResId(convertView.isInEditMode(), this.audioOn, this.audioType, this.nodeID));
            Drawable drawable2 = imgAudio.getDrawable();
            if (drawable2 instanceof AnimationDrawable) {
                ((AnimationDrawable)drawable2).start();
            }
        } else {
            imgAudio.setVisibility(8);
        }
    }

    public static class WebinarAttendeeItemComparator
    implements Comparator<ConfChatAttendeeItem> {
        private Collator mCollator;

        public WebinarAttendeeItemComparator(Locale locale) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        @Override
        public int compare(ConfChatAttendeeItem lhs, ConfChatAttendeeItem rhs) {
            if (lhs == rhs) {
                return 0;
            }
            int res = this.mCollator.compare(lhs.getSortKey(), rhs.getSortKey());
            return res;
        }
    }
}

