/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.util.ZmPtUtils;
import com.zipow.videobox.view.BaseMeetingToolbar;
import com.zipow.videobox.view.ScheduledMeetingItem;
import com.zipow.videobox.view.ToolbarButton;
import com.zipow.videobox.view.adapter.ZMLatestMeetingAdapter;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMChildListView;
import us.zoom.androidlib.widget.ZMUpArrowView;
import us.zoom.videomeetings.R;

public class ChatMeetToolbar
extends BaseMeetingToolbar {
    private int mIconSize;
    private ZMChildListView mZMChildListView;
    private ZMLatestMeetingAdapter mZmLatestMeetingAdapter;
    private ZMUpArrowView mViewDivider;
    private IUpComingMeetingCallback mIUpComingMeetingCallback;

    public ChatMeetToolbar(Context context) {
        this(context, null);
    }

    public ChatMeetToolbar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void initView(Context context) {
        View.inflate((Context)context, (int)R.layout.zm_chat_meet_toolbar, (ViewGroup)this);
        this.mIconSize = this.getResources().getDimensionPixelSize(R.dimen.zm_toolbar_size);
        this.mViewDivider = (ZMUpArrowView)this.findViewById(R.id.viewDivider);
        this.mZMChildListView = (ZMChildListView)this.findViewById(R.id.upComingListView);
        this.mBtnJoin = (ToolbarButton)this.findViewById(R.id.btnJoin);
        this.setToolbar(this.mBtnJoin, this.mIconSize, R.drawable.zm_btn_toolbar_blue);
        this.mBtnStart = (ToolbarButton)this.findViewById(R.id.btnStart);
        this.setToolbar(this.mBtnStart, this.mIconSize, R.drawable.zm_btn_toolbar_orange);
        this.mBtnUpcoming = (ToolbarButton)this.findViewById(R.id.btnUpcoming);
        this.setToolbar(this.mBtnUpcoming, this.mIconSize, R.drawable.zm_btn_toolbar_blue);
        ToolbarButton btnSchedule = (ToolbarButton)this.findViewById(R.id.btnSchedule);
        this.setToolbar(btnSchedule, this.mIconSize, R.drawable.zm_btn_toolbar_blue);
        this.mBtnJoin.setOnClickListener(this);
        this.mBtnStart.setOnClickListener(this);
        btnSchedule.setOnClickListener(this);
        this.mBtnUpcoming.setOnClickListener(this);
        this.mZmLatestMeetingAdapter = new ZMLatestMeetingAdapter(this.getContext(), new ZMLatestMeetingAdapter.InnerItemOnclickListener(){

            @Override
            public void itemClick(View v) {
                ScheduledMeetingItem scheduledMeetingItem = (ScheduledMeetingItem)v.getTag();
                if (scheduledMeetingItem != null) {
                    ZMActivity activity = (ZMActivity)ChatMeetToolbar.this.getContext();
                    if (activity == null) {
                        return;
                    }
                    if (scheduledMeetingItem.ismIsCanStartMeetingForMySelf()) {
                        ConfActivity.startMeeting(activity, scheduledMeetingItem.getMeetingNo(), scheduledMeetingItem.getId());
                    } else {
                        ConfActivity.joinByUrl(ChatMeetToolbar.this.getContext(), scheduledMeetingItem.getJoinMeetingUrl());
                    }
                }
            }
        });
        this.mZMChildListView.setAdapter((ListAdapter)this.mZmLatestMeetingAdapter);
        this.refresh();
    }

    @Override
    public void refresh() {
        int buttonsCount = 4;
        if (PTApp.getInstance().hasActiveCall() && VideoBoxApplication.getInstance().isConfProcessRunning()) {
            buttonsCount = 3;
            this.mBtnStart.setVisibility(8);
            this.mBtnJoin.setImageResource(R.drawable.zm_ic_back_meeting);
            this.setToolbar(this.mBtnJoin, this.mIconSize, R.drawable.zm_btn_toolbar_orange);
            this.mBtnJoin.setText(R.string.zm_btn_mm_return_to_conf_21854);
        } else {
            this.mBtnStart.setVisibility(0);
            this.mBtnJoin.setImageResource(R.drawable.zm_ic_join_meeting);
            this.setToolbar(this.mBtnJoin, this.mIconSize, R.drawable.zm_btn_toolbar_blue);
            this.mBtnJoin.setText(R.string.zm_bo_btn_join_bo);
        }
        List<ScheduledMeetingItem> scheduledMeetingItems = ZmPtUtils.getLatestUpcomingMeetingItems();
        boolean isEmptyData = CollectionsUtil.isCollectionEmpty(scheduledMeetingItems);
        this.mViewDivider.setVisibility(isEmptyData ? 8 : 0);
        int width = UIUtil.getDisplayWidth((Context)this.getContext());
        this.mViewDivider.setmLeftDelta(width * (buttonsCount * 2 - 1) / (buttonsCount * 2) - UIUtil.dip2px((Context)this.getContext(), (float)12.0f));
        this.mZMChildListView.setVisibility(isEmptyData ? 8 : 0);
        this.mZmLatestMeetingAdapter.refresh(scheduledMeetingItems);
        if (this.mIUpComingMeetingCallback != null) {
            this.mIUpComingMeetingCallback.onRefresh(this.getRefreshIntervals(scheduledMeetingItems));
        }
    }

    public void setmIUpComingMeetingCallback(IUpComingMeetingCallback mIUpComingMeetingCallback) {
        this.mIUpComingMeetingCallback = mIUpComingMeetingCallback;
    }

    private List<Long> getRefreshIntervals(List<ScheduledMeetingItem> scheduledMeetingItems) {
        ArrayList<Long> intervals = new ArrayList<Long>();
        if (this.mZmLatestMeetingAdapter != null && this.mZmLatestMeetingAdapter.getCount() > 0) {
            long currentTime = System.currentTimeMillis();
            for (ScheduledMeetingItem scheduledMeetingItem : scheduledMeetingItems) {
                long interval = scheduledMeetingItem.getStartTime() - currentTime;
                if (interval < 0L) {
                    if ((interval += 600000L) < 0L || intervals.contains(interval)) continue;
                    intervals.add(interval);
                    continue;
                }
                if (intervals.contains(interval)) continue;
                intervals.add(interval);
                intervals.add(interval += 600000L);
            }
        }
        return intervals;
    }

    public static interface IUpComingMeetingCallback {
        public void onRefresh(List<Long> var1);
    }
}

