/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.ContactsAvatarCache;
import com.zipow.videobox.view.AvatarView;
import java.io.File;
import org.webrtc.voiceengine.VoiceEngineCompat;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class CallConnectingView
extends LinearLayout
implements View.OnClickListener,
ABContactsCache.IABContactsCacheListener {
    private static final String TAG = CallConnectingView.class.getSimpleName();
    private View mViewFrame;
    private Button mBtnEndCall;
    private TextView mTxtScreenName;
    private TextView mTxtMsgCalling;
    private AvatarView mAvatarView;
    private Button mBtnSpeaker;
    private View mSpeakerDivider;
    private boolean mIsRegisterABContactsCacheListener = false;

    public CallConnectingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public CallConnectingView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mBtnEndCall.setOnClickListener((View.OnClickListener)this);
        this.mBtnSpeaker.setOnClickListener((View.OnClickListener)this);
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_call_connecting, (ViewGroup)this);
        this.mViewFrame = this.findViewById(R.id.viewFrame);
        this.mBtnEndCall = (Button)this.findViewById(R.id.btnEndCall);
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mTxtMsgCalling = (TextView)this.findViewById(R.id.txtMsgCalling);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mBtnSpeaker = (Button)this.findViewById(R.id.btnSpeaker);
        this.mSpeakerDivider = this.findViewById(R.id.speakerDivider);
    }

    public void updateUIForCallType(int callType) {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        CmmConfContext confContext = confMgr.getConfContext();
        if (confContext == null) {
            return;
        }
        switch (callType) {
            case 0: {
                boolean headsetOn;
                this.setVisibility(0);
                this.mViewFrame.setBackgroundResource(R.drawable.zm_audiocall_bg);
                this.setScreenName(confContext);
                this.setAvatar(confContext);
                this.setCallingMessage(confContext, callType);
                this.mAvatarView.setVisibility(0);
                boolean supportTelephony = VoiceEngineCompat.isFeatureTelephonySupported(this.getContext());
                boolean bl = headsetOn = HeadsetUtil.getInstance().isBluetoothHeadsetOn() || HeadsetUtil.getInstance().isWiredHeadsetOn();
                if (!VoiceEngineCompat.isPlayerCommunicationModeAvailable() || !supportTelephony && !headsetOn) {
                    this.mBtnSpeaker.setVisibility(8);
                    this.mSpeakerDivider.setVisibility(8);
                    break;
                }
                this.mBtnSpeaker.setVisibility(0);
                this.mSpeakerDivider.setVisibility(0);
                break;
            }
            case 2: {
                this.setVisibility(0);
                this.mViewFrame.setBackgroundResource(R.drawable.zm_audiocall_bg);
                this.setScreenName(confContext);
                this.setAvatar(confContext);
                this.setCallingMessage(confContext, callType);
                this.mAvatarView.setVisibility(0);
                this.mBtnSpeaker.setVisibility(8);
                this.mSpeakerDivider.setVisibility(8);
                break;
            }
            case 1: {
                this.setVisibility(0);
                this.mViewFrame.setBackgroundResource(0);
                this.setScreenName(confContext);
                this.setAvatar(confContext);
                this.setCallingMessage(confContext, callType);
                this.mAvatarView.setVisibility(8);
                this.mBtnSpeaker.setVisibility(8);
                this.mSpeakerDivider.setVisibility(8);
                break;
            }
            case 3: 
            case 4: {
                this.setVisibility(8);
                this.mBtnSpeaker.setVisibility(8);
                this.mSpeakerDivider.setVisibility(8);
            }
        }
        this.mBtnSpeaker.setVisibility(8);
        this.mSpeakerDivider.setVisibility(8);
        this.initBtnSpeakerStatus(callType);
    }

    private void setCallingMessage(CmmConfContext confContext, int callType) {
        if (confContext.getLaunchReason() == 1) {
            switch (callType) {
                case 0: 
                case 2: {
                    this.mTxtMsgCalling.setText(R.string.zm_msg_audio_calling);
                    break;
                }
                case 1: {
                    this.mTxtMsgCalling.setText(R.string.zm_msg_video_calling);
                }
            }
        } else {
            this.mTxtMsgCalling.setText(R.string.zm_msg_connecting);
        }
    }

    private void setAvatar(CmmConfContext confContext) {
        String avatar = confContext.get1On1BuddyLocalPic();
        if (!StringUtil.isEmptyOrNull((String)avatar) && new File(avatar).exists()) {
            this.mAvatarView.setAvatar(avatar);
        } else {
            String phoneNumber = confContext.get1On1BuddyPhoneNumber();
            boolean isAbCall = confContext.isPhoneCall();
            if (!StringUtil.isEmptyOrNull((String)phoneNumber) && isAbCall) {
                Bitmap bitmap = this.getContactsAvatarFromPhoneNumber(phoneNumber);
                this.mAvatarView.setAvatar(bitmap);
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mIsRegisterABContactsCacheListener) {
            ABContactsCache.getInstance().removeListener(this);
            this.mIsRegisterABContactsCacheListener = false;
        }
    }

    @Override
    public void onContactsCacheUpdated() {
        ABContactsCache.getInstance().removeListener(this);
        this.mIsRegisterABContactsCacheListener = false;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        String phoneNumber = confContext.get1On1BuddyPhoneNumber();
        boolean isAbCall = confContext.isPhoneCall();
        if (!StringUtil.isEmptyOrNull((String)phoneNumber) && isAbCall) {
            Bitmap bitmap = this.getContactsAvatarFromPhoneNumber(phoneNumber);
            this.mAvatarView.setAvatar(bitmap);
        }
    }

    private Bitmap getContactsAvatarFromPhoneNumber(String callerPhoneNumber) {
        Context context = this.getContext();
        if (context == null) {
            return null;
        }
        ABContactsCache cache = ABContactsCache.getInstance();
        cache.addListener(this);
        this.mIsRegisterABContactsCacheListener = true;
        if (!cache.isCached() && !cache.reloadAllContacts()) {
            return null;
        }
        ABContactsCache.Contact contact = cache.getFirstContactByPhoneNumber(callerPhoneNumber);
        if (contact != null) {
            cache.removeListener(this);
            this.mIsRegisterABContactsCacheListener = false;
            int contactId = contact.contactId;
            Bitmap bitmap = ContactsAvatarCache.getInstance().getContactAvatar(context, contactId);
            return bitmap;
        }
        return null;
    }

    private void setScreenName(CmmConfContext confContext) {
        String name = confContext.get1On1BuddyScreeName();
        this.mTxtScreenName.setText((CharSequence)name);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.btnEndCall) {
            this.onClickButtonEndCall();
        } else if (id2 == R.id.btnSpeaker) {
            this.onClickBtnSpeaker();
        }
    }

    private void onClickButtonEndCall() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        CmmConfContext confContext = confMgr.getConfContext();
        if (confContext == null) {
            return;
        }
        ConfActivity confActivity = (ConfActivity)this.getContext();
        if (confActivity == null) {
            return;
        }
        if (confContext.getOrginalHost()) {
            ConfLocalHelper.endCall(confActivity);
        } else {
            ConfLocalHelper.leaveCall(confActivity);
        }
    }

    private void onClickBtnSpeaker() {
        ConfActivity confActivity = (ConfActivity)this.getContext();
        if (confActivity == null) {
            return;
        }
        ConfLocalHelper.switchAudioSource((Context)confActivity, confActivity.getMyAudioType());
    }

    private void initBtnSpeakerStatus(int callType) {
        boolean loudSpeakerOn = ConfUI.getInstance().getCurrentAudioSourceType() == 0;
        this.mBtnSpeaker.setSelected(loudSpeakerOn);
    }
}

