/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.media.AudioTrack;
import com.zipow.videobox.VideoBoxApplication;
import java.io.IOException;
import java.io.InputStream;

public class AudioClip {
    private static final String TAG = AudioClip.class.getSimpleName();
    private int mRawDataResId = 0;
    private int mStreamType = 0;
    private PlayThread mPlayThread;

    public AudioClip(int rawDataResId, int streamType) {
        this.mRawDataResId = rawDataResId;
        this.mStreamType = streamType;
        if (this.mStreamType < 0) {
            this.mStreamType = 0;
        }
    }

    public void startPlay() {
        this.startPlay(-1);
    }

    public void startPlay(int loopCount) {
        if (this.mPlayThread == null || !this.mPlayThread.isAlive()) {
            this.mPlayThread = new PlayThread(this, loopCount);
            this.mPlayThread.start();
        }
    }

    public boolean isPlaying() {
        return this.mPlayThread != null && this.mPlayThread.isAlive();
    }

    public void stopPlay() {
        if (this.mPlayThread != null && this.mPlayThread.isAlive()) {
            this.mPlayThread.stopPlay();
        }
        this.mPlayThread = null;
    }

    public int getRawDataResId() {
        return this.mRawDataResId;
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    static class PlayThread
    extends Thread {
        AudioClip mAudioClip;
        AudioTrack mAudioTrack;
        boolean mStopPlay = false;
        int mLoopCount = -1;

        PlayThread(AudioClip clip, int loopCount) {
            super("PlayThread");
            this.mAudioClip = clip;
            this.mLoopCount = loopCount;
        }

        void stopPlay() {
            this.mStopPlay = true;
        }

        @Override
        public void run() {
            InputStream is = VideoBoxApplication.getInstance().getResources().openRawResource(this.mAudioClip.getRawDataResId());
            if (is == null) {
                this.mStopPlay = true;
                return;
            }
            int bufferSize = AudioTrack.getMinBufferSize((int)8000, (int)4, (int)2);
            if (bufferSize <= 0) {
                this.mStopPlay = true;
                return;
            }
            try {
                this.mAudioTrack = new AudioTrack(this.mAudioClip.getStreamType(), 8000, 4, 2, bufferSize, 1);
                this.mAudioTrack.play();
            }
            catch (Exception e) {
                this.mStopPlay = true;
                return;
            }
            byte[] buff = null;
            int len = 0;
            try {
                buff = new byte[is.available()];
                len = is.read(buff);
            }
            catch (Exception e) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mAudioTrack.stop();
                this.mAudioTrack.release();
                return;
            }
            if (len > 0) {
                int offset = 0;
                int lenToWrite = 0;
                int loopIdx = 0;
                do {
                    if (len - offset < (lenToWrite = 1600)) {
                        lenToWrite = len - offset;
                    }
                    if (lenToWrite > 0) {
                        if (this.mAudioTrack.getState() == 1 && this.mAudioTrack.getPlayState() == 3) {
                            this.mAudioTrack.write(buff, offset, lenToWrite);
                        } else {
                            try {
                                Thread.sleep(lenToWrite * 100 / 1600);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if ((offset += lenToWrite) < len) continue;
                    offset = 0;
                    if (this.mLoopCount <= 0 || this.mLoopCount > ++loopIdx) continue;
                    this.mStopPlay = true;
                } while (!this.mStopPlay);
                try {
                    this.mAudioTrack.pause();
                    this.mAudioTrack.flush();
                    this.mAudioTrack.stop();
                }
                catch (IllegalStateException e) {
                    return;
                }
                this.mAudioTrack.release();
            }
        }
    }
}

