/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.ptapp.FavoriteMgr;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomContact;
import com.zipow.videobox.util.FavoriteItemComparator;
import com.zipow.videobox.view.AddFavoriteItem;
import com.zipow.videobox.view.AddFavoriteListAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.CompatUtils;

public class AddFavoriteListView
extends ListView
implements AdapterView.OnItemClickListener {
    private static final String TAG = AddFavoriteListView.class.getSimpleName();
    private AddFavoriteListAdapter mAdapter;
    private Listener mListener;
    private String mFilter;
    private List<AddFavoriteItem> mSelectedItems = new ArrayList<AddFavoriteItem>();
    private RetainedFragment mRetainedFragment;
    private int mLastTopPosition = 0;

    public AddFavoriteListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public AddFavoriteListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public AddFavoriteListView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.mAdapter = new AddFavoriteListAdapter(this.getContext());
        this.setOnItemClickListener(this);
        if (!this.isInEditMode()) {
            this.initRetainedFragment();
        }
    }

    private void _editmode_loadAllBuddyItems(AddFavoriteListAdapter adapter) {
        for (int i = 0; i < 20; ++i) {
            ZoomContact contact = new ZoomContact();
            contact.setFirstName("Buddy");
            contact.setLastName(String.valueOf(i));
            contact.setUserID(String.valueOf(i));
            AddFavoriteItem item = new AddFavoriteItem(contact);
            item.setChecked(i % 2 == 0);
            adapter.addItem(item);
        }
    }

    private void loadAllBuddyItems(AddFavoriteListAdapter adapter) {
        long timeStart = System.currentTimeMillis();
        FavoriteMgr favMgr = PTApp.getInstance().getFavoriteMgr();
        if (favMgr == null) {
            return;
        }
        ArrayList<ZoomContact> contacts = new ArrayList<ZoomContact>();
        if (favMgr.getDomainUsersWithFilter("", contacts)) {
            String lowerFilter = "";
            if (this.mFilter != null && this.mFilter.length() > 0) {
                lowerFilter = this.mFilter.toLowerCase();
            }
            for (ZoomContact contact : contacts) {
                AddFavoriteItem item = new AddFavoriteItem(contact);
                if (lowerFilter.length() > 0 && item.getScreenName().toLowerCase().indexOf(lowerFilter) < 0 && item.getEmail().toLowerCase().indexOf(lowerFilter) < 0) continue;
                item.setChecked(this.isItemSelected(item.getUserID()));
                adapter.addItem(item);
            }
        }
        adapter.sort();
    }

    public void loadZoomContactsFromList(List<ZoomContact> contacts) {
        this.mAdapter.clear();
        for (ZoomContact contact : contacts) {
            AddFavoriteItem item = new AddFavoriteItem(contact);
            item.setChecked(this.isItemSelected(item.getUserID()));
            this.mAdapter.addItem(item);
        }
        this.mAdapter.sort();
        this.mAdapter.notifyDataSetChanged();
    }

    public void updateZoomContact(ZoomContact contact) {
        this.mAdapter.notifyDataSetChanged();
    }

    public void updateZoomContact(String userId) {
        this.mAdapter.notifyDataSetChanged();
    }

    private boolean isItemSelected(String userID) {
        if (userID == null) {
            return false;
        }
        for (AddFavoriteItem item : this.mSelectedItems) {
            if (!userID.equals(item.getUserID())) continue;
            return true;
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            this._editmode_loadAllBuddyItems(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
        if (this.mLastTopPosition >= 0) {
            this.setSelectionFromTop(this.mLastTopPosition, 0);
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        Parcelable superState = null;
        if (state instanceof Bundle) {
            Bundle allState = (Bundle)state;
            superState = allState.getParcelable("AddFavoriteListView.superState");
            this.mFilter = allState.getString("AddFavoriteListView.mFilter");
            this.mLastTopPosition = allState.getInt("AddFavoriteListView.topPosition", -1);
        } else {
            superState = state;
        }
        super.onRestoreInstanceState(superState);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable("AddFavoriteListView.superState", superState);
        bundle.putString("AddFavoriteListView.mFilter", this.mFilter);
        bundle.putInt("AddFavoriteListView.topPosition", this.pointToPosition(10, 10));
        return bundle;
    }

    public void setListener(Listener l) {
        this.mListener = l;
    }

    public void reloadAllBuddyItems() {
        long timeStart = System.currentTimeMillis();
        this.mAdapter.clear();
        this.loadAllBuddyItems(this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
    }

    public void clearSelection() {
        this.mSelectedItems.clear();
        for (int index = 0; index < this.mAdapter.getCount(); ++index) {
            AddFavoriteItem item = (AddFavoriteItem)this.mAdapter.getItem(index);
            if (item != null) {
                item.setChecked(false);
            }
            this.mAdapter.notifyDataSetChanged();
        }
        if (this.mListener != null) {
            this.mListener.onSelectionChanged();
        }
    }

    public List<AddFavoriteItem> getSelectedBuddies() {
        return this.mSelectedItems;
    }

    public void unselectBuddy(AddFavoriteItem item) {
        if (item != null) {
            AddFavoriteItem listItem = this.mAdapter.getItemByJid(item.getUserID());
            if (listItem != null) {
                listItem.setChecked(false);
                this.mAdapter.notifyDataSetChanged();
            }
            this.removeSelectedItem(item);
            if (this.mListener != null) {
                this.mListener.onSelectionChanged();
            }
        }
    }

    public void filter(String filter) {
        this.mFilter = filter;
        this.reloadAllBuddyItems();
    }

    public void setFilter(String filter) {
        this.mFilter = filter;
    }

    public String getFilter() {
        return this.mFilter;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        AddFavoriteItem item = (AddFavoriteItem)this.mAdapter.getItem(position);
        if (item != null) {
            item.setChecked(!item.isChecked());
            this.mAdapter.notifyDataSetChanged();
            if (item.isChecked()) {
                this.addSelectedItem(item);
            } else {
                this.removeSelectedItem(item);
            }
            if (this.mListener != null) {
                this.mListener.onSelectionChanged();
            }
        }
    }

    private void removeSelectedItem(AddFavoriteItem item) {
        for (int i = this.mSelectedItems.size() - 1; i >= 0; --i) {
            AddFavoriteItem tmpItem = this.mSelectedItems.get(i);
            if (item.getUserID() == null || !item.getUserID().equals(tmpItem.getUserID())) continue;
            this.mSelectedItems.remove(i);
            break;
        }
    }

    private void addSelectedItem(AddFavoriteItem item) {
        item.setChecked(true);
        for (int i = this.mSelectedItems.size() - 1; i >= 0; --i) {
            AddFavoriteItem tmpItem = this.mSelectedItems.get(i);
            if (item.getUserID() == null || !item.getUserID().equals(tmpItem.getUserID())) continue;
            this.mSelectedItems.set(i, item);
            Collections.sort(this.mSelectedItems, new FavoriteItemComparator(CompatUtils.getLocalDefault()));
            return;
        }
        this.mSelectedItems.add(item);
        Collections.sort(this.mSelectedItems, new FavoriteItemComparator(CompatUtils.getLocalDefault()));
    }

    private void initRetainedFragment() {
        this.mRetainedFragment = this.getRetainedFragment();
        if (this.mRetainedFragment == null) {
            this.mRetainedFragment = new RetainedFragment();
            this.mRetainedFragment.saveSelectedItems(this.mSelectedItems);
            ((ZMActivity)this.getContext()).getSupportFragmentManager().beginTransaction().add((Fragment)this.mRetainedFragment, RetainedFragment.class.getName()).commit();
        } else {
            List<AddFavoriteItem> oldItems = this.mRetainedFragment.restoreSelectedItems();
            if (oldItems != null) {
                this.mSelectedItems = oldItems;
            }
        }
    }

    private RetainedFragment getRetainedFragment() {
        if (this.mRetainedFragment != null) {
            return this.mRetainedFragment;
        }
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        RetainedFragment retainedFragment = (RetainedFragment)fm.findFragmentByTag(RetainedFragment.class.getName());
        return retainedFragment;
    }

    public static class RetainedFragment
    extends ZMFragment {
        private List<AddFavoriteItem> mSelectedItems = null;

        public RetainedFragment() {
            this.setRetainInstance(true);
        }

        public void saveSelectedItems(List<AddFavoriteItem> items) {
            this.mSelectedItems = items;
        }

        public List<AddFavoriteItem> restoreSelectedItems() {
            return this.mSelectedItems;
        }
    }

    public static interface Listener {
        public void onSelectionChanged();
    }
}

