/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zipow.videobox.util.FavoriteItemComparator;
import com.zipow.videobox.view.AddFavoriteItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.util.CompatUtils;

class AddFavoriteListAdapter
extends BaseAdapter {
    private static final int ITEM_TYPE_NORMAL = 0;
    private List<AddFavoriteItem> mItems = new ArrayList<AddFavoriteItem>();
    private Context mContext;

    public AddFavoriteListAdapter(Context context) {
        assert (context != null);
        this.mContext = context;
    }

    public void clear() {
        this.mItems.clear();
    }

    public void addItem(AddFavoriteItem item) {
        this.updateItem(item);
    }

    public void updateItem(AddFavoriteItem item) {
        assert (item != null);
        int position = this.findItem(item.getUserID());
        if (position >= 0) {
            this.mItems.set(position, item);
        } else {
            this.mItems.add(item);
        }
    }

    public int findItem(String userId) {
        if (userId == null) {
            return -1;
        }
        for (int i = 0; i < this.mItems.size(); ++i) {
            AddFavoriteItem item = this.mItems.get(i);
            if (!userId.equals(item.getUserID())) continue;
            return i;
        }
        return -1;
    }

    public void removeItem(String userId) {
        int position = this.findItem(userId);
        if (position >= 0) {
            this.removeItemAt(position);
        }
    }

    public void removeItemAt(int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return;
        }
        this.mItems.remove(position);
    }

    public int getCount() {
        return this.mItems.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.mItems.get(position);
    }

    public AddFavoriteItem getItemByJid(String jid) {
        for (AddFavoriteItem item : this.mItems) {
            if (!item.getUserID().equals(jid)) continue;
            return item;
        }
        return null;
    }

    public long getItemId(int position) {
        AddFavoriteItem item = (AddFavoriteItem)this.getItem(position);
        return item.getUserID().hashCode();
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public int getViewTypeCount() {
        return 1;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        View view = null;
        int type = this.getItemViewType(position);
        switch (type) {
            case 0: {
                view = this.createNormalItemView(position, convertView, parent);
            }
        }
        return view;
    }

    private View createNormalItemView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        AddFavoriteItem item = (AddFavoriteItem)this.getItem(position);
        return item.getView(this.mContext, convertView);
    }

    public void sort() {
        Collections.sort(this.mItems, new FavoriteItemComparator(CompatUtils.getLocalDefault()));
    }
}

