/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.zipow.videobox.view.IMAddrBookItem;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMSendMessageFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class ABItemDetailsList
extends ListView
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener {
    private ABItemDetailsListAdapter mAdapter = null;

    public ABItemDetailsList(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    public ABItemDetailsList(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public ABItemDetailsList(Context context) {
        super(context);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mAdapter = new ABItemDetailsListAdapter(context);
        if (this.isInEditMode()) {
            DetailListItem item = new DetailListItem(null, null, "test@example.com");
            this.mAdapter.addItem(item);
            item = new DetailListItem("+8613912345678", "+86 139 1234 5678", null);
            this.mAdapter.addItem(item);
            item = new DetailListItem("+8613987654321", "+86 139 8765 4321", null);
            this.mAdapter.addItem(item);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
        this.setOnItemLongClickListener(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)UIUtil.dip2px((Context)this.getContext(), (float)10000.0f), (int)Integer.MIN_VALUE));
    }

    public void loadData(IMAddrBookItem abItem) {
        this.mAdapter.clear();
        if (abItem == null) {
            this.mAdapter.notifyDataSetChanged();
            return;
        }
        if (abItem.isZoomRoomContact()) {
            this.mAdapter.addItem(new DetailListItem(null, null, this.getContext().getString(R.string.zm_title_zoom_room_prex)));
        } else {
            String email = abItem.getAccountEmail();
            if (!StringUtil.isEmptyOrNull((String)email)) {
                this.mAdapter.addItem(new DetailListItem(null, null, email));
            }
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.mAdapter == null) {
            return;
        }
        DetailListItem item = this.mAdapter.getItem(position);
        if (item == null) {
            return;
        }
        switch (item.getType()) {
            case 1: {
                Context context = this.getContext();
                if (context == null || !AndroidAppUtil.hasEmailApp((Context)context) || !(context instanceof FragmentActivity)) break;
                FragmentActivity fmActivity = (FragmentActivity)context;
                ZMSendMessageFragment.show((Context)context, (FragmentManager)fmActivity.getSupportFragmentManager(), (String[])new String[]{item.getEmailAddress()}, null, null, null, null, null, null, (int)1);
                break;
            }
            case 2: {
                this.showPhoneContextMenu(item.toString());
                break;
            }
        }
    }

    private void showPhoneContextMenu(String phone) {
        Context context = this.getContext();
        final ZMMenuAdapter adapter = new ZMMenuAdapter(context, false);
        adapter.addItem((IZMMenuItem)new SelectContextMenu(1, context.getString(R.string.zm_msg_call_phonenum, new Object[]{phone}), phone));
        adapter.addItem((IZMMenuItem)new SelectContextMenu(2, context.getString(R.string.zm_msg_sms_phonenum, new Object[]{phone}), phone));
        ZMAlertDialog dialog = new ZMAlertDialog.Builder(context).setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SelectContextMenu item = (SelectContextMenu)((Object)adapter.getItem(which));
                ABItemDetailsList.this.onClickSelectMenu(item);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onClickSelectMenu(SelectContextMenu item) {
        if (item == null) {
            return;
        }
        switch (item.getAction()) {
            case 0: {
                if (StringUtil.isEmptyOrNull((String)item.getValue())) break;
                AndroidAppUtil.copyText((Context)this.getContext(), (CharSequence)item.getValue());
                break;
            }
            case 1: {
                AndroidAppUtil.sendDial((Context)this.getContext(), (String)item.getValue());
                break;
            }
            case 2: {
                Context context = this.getContext();
                if (!(context instanceof FragmentActivity)) break;
                FragmentActivity fmActivity = (FragmentActivity)context;
                ZMSendMessageFragment.show((Context)context, (FragmentManager)fmActivity.getSupportFragmentManager(), null, (String[])new String[]{item.getValue()}, null, null, null, null, null, (int)2);
                break;
            }
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.mAdapter == null) {
            return false;
        }
        DetailListItem item = this.mAdapter.getItem(position);
        if (item == null) {
            return false;
        }
        Context context = this.getContext();
        final ZMMenuAdapter adapter = new ZMMenuAdapter(context, false);
        adapter.addItem((IZMMenuItem)new SelectContextMenu(0, context.getString(R.string.zm_btn_copy), item.toString()));
        ZMAlertDialog dialog = new ZMAlertDialog.Builder(context).setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SelectContextMenu item = (SelectContextMenu)((Object)adapter.getItem(which));
                ABItemDetailsList.this.onClickSelectMenu(item);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
        return true;
    }

    public static class SelectContextMenu
    extends ZMSimpleMenuItem {
        public static final int ACTION_COPY = 0;
        public static final int ACTION_PHONE_CALL = 1;
        public static final int ACTION_PHONE_MSG = 2;
        private String mValue;

        public SelectContextMenu(int action, String label, String value) {
            super(action, label);
            this.mValue = value;
        }

        public String getValue() {
            return this.mValue;
        }
    }

    static class ABItemDetailsListAdapter
    extends BaseAdapter {
        private static final int ITEM_TYPE_NORMAL = 0;
        private List<DetailListItem> mItems = new ArrayList<DetailListItem>();
        private Context mContext;

        public ABItemDetailsListAdapter(Context context) {
            assert (context != null);
            this.mContext = context;
        }

        public void clear() {
            this.mItems.clear();
        }

        public void addItem(DetailListItem item) {
            assert (item != null);
            this.mItems.add(item);
        }

        public int getCount() {
            return this.mItems.size();
        }

        public DetailListItem getItem(int position) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            return this.mItems.get(position);
        }

        public long getItemId(int position) {
            DetailListItem item = this.getItem(position);
            return item.hashCode();
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public int getViewTypeCount() {
            return 1;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            View view = null;
            int type = this.getItemViewType(position);
            switch (type) {
                case 0: {
                    view = this.createNormalItemView(position, convertView, parent);
                }
            }
            return view;
        }

        private View createNormalItemView(int position, View convertView, ViewGroup parent) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            DetailListItem item = this.getItem(position);
            View view = null;
            if (convertView != null && "ItemDetails".equals(convertView.getTag())) {
                view = convertView;
            } else {
                view = View.inflate((Context)this.mContext, (int)R.layout.zm_abitem_details_list_item, null);
                view.setTag((Object)"ItemDetails");
            }
            TextView txtNumber = (TextView)view.findViewById(R.id.txtLabel);
            txtNumber.setText((CharSequence)item.toString());
            return view;
        }
    }

    public static class DetailListItem {
        public static final int TYPE_NONE = 0;
        public static final int TYPE_EMAIL = 1;
        public static final int TYPE_PHONE = 2;
        private String formattedPhoneNumber;
        private String displayPhoneNumber;
        private String emailAddress;

        public DetailListItem(String formattedPhoneNumber, String displayPhoneNumber, String emailAddress) {
            this.formattedPhoneNumber = formattedPhoneNumber;
            this.displayPhoneNumber = displayPhoneNumber;
            this.emailAddress = emailAddress;
        }

        public String getFormattedPhoneNumber() {
            return this.formattedPhoneNumber;
        }

        public void setFormattedPhoneNumber(String formattedPhoneNumber) {
            this.formattedPhoneNumber = formattedPhoneNumber;
        }

        public String getDisplayPhoneNumber() {
            return this.displayPhoneNumber;
        }

        public void setDisplayPhoneNumber(String displayPhoneNumber) {
            this.displayPhoneNumber = displayPhoneNumber;
        }

        public void setEmailAddress(String email) {
            this.emailAddress = email;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public int getType() {
            if (!StringUtil.isEmptyOrNull((String)this.displayPhoneNumber)) {
                return 2;
            }
            if (!StringUtil.isEmptyOrNull((String)this.emailAddress)) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            if (!StringUtil.isEmptyOrNull((String)this.displayPhoneNumber)) {
                return this.displayPhoneNumber;
            }
            if (!StringUtil.isEmptyOrNull((String)this.emailAddress)) {
                return this.emailAddress;
            }
            return "";
        }
    }
}

