/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util.zmurl.avatar;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.data.DataFetcher;
import com.zipow.videobox.util.NameAbbrAvatarDrawable;
import com.zipow.videobox.util.RoundDrawable;
import com.zipow.videobox.util.zmurl.avatar.ZMAvatarCornerParams;
import com.zipow.videobox.util.zmurl.avatar.ZMAvatarUrl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ZMAvatarUrlFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = ZMAvatarUrlFetcher.class.getName();
    private int mWidth;
    private int mHeight;
    private ZMAvatarUrl mZMAvatarUrl;
    private volatile boolean isCancelled;
    private InputStream mInputStream;

    public ZMAvatarUrlFetcher(ZMAvatarUrl zmAvatarUrl, int width, int height) {
        this.mZMAvatarUrl = zmAvatarUrl;
        this.mWidth = width;
        this.mHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData(Priority priority, DataFetcher.DataCallback<? super InputStream> callback) {
        ByteArrayOutputStream stream = null;
        Bitmap bmp = null;
        try {
            ZMAvatarCornerParams params;
            bmp = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Object drawable2 = new NameAbbrAvatarDrawable(this.mZMAvatarUrl.getUrl(), this.mZMAvatarUrl.getBgColorSeedString());
            if (this.mZMAvatarUrl.isRoundCorner() && (params = this.mZMAvatarUrl.getZMAvatarCornerParams()) != null) {
                drawable2 = new RoundDrawable((Drawable)drawable2, params.getCornerRatio(), params.getBorderColor(), params.isbCircle(), params.getClientWidth(), params.getClientHeight(), params.getBorderSize());
            }
            Canvas canvas = new Canvas(bmp);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
            stream = new ByteArrayOutputStream();
            bmp.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
            this.mInputStream = new ByteArrayInputStream(stream.toByteArray());
            if (this.isCancelled) {
                callback.onDataReady(null);
                return;
            }
            callback.onDataReady((Object)this.mInputStream);
        }
        catch (OutOfMemoryError error) {
            callback.onLoadFailed(new Exception("OutOfMemoryError:" + this.mZMAvatarUrl.toString() + ">>>width*height=(" + this.mWidth + "*" + this.mHeight + ")", error));
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bmp != null) {
                bmp.recycle();
                bmp = null;
            }
        }
    }

    public void cleanup() {
        if (this.mInputStream != null) {
            try {
                this.mInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void cancel() {
        this.isCancelled = true;
    }

    @NonNull
    public Class<InputStream> getDataClass() {
        return InputStream.class;
    }

    @NonNull
    public DataSource getDataSource() {
        return DataSource.REMOTE;
    }
}

