/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util.photopicker;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import com.zipow.videobox.util.photopicker.PermissionsConstant;

public class PermissionsUtils {
    public static boolean checkReadStoragePermission(Activity activity) {
        boolean readStoragePermissionGranted;
        if (Build.VERSION.SDK_INT < 16) {
            return true;
        }
        int readStoragePermissionState = ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.READ_EXTERNAL_STORAGE");
        boolean bl = readStoragePermissionGranted = readStoragePermissionState == 0;
        if (!readStoragePermissionGranted) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])PermissionsConstant.PERMISSIONS_EXTERNAL_READ, (int)2);
        }
        return readStoragePermissionGranted;
    }

    public static boolean checkWriteStoragePermission(Fragment fragment) {
        boolean writeStoragePermissionGranted;
        int writeStoragePermissionState = ContextCompat.checkSelfPermission((Context)fragment.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        boolean bl = writeStoragePermissionGranted = writeStoragePermissionState == 0;
        if (!writeStoragePermissionGranted) {
            fragment.requestPermissions(PermissionsConstant.PERMISSIONS_EXTERNAL_WRITE, 3);
        }
        return writeStoragePermissionGranted;
    }

    public static boolean checkCameraPermission(Fragment fragment) {
        boolean cameraPermissionGranted;
        int cameraPermissionState = ContextCompat.checkSelfPermission((Context)fragment.getContext(), (String)"android.permission.CAMERA");
        boolean bl = cameraPermissionGranted = cameraPermissionState == 0;
        if (!cameraPermissionGranted) {
            fragment.requestPermissions(PermissionsConstant.PERMISSIONS_CAMERA, 1);
        }
        return cameraPermissionGranted;
    }
}

