/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util.photopicker;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import com.zipow.videobox.photopicker.entity.PhotoDirectory;
import com.zipow.videobox.util.photopicker.PhotoDirectoryLoader;
import java.util.ArrayList;
import java.util.List;
import us.zoom.videomeetings.R;

public class MediaStoreHelper {
    public static final int INDEX_ALL_PHOTOS = 0;

    public static void getPhotoDirs(FragmentActivity activity, Bundle args, PhotosResultCallback resultCallback) {
        activity.getSupportLoaderManager().initLoader(0, args, (LoaderManager.LoaderCallbacks)new PhotoDirLoaderCallbacks((Context)activity, resultCallback));
    }

    public static interface PhotosResultCallback {
        public void onResultCallback(List<PhotoDirectory> var1);
    }

    private static class PhotoDirLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private Context context;
        private PhotosResultCallback resultCallback;

        public PhotoDirLoaderCallbacks(Context context, PhotosResultCallback resultCallback) {
            this.context = context;
            this.resultCallback = resultCallback;
        }

        public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
            return new PhotoDirectoryLoader(this.context, args.getBoolean("SHOW_GIF", false));
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
            if (data == null) {
                return;
            }
            ArrayList<PhotoDirectory> directories = new ArrayList<PhotoDirectory>();
            PhotoDirectory photoDirectoryAll = new PhotoDirectory();
            photoDirectoryAll.setName(this.context.getString(R.string.zm_picker_all_image));
            photoDirectoryAll.setId("ALL");
            while (data.moveToNext()) {
                int imageId = data.getInt(data.getColumnIndexOrThrow("_id"));
                String bucketId = data.getString(data.getColumnIndexOrThrow("bucket_id"));
                String name = data.getString(data.getColumnIndexOrThrow("bucket_display_name"));
                String path = data.getString(data.getColumnIndexOrThrow("_data"));
                long size = data.getInt(data.getColumnIndexOrThrow("_size"));
                if (size < 1L) continue;
                PhotoDirectory photoDirectory = new PhotoDirectory();
                photoDirectory.setId(bucketId);
                photoDirectory.setName(name);
                if (!directories.contains(photoDirectory)) {
                    photoDirectory.setCoverPath(path);
                    photoDirectory.addPhoto(imageId, path);
                    photoDirectory.setDateAdded(data.getLong(data.getColumnIndexOrThrow("date_added")));
                    directories.add(photoDirectory);
                } else {
                    ((PhotoDirectory)directories.get(directories.indexOf(photoDirectory))).addPhoto(imageId, path);
                }
                photoDirectoryAll.addPhoto(imageId, path);
            }
            if (photoDirectoryAll.getPhotoPaths().size() > 0) {
                photoDirectoryAll.setCoverPath(photoDirectoryAll.getPhotoPaths().get(0));
            }
            directories.add(0, photoDirectoryAll);
            if (this.resultCallback != null) {
                this.resultCallback.onResultCallback(directories);
            }
        }

        public void onLoaderReset(Loader<Cursor> loader) {
        }
    }
}

