/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.support.annotation.NonNull;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.ptapp.PTApp;
import us.zoom.androidlib.util.StringUtil;

public class ZMWebUtil {
    private static final String TAG = ZMWebUtil.class.getSimpleName();
    private static final String ZM_URL_WEB_DOMAIN_WITH_HTTPS = "https://zoom.us";
    public static final String ZM_URL_WEB_SERVER_DOMAIN = "www.zoom.us";
    public static final String ZM_URL_WEB_SERVER_POSTFIX = "zoom.us";
    private static final String ZM_URL_SSO_WEB_DOMAIN_POSTFIX = ".zoom.us";

    @NonNull
    public static String getWebDomainWithHttps() {
        String postfix = ZMWebUtil.getZmUrlWebServerPostfix();
        if (StringUtil.isEmptyOrNull((String)postfix)) {
            return ZMWebUtil.getWebDomain();
        }
        return "https://" + postfix;
    }

    @NonNull
    public static String getZmUrlPrivacyPolicy() {
        return ZMWebUtil.getWebDomain() + "/privacy?onlycontent=1";
    }

    @NonNull
    public static String getDefaultWebDomain() {
        return ZM_URL_WEB_DOMAIN_WITH_HTTPS;
    }

    @NonNull
    public static String getWebDomain() {
        String domain = null;
        VideoBoxApplication videoBoxApplication = VideoBoxApplication.getInstance();
        domain = videoBoxApplication != null && videoBoxApplication.isConfApp() ? ConfMgr.getInstance().getWebDomain(true) : PTApp.getInstance().getWebDomain();
        if (StringUtil.isEmptyOrNull((String)domain)) {
            return ZM_URL_WEB_DOMAIN_WITH_HTTPS;
        }
        return domain;
    }

    public static final String getZmUrlWebServerPostfix() {
        String domain = ZMWebUtil.getWebDomain();
        if (StringUtil.isEmptyOrNull((String)domain)) {
            return ZM_URL_WEB_SERVER_POSTFIX;
        }
        String prefix = "https://www.";
        if (domain.indexOf(prefix) >= 0) {
            return domain.substring(prefix.length());
        }
        prefix = "https://";
        if (domain.indexOf(prefix) >= 0) {
            return domain.substring(prefix.length());
        }
        prefix = "http://www.";
        if (domain.indexOf(prefix) >= 0) {
            return domain.substring(prefix.length());
        }
        prefix = "http://";
        if (domain.indexOf(prefix) >= 0) {
            return domain.substring(prefix.length());
        }
        prefix = "www.";
        if (domain.indexOf(prefix) >= 0) {
            return domain.substring(prefix.length());
        }
        return ZM_URL_WEB_SERVER_POSTFIX;
    }

    public static final String getZmUrlSSOPostfix() {
        return ZM_URL_SSO_WEB_DOMAIN_POSTFIX;
    }
}

