/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class ZMConfUtil {
    public static ZoomQABuddy getZoomQABuddyByNodeId(long nodeId) {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return null;
        }
        ZoomQABuddy buddy = qacomponent.getBuddyByNodeID(nodeId);
        return buddy;
    }

    public static ZoomQABuddy getZoomQABuddyByNodeIdOrJid(long nodeId, String jid) {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return null;
        }
        ZoomQABuddy buddy = qacomponent.getBuddyByNodeID(nodeId);
        if (buddy == null && !StringUtil.isEmptyOrNull((String)jid)) {
            buddy = qacomponent.getBuddyByID(jid);
        }
        return buddy;
    }

    public static ZoomQABuddy getZoomQABuddyByJid(String jid) {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return null;
        }
        if (!StringUtil.isEmptyOrNull((String)jid)) {
            ZoomQABuddy buddy = qacomponent.getBuddyByID(jid);
            return buddy;
        }
        return null;
    }

    public static CmmAudioStatus getCmmAudioStatus(long nodeId) {
        CmmUser user = ConfMgr.getInstance().getUserById(nodeId);
        if (user != null && !user.isH323User()) {
            return user.getAudioStatusObj();
        }
        return null;
    }

    public static int getAudioImageResId(boolean isInEditMode, boolean audioOn, long audioType, long nodeId) {
        if (isInEditMode) {
            return Math.random() > 0.5 ? ZMConfUtil.getAudioOnResId(audioType) : ZMConfUtil.getAudioOffResId(audioType);
        }
        if (!audioOn) {
            return ZMConfUtil.getAudioOffResId(audioType);
        }
        CmmUser user = ConfMgr.getInstance().getUserById(nodeId);
        if (user == null) {
            return ZMConfUtil.getAudioOnResId(audioType);
        }
        CmmAudioStatus audioStatus = user.getAudioStatusObj();
        if (audioStatus == null) {
            return ZMConfUtil.getAudioOnResId(audioType);
        }
        if (audioStatus.getIsTalking()) {
            return ZMConfUtil.getTalkingResId(audioType);
        }
        return ZMConfUtil.getAudioOnResId(audioType);
    }

    private static int getAudioOnResId(long audioType) {
        if (audioType == 1L) {
            return R.drawable.zm_phone_unmuted;
        }
        return R.drawable.zm_audio_on;
    }

    private static int getAudioOffResId(long audioType) {
        if (audioType == 1L) {
            return R.drawable.zm_phone_muted;
        }
        return R.drawable.zm_audio_off;
    }

    private static int getTalkingResId(long audioType) {
        if (audioType == 1L) {
            return R.anim.zm_talking_phone;
        }
        return R.anim.zm_talking;
    }
}

