/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.util.ImageUtil;
import java.io.File;
import us.zoom.androidlib.util.ImageCache;
import us.zoom.androidlib.util.StringUtil;

public class ZMBitmapFactory {
    private static final String TAG = ZMBitmapFactory.class.getSimpleName();

    public static Bitmap decodeFile(String pathName) {
        return ZMBitmapFactory.decodeFile(pathName, false);
    }

    public static Bitmap decodeFile(String pathName, Bitmap.Config config) {
        return ZMBitmapFactory.decodeFile(pathName, -1, false, false, config);
    }

    public static Bitmap decodeFile(String pathName, int maxArea) {
        return ZMBitmapFactory.decodeFile(pathName, maxArea, false);
    }

    public static Bitmap decodeFile(String pathName, boolean fromMemCacheOnly) {
        return ZMBitmapFactory.decodeFile(pathName, -1, fromMemCacheOnly);
    }

    public static Bitmap decodeFile(String pathName, int maxArea, boolean fromMemCacheOnly) {
        return ZMBitmapFactory.decodeFile(pathName, maxArea, true, fromMemCacheOnly);
    }

    public static Bitmap decodeFile(String pathName, int maxArea, boolean useMemCache, boolean fromMemCacheOnly) {
        return ZMBitmapFactory.decodeFile(pathName, maxArea, useMemCache, fromMemCacheOnly, Bitmap.Config.ARGB_8888);
    }

    public static Bitmap decodeFile(String pathName, int maxArea, boolean useMemCache, boolean fromMemCacheOnly, Bitmap.Config config) {
        if (StringUtil.isEmptyOrNull((String)pathName)) {
            return null;
        }
        File file = new File(pathName);
        if (!file.exists()) {
            return null;
        }
        long timestamp = file.lastModified();
        Bitmap bitmap = null;
        if (useMemCache) {
            bitmap = ZMBitmapFactory.getCachedBitmap(pathName, null, timestamp);
        }
        if (!(bitmap != null || useMemCache && fromMemCacheOnly)) {
            block12: {
                if (maxArea <= 0) {
                    BitmapFactory.Options o = new BitmapFactory.Options();
                    o.inSampleSize = 1;
                    if (config != null) {
                        o.inPreferredConfig = config;
                    }
                    try {
                        while (true) {
                            try {
                                bitmap = BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)o);
                                break block12;
                            }
                            catch (OutOfMemoryError e) {
                                ++o.inSampleSize;
                                if (o.inSampleSize <= 32) continue;
                                return null;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                bitmap = ImageUtil.translateImageAsSmallBitmapInArea((Context)VideoBoxApplication.getInstance(), Uri.fromFile((File)file), maxArea, false);
            }
            if (bitmap != null && useMemCache) {
                ZMBitmapFactory.cacheBitmap(pathName, null, bitmap, timestamp);
            }
        }
        return bitmap;
    }

    public static void cacheBitmap(String pathName, String key, Bitmap bitmap, long timestamp) {
        if ((pathName != null || key != null) && bitmap != null) {
            ImageCache cache = ImageCache.getInstance();
            cache.putBitmap(new ImageCache.Key(pathName, key, timestamp), bitmap);
        }
    }

    public static Bitmap getCachedBitmap(String pathName, String key, long timestamp) {
        if (pathName == null && key == null) {
            return null;
        }
        ImageCache cache = ImageCache.getInstance();
        Bitmap bitmap = cache.getBitmap(ImageCache.Key.getFlyweightInstance((String)pathName, (String)key, (long)timestamp));
        return bitmap;
    }
}

