/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.net.Uri;
import android.text.TextUtils;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ZMActionMsgUtil {
    public static final String KEY_TYPE = "type";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_METHOD = "method";
    public static final String KEY_URL = "url";
    public static final String KEY_EVENT_ID = "eventid";
    public static final String KEY_EVENT = "text";
    public static final String TYPE_MESSAGE = "1";
    public static final String TYPE_SLASH_COMMAND = "2";
    public static final String TYPE_METHOD_GET = "GET";
    public static final String TYPE_METHOD_POST = "POST";

    public static String sendHttpMsg(Map<String, String> params) {
        return ZMActionMsgUtil.sendHttpMsg(params, false);
    }

    public static String sendHttpMsg(Map<String, String> params, boolean edit) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        if (params.containsKey(KEY_METHOD)) {
            String method = params.get(KEY_METHOD);
            String url = params.get(KEY_URL);
            if (TextUtils.isEmpty((CharSequence)url)) {
                return null;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return null;
            }
            if (TYPE_METHOD_GET.equalsIgnoreCase(method)) {
                return messenger.sendGetHttp(url);
            }
            if (TYPE_METHOD_POST.equalsIgnoreCase(method)) {
                Uri mUri = Uri.parse((String)url);
                Set pNames = mUri.getQueryParameterNames();
                HashMap<String, String> postParams = new HashMap<String, String>();
                for (String p : pNames) {
                    postParams.put(p, mUri.getQueryParameter(p));
                }
                if (edit) {
                    if (params.get(KEY_EVENT) != null) {
                        postParams.put(KEY_EVENT, params.get(KEY_EVENT));
                    }
                    if (params.get(KEY_EVENT_ID) != null) {
                        postParams.put(KEY_EVENT_ID, params.get(KEY_EVENT_ID));
                    }
                }
                return messenger.sendPostHttp(mUri.getScheme() + "://" + mUri.getAuthority() + mUri.getPath(), postParams);
            }
        }
        return null;
    }

    public static Map<String, String> parseActionMsgParams(String actionMsg) {
        ActionType actionType = ActionType.parseType(actionMsg);
        if (actionType != null) {
            switch (actionType) {
                case SENDMSG: 
                case COPYMSG: {
                    if (actionMsg.length() <= 9) break;
                    String msg = actionMsg.substring(8, actionMsg.length() - 1);
                    List<String> keys = actionType.getKeys();
                    if (keys == null || keys.isEmpty()) {
                        return ZMActionMsgUtil.parseActionMsgParams(msg);
                    }
                    return ZMActionMsgUtil.parseActionMsgParams(msg, keys.toArray(new String[keys.size()]));
                }
                case SENDHTTPMSG: {
                    if (actionMsg.length() <= 13) break;
                    String msg = actionMsg.substring(12, actionMsg.length() - 1);
                    List<String> keys = actionType.getKeys();
                    if (keys == null || keys.isEmpty()) {
                        return ZMActionMsgUtil.parseActionMsgParams(msg);
                    }
                    return ZMActionMsgUtil.parseActionMsgParams(msg, keys.toArray(new String[keys.size()]));
                }
            }
        }
        return null;
    }

    public static Map<String, String> parseActionMsgParams(String msg, String ... keys) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return result;
        }
        String[] params = msg.split(",");
        if (params.length <= 0) {
            return result;
        }
        ArrayList<String> tmp = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (int k = 0; k < params.length; ++k) {
            params[k] = params[k].trim();
            if (params[k].startsWith("'") || params[k].startsWith("\"")) {
                if (params[k].length() > 1 && (params[k].endsWith("'") || params[k].endsWith("\""))) {
                    tmp.add(params[k]);
                    continue;
                }
                builder.append(params[k]);
                continue;
            }
            if (params[k].endsWith("'") || params[k].endsWith("\"")) {
                builder.append(",").append(params[k]);
                tmp.add(builder.toString());
                builder = new StringBuilder();
                continue;
            }
            if (builder.length() <= 0) {
                tmp.add(params[k]);
                continue;
            }
            builder.append(",").append(params[k]);
        }
        params = tmp.toArray(new String[tmp.size()]);
        for (int i = 0; i < keys.length; ++i) {
            if (i < params.length && (params[i].startsWith("'") || params[i].startsWith("\""))) {
                int len = params[i].length();
                params[i] = params[i].substring(1, len - 1 > 0 ? len - 1 : len);
            }
            if (keys.length > 0 && params.length >= keys.length) {
                result.put(keys[i], params[i]);
                continue;
            }
            if (keys.length <= 0 || params.length >= keys.length) continue;
            if (keys.length - i > params.length) {
                result.put(keys[i], "");
                continue;
            }
            result.put(keys[i], params[params.length - (keys.length - i)]);
        }
        return result;
    }

    public static enum ActionType {
        SENDMSG("sendMsg", "type", "message"),
        COPYMSG("copyMsg", "type", "message"),
        SENDHTTPMSG("sendHttpMsg", "method", "url");

        private String dec;
        private List<String> keys = new ArrayList<String>();

        public String toString() {
            return this.dec;
        }

        public List<String> getKeys() {
            return this.keys;
        }

        private ActionType(String dec, String ... keys) {
            this.dec = dec;
            if (keys.length > 0) {
                this.keys.addAll(Arrays.asList(keys));
            }
        }

        public static ActionType parseType(String actionMsg) {
            if (TextUtils.isEmpty((CharSequence)actionMsg)) {
                return null;
            }
            if (actionMsg.startsWith(SENDMSG.toString())) {
                return SENDMSG;
            }
            if (actionMsg.startsWith(COPYMSG.toString())) {
                return COPYMSG;
            }
            if (actionMsg.startsWith(SENDHTTPMSG.toString())) {
                return SENDHTTPMSG;
            }
            return null;
        }
    }
}

