/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import java.util.HashMap;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.template.Template;
import us.zoom.videomeetings.R;

public class TimeFormatUtil {
    public static String formatTime(Context context, long time) {
        return TimeUtil.formatTime((Context)context, (long)time);
    }

    public static String formatDate(Context context, long time, boolean withYear) {
        if (withYear) {
            return TimeUtil.formatDateWithYear((Context)context, (long)time);
        }
        return TimeUtil.formatDate((Context)context, (long)time);
    }

    public static String formatDateTime(Context context, long time, boolean withYear) {
        return TimeFormatUtil.formatDateTime(context, time, withYear, true);
    }

    public static String formatDateTime(Context context, long time, boolean withYear, boolean abbrDate) {
        if (abbrDate) {
            int dateDiff = TimeUtil.dateDiff((long)time, (long)System.currentTimeMillis());
            if (dateDiff == 0) {
                HashMap<String, String> config = new HashMap<String, String>();
                config.put("time", TimeFormatUtil.formatTime(context, time));
                Template template = new Template(context.getString(R.string.zm_today_time));
                return template.format(config);
            }
            if (dateDiff == 1) {
                HashMap<String, String> config = new HashMap<String, String>();
                config.put("time", TimeFormatUtil.formatTime(context, time));
                Template template = new Template(context.getString(R.string.zm_tomorrow_time));
                return template.format(config);
            }
            if (dateDiff == -1) {
                HashMap<String, String> config = new HashMap<String, String>();
                config.put("time", TimeFormatUtil.formatTime(context, time));
                Template template = new Template(context.getString(R.string.zm_yesterday_time));
                return template.format(config);
            }
        }
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("date", TimeFormatUtil.formatDate(context, time, withYear));
        config.put("time", TimeFormatUtil.formatTime(context, time));
        Template template = new Template(context.getString(R.string.zm_date_time));
        return template.format(config);
    }
}

