/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.BackgroundColorSpan;
import com.google.gson.Gson;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import java.util.ArrayList;
import java.util.List;

public class TextCommandHelper {
    public static final int TYPE_COMMON = 0;
    public static final int TYPE_SLASH = 1;
    public static final int TYPE_AT = 2;
    public static final char REPLY_AT_CHAR = '@';
    public static final char SLASH_CMD_CHAE = '/';
    private static TextCommandHelper mInstance;

    private TextCommandHelper() {
    }

    public boolean isSlashCommand(Spanned spanned) {
        if (spanned == null) {
            return false;
        }
        SlashSpan[] slashSpans = (SlashSpan[])spanned.getSpans(0, spanned.length(), SlashSpan.class);
        return slashSpans != null && slashSpans.length > 0;
    }

    public boolean slashCommandAction(CharSequence s, int start, int before, int count, Spanned spanned) {
        return s.length() == 1 && count == 1 && !this.isSlashCommand(spanned) && s.charAt(start) == '/';
    }

    public boolean isAtCommand(Spanned spanned) {
        if (spanned == null) {
            return false;
        }
        AtSpan[] atSpans = (AtSpan[])spanned.getSpans(0, spanned.length(), AtSpan.class);
        return atSpans != null && atSpans.length > 0;
    }

    public boolean atCommandAction(CharSequence s, int start, int before, int count, Spanned spanned, int originLength) {
        if (s.length() > originLength && count == 1 && !this.isSlashCommand(spanned) && s.charAt(start) == '@') {
            char beforeC;
            return start <= 0 || !((beforeC = s.charAt(start - 1)) >= '0' && beforeC <= '9' || beforeC >= 'A' && beforeC <= 'Z' || beforeC >= 'a' && beforeC <= 'z') && beforeC != '_';
        }
        return false;
    }

    public void checkAndStoreSlashCommand(String sessionid, Editable editable) {
        if (editable == null || editable.length() <= 0) {
            return;
        }
        SlashSpan[] slashSpans = (SlashSpan[])editable.getSpans(0, editable.length(), SlashSpan.class);
        if (slashSpans != null && slashSpans.length > 0) {
            ArrayList<SpanBean> list = new ArrayList<SpanBean>();
            for (SlashSpan span : slashSpans) {
                int end = editable.getSpanEnd((Object)span);
                int start = editable.getSpanStart((Object)span);
                if (start < 0 || end < 0) {
                    editable.removeSpan((Object)span);
                    continue;
                }
                SpanBean spanBean = new SpanBean(start, end, span);
                list.add(spanBean);
                if (start != 0) {
                    editable.removeSpan((Object)span);
                    continue;
                }
                if (editable.charAt(start) != '/') {
                    editable.removeSpan((Object)span);
                    continue;
                }
                if (editable.charAt(end - 1) == ' ') continue;
                editable.removeSpan((Object)span);
                editable.delete(start, end);
            }
            this.storeTextCommand(sessionid, editable.toString(), list);
        }
    }

    public void checkAndStoreAtCommand(String sessionid, Editable editable) {
        if (editable == null || editable.length() <= 0) {
            return;
        }
        AtSpan[] atSpans = (AtSpan[])editable.getSpans(0, editable.length(), AtSpan.class);
        if (atSpans != null && atSpans.length > 0) {
            ArrayList<SpanBean> list = new ArrayList<SpanBean>();
            for (AtSpan span : atSpans) {
                int end = editable.getSpanEnd((Object)span);
                int start = editable.getSpanStart((Object)span);
                if (start < 0 || end < 0) {
                    editable.removeSpan((Object)span);
                    continue;
                }
                SpanBean spanBean = new SpanBean(start, end, span);
                list.add(spanBean);
                if (editable.charAt(start) != '@') {
                    editable.removeSpan((Object)span);
                    continue;
                }
                if (editable.charAt(end - 1) == ' ') continue;
                editable.removeSpan((Object)span);
                editable.delete(start, end);
            }
            this.storeTextCommand(sessionid, editable.toString(), list);
        }
    }

    public static synchronized TextCommandHelper getInstance() {
        if (mInstance == null) {
            return new TextCommandHelper();
        }
        return mInstance;
    }

    public void clearTextCommand(String sessionid) {
        this.storeTextCommand(sessionid, null);
    }

    public void storeText(String sessionid, String label) {
        this.storeTextCommand(sessionid, label, null);
    }

    public void storeTextCommand(String sessionid, String label, List<SpanBean> list) {
        if (label == null || TextUtils.isEmpty((CharSequence)label)) {
            return;
        }
        this.storeTextCommand(sessionid, new DraftBean(label, list));
    }

    public void storeTextCommand(String sessionid, DraftBean draftBean) {
        if (TextUtils.isEmpty((CharSequence)sessionid)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(sessionid);
        if (session == null) {
            return;
        }
        session.storeMessageDraft(draftBean == null ? null : new Gson().toJson((Object)draftBean));
    }

    public DraftBean restoreTextCommand(String sessionid) {
        if (TextUtils.isEmpty((CharSequence)sessionid)) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        ZoomChatSession session = messenger.getSessionById(sessionid);
        if (session == null) {
            return null;
        }
        String draft = session.getMessageDraft();
        if (TextUtils.isEmpty((CharSequence)draft)) {
            return null;
        }
        try {
            return (DraftBean)new Gson().fromJson(draft, DraftBean.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class SlashSpan
    extends BackgroundColorSpan {
        public static final Parcelable.Creator<SlashSpan> CREATOR = new Parcelable.Creator<SlashSpan>(){

            public SlashSpan createFromParcel(Parcel in) {
                return new SlashSpan(in);
            }

            public SlashSpan[] newArray(int size) {
                return new SlashSpan[size];
            }
        };
        public String jId;
        public String label;

        private SlashSpan(Parcel in) {
            this();
            this.jId = in.readString();
            this.label = in.readString();
        }

        public SlashSpan() {
            super(0);
        }

        public SlashSpan(SpanBean spanBean) {
            this();
            if (spanBean != null) {
                this.jId = spanBean.getJid();
                this.label = spanBean.getLabel();
            }
        }
    }

    public static class AtSpan
    extends BackgroundColorSpan {
        public static final Parcelable.Creator<AtSpan> CREATOR = new Parcelable.Creator<AtSpan>(){

            public AtSpan createFromParcel(Parcel in) {
                return new AtSpan(in);
            }

            public AtSpan[] newArray(int size) {
                return new AtSpan[size];
            }
        };
        public String jId;
        public String label;

        private AtSpan(Parcel in) {
            this();
            this.jId = in.readString();
            this.label = in.readString();
        }

        public AtSpan() {
            super(0);
        }

        public AtSpan(SpanBean spanBean) {
            this();
            if (spanBean != null) {
                this.jId = spanBean.getJid();
                this.label = spanBean.getLabel();
            }
        }
    }

    public static class SpanBean {
        private int start;
        private int end;
        private String label;
        private String jid;
        private int type;

        public SpanBean(int type, int start, int end, String label, String jid) {
            this.start = start;
            this.end = end;
            this.label = label;
            this.jid = jid;
            this.type = type;
        }

        public SpanBean(int start, int end, AtSpan atSpan) {
            this(2, start, end, atSpan == null ? "" : atSpan.label, atSpan == null ? "" : atSpan.jId);
        }

        public SpanBean(int start, int end, SlashSpan mySpan) {
            this(1, start, end, mySpan == null ? "" : mySpan.label, mySpan == null ? "" : mySpan.jId);
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getJid() {
            return this.jid;
        }

        public void setJid(String jid) {
            this.jid = jid;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }

    public static class DraftBean {
        private String label;
        private List<SpanBean> spans;

        public DraftBean(String label) {
            this(label, null);
        }

        public DraftBean(String label, List<SpanBean> spans) {
            if (spans != null && spans.size() <= 0) {
                spans = null;
            }
            this.label = label;
            this.spans = spans;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public List<SpanBean> getSpans() {
            return this.spans;
        }

        public void setSpans(List<SpanBean> spans) {
            this.spans = spans;
        }
    }
}

