/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import com.zipow.videobox.VideoBoxApplication;
import us.zoom.androidlib.util.UIUtil;

public class RoundDrawable
extends InsetDrawable {
    private float mCornerRatio = 0.0f;
    private int mBorderColor = -1;
    private boolean mbCircle = true;
    private int mClientWidth = 0;
    private int mClientHeight = 0;
    private int mBorderSize;

    public RoundDrawable(Drawable drawable2, float cornerRatio, int borderColor) {
        this(drawable2, cornerRatio, borderColor, true, 0, 0, UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)1.0f));
    }

    public RoundDrawable(Drawable drawable2, float cornerRatio, int borderColor, boolean bCircle, int clientWidth, int clientHeight, int borderSize) {
        super(drawable2, 0);
        this.mCornerRatio = cornerRatio;
        this.mBorderColor = borderColor;
        this.mbCircle = bCircle;
        this.mClientWidth = clientWidth;
        this.mClientHeight = clientHeight;
        this.mBorderSize = borderSize;
    }

    public void setBorderSize(int size) {
        this.mBorderSize = size;
    }

    public boolean setClientSize(int clientWidth, int clientHeight) {
        boolean changed = false;
        if (this.mClientWidth != clientWidth) {
            this.mClientWidth = clientWidth;
            changed = true;
        }
        if (this.mClientHeight != clientHeight) {
            this.mClientHeight = clientHeight;
            changed = true;
        }
        return changed;
    }

    public int getIntrinsicWidth() {
        if (this.mClientWidth <= 0 || this.mClientHeight <= 0) {
            return super.getIntrinsicWidth();
        }
        int minVal = Math.min(this.mClientWidth, this.mClientHeight);
        if (super.getIntrinsicWidth() <= super.getIntrinsicHeight()) {
            return minVal;
        }
        return super.getIntrinsicWidth() * minVal / super.getIntrinsicHeight();
    }

    public int getIntrinsicHeight() {
        if (this.mClientWidth <= 0 || this.mClientHeight <= 0) {
            return super.getIntrinsicHeight();
        }
        int minVal = Math.min(this.mClientWidth, this.mClientHeight);
        if (super.getIntrinsicWidth() >= super.getIntrinsicHeight()) {
            return minVal;
        }
        return super.getIntrinsicHeight() * minVal / super.getIntrinsicWidth();
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        Rect rect = new Rect(bounds.left, bounds.top, bounds.right, bounds.bottom);
        rect.inset(this.mBorderSize, this.mBorderSize);
        RectF rectF = new RectF(rect);
        if (this.mbCircle) {
            float edge = Math.min(rectF.width(), rectF.height());
            rectF.inset((rectF.width() - edge) / 2.0f, (rectF.height() - edge) / 2.0f);
        }
        float roundPx = this.mCornerRatio * (float)rect.width();
        float roundPy = this.mCornerRatio * (float)rect.height();
        Path path = new Path();
        path.addRoundRect(rectF, roundPx, roundPy, Path.Direction.CCW);
        canvas.save();
        canvas.clipPath(path);
        super.draw(canvas);
        canvas.restore();
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(this.mBorderColor);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth((float)this.mBorderSize);
        canvas.drawPath(path, paint);
    }

    public void setBorderColor(int color2) {
        this.mBorderColor = color2;
    }
}

