/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import com.google.gson.Gson;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.view.ComparablePItemFields;
import com.zipow.videobox.view.PListItem;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import us.zoom.androidlib.util.CollectionsUtil;

public class PListItemNewComparator
implements Comparator<PListItem> {
    Collator mCollator;

    public PListItemNewComparator(Locale locale) {
        this.mCollator = Collator.getInstance(locale);
        this.mCollator.setStrength(0);
    }

    public static void updatePlistItems(ArrayList<PListItem> pListItems) {
        if (CollectionsUtil.isListEmpty(pListItems)) {
            return;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        CmmConfStatus confStatus = confMgr.getConfStatusObj();
        ConfUI confUI = ConfUI.getInstance();
        for (PListItem pListItem : pListItems) {
            ComparablePItemFields comparablePItemFields = pListItem.getComparablePItemFields();
            comparablePItemFields.setUser(confMgr.getUserById(pListItem.userId));
            if (confStatus != null) {
                comparablePItemFields.setMySelf(confStatus.isMyself(pListItem.userId));
            }
            comparablePItemFields.setHost(confUI.isDisplayAsHost(pListItem.userId));
            comparablePItemFields.setCoHost(confUI.isDisplayAsCohost(pListItem.userId));
            comparablePItemFields.setScreenName(pListItem.screenName);
        }
    }

    public static String convertPlistItemsToString(ArrayList<PListItem> pListItems) {
        if (CollectionsUtil.isListEmpty(pListItems)) {
            return null;
        }
        ArrayList<ComparablePItemFields> comparablePItemFieldsList = new ArrayList<ComparablePItemFields>();
        for (PListItem pListItem : pListItems) {
            comparablePItemFieldsList.add(pListItem.getComparablePItemFields());
        }
        return new Gson().toJson(comparablePItemFieldsList);
    }

    @Override
    public int compare(PListItem lhs, PListItem rhs) {
        ComparablePItemFields lCPItemFields = lhs.getComparablePItemFields();
        ComparablePItemFields rCPItemFields = rhs.getComparablePItemFields();
        if (lCPItemFields.getUser() == null && rCPItemFields.getUser() == null) {
            return 0;
        }
        if (lCPItemFields.getUser() == null) {
            return 1;
        }
        if (rCPItemFields.getUser() == null) {
            return -1;
        }
        if (lCPItemFields.isMySelf() && !rCPItemFields.isMySelf()) {
            return -1;
        }
        if (!lCPItemFields.isMySelf() && rCPItemFields.isMySelf()) {
            return 1;
        }
        if (lCPItemFields.isHost() && !rCPItemFields.isHost()) {
            return -1;
        }
        if (rCPItemFields.isHost() && !lCPItemFields.isHost()) {
            return 1;
        }
        if (lCPItemFields.isSharingComputerAudio() && !rCPItemFields.isSharingComputerAudio()) {
            return -1;
        }
        if (rCPItemFields.isSharingComputerAudio() && !lCPItemFields.isSharingComputerAudio()) {
            return 1;
        }
        if (lCPItemFields.isRaiseHandState() != rCPItemFields.isRaiseHandState()) {
            if (lCPItemFields.isRaiseHandState()) {
                return -1;
            }
            return 1;
        }
        if (lCPItemFields.isRaiseHandState()) {
            long delta = lCPItemFields.getRaiseHandTimestamp() - rCPItemFields.getRaiseHandTimestamp();
            if (delta > 0L) {
                return 1;
            }
            if (delta < 0L) {
                return -1;
            }
        }
        if (lCPItemFields.isCoHost() && !rCPItemFields.isCoHost()) {
            return -1;
        }
        if (rCPItemFields.isCoHost() && !lCPItemFields.isCoHost()) {
            return 1;
        }
        if (lCPItemFields.getAudioStatus() == null && rCPItemFields.getAudioStatus() == null) {
            return 0;
        }
        if (lCPItemFields.getAudioStatus() == null) {
            return 1;
        }
        if (rCPItemFields.getAudioStatus() == null) {
            return -1;
        }
        if (lCPItemFields.getAudioType() != 2L && rCPItemFields.getAudioType() == 2L) {
            return -1;
        }
        if (lCPItemFields.getAudioType() == 2L && rCPItemFields.getAudioType() != 2L) {
            return 1;
        }
        if (!lCPItemFields.isMuted() && rCPItemFields.isMuted()) {
            return -1;
        }
        if (lCPItemFields.isMuted() && !rCPItemFields.isMuted()) {
            return 1;
        }
        return this.mCollator.compare(lCPItemFields.getScreenName(), rCPItemFields.getScreenName());
    }
}

