/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.widget.TextView;
import com.zipow.videobox.VideoBoxApplication;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.DefaultNameAbbrGenerator;
import us.zoom.androidlib.util.INameAbbrGenerator;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class NameAbbrAvatarDrawable
extends Drawable {
    private static final String TAG = NameAbbrAvatarDrawable.class.getSimpleName();
    private static final int[] BG_COLORS_IDS = new int[]{R.color.zm_abbr_avatar_bg_1, R.color.zm_abbr_avatar_bg_2, R.color.zm_abbr_avatar_bg_3, R.color.zm_abbr_avatar_bg_4, R.color.zm_abbr_avatar_bg_5, R.color.zm_abbr_avatar_bg_6, R.color.zm_abbr_avatar_bg_7, R.color.zm_abbr_avatar_bg_8, R.color.zm_abbr_avatar_bg_9, R.color.zm_abbr_avatar_bg_10, R.color.zm_abbr_avatar_bg_11, R.color.zm_abbr_avatar_bg_12};
    private int mAlpha = -1;
    private ColorFilter mColorFilter;
    private String mNameAbbr = "XX";
    private int mColorBg = -11908018;
    private int mColorFg = -1;

    public NameAbbrAvatarDrawable(String name, String mBgColorSeed) {
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        if (name == null) {
            return;
        }
        this.mColorBg = this.getBackgroundColorBySeedString((Context)context, mBgColorSeed);
        this.mColorFg = context.getResources().getColor(R.color.zm_abbr_avatar_fg);
        this.mNameAbbr = this.generateNameAbbr((Context)context, name);
    }

    private int getBackgroundColorBySeedString(Context context, String str) {
        int idx = 0;
        for (int i = 0; i < str.length(); ++i) {
            idx += str.charAt(i);
            idx %= 12;
        }
        int color2 = context.getResources().getColor(BG_COLORS_IDS[idx]);
        return color2;
    }

    private String generateNameAbbr(Context context, String name) {
        DefaultNameAbbrGenerator generator = null;
        String classGenerator = ResourcesUtil.getString((Context)context, (int)R.string.zm_config_name_abbreviation_generator);
        if (!StringUtil.isEmptyOrNull((String)classGenerator)) {
            try {
                Class<?> clazz = Class.forName(classGenerator);
                generator = (INameAbbrGenerator)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (generator == null) {
            generator = new DefaultNameAbbrGenerator();
        }
        return generator.getNameAbbreviation(name, CompatUtils.getLocalDefault());
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        int left = bounds.left;
        int top = bounds.top;
        int canvasWidth = bounds.width();
        int canvasHeight = bounds.height();
        int textSize = (int)Math.sqrt(canvasWidth / 2 * (canvasWidth / 2) / 2) * 4 / 3;
        TextPaint textPaint = new TextPaint();
        Typeface typeface = new TextView((Context)VideoBoxApplication.getInstance()).getTypeface();
        textPaint.setTypeface(typeface);
        textPaint.setColor(this.mColorFg);
        textPaint.setColorFilter(this.mColorFilter);
        textPaint.setAlpha(this.mAlpha);
        textPaint.setAntiAlias(true);
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        int minHPadding = UIUtil.dip2px((Context)context, (float)7.0f);
        int textWidth = 0;
        int horizontalPadding = 0;
        int nextSize = textSize;
        do {
            textPaint.setTextSize((float)nextSize);
            textWidth = (int)textPaint.measureText(this.mNameAbbr);
            horizontalPadding = (canvasWidth - textWidth) / 2;
            nextSize -= 2;
        } while (horizontalPadding < minHPadding);
        canvas.drawColor(this.mColorBg);
        Paint.FontMetrics fontMetrics = textPaint.getFontMetrics();
        canvas.drawText(this.mNameAbbr, (float)(left + horizontalPadding), (float)top + ((float)(canvasHeight / 2) - ((fontMetrics.bottom - fontMetrics.top) / 2.0f + fontMetrics.top)), (Paint)textPaint);
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public void setColorFilter(ColorFilter cf) {
        this.mColorFilter = cf;
    }

    public int getOpacity() {
        return 0;
    }
}

