/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import com.zipow.cmmlib.AppContext;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.util.TimeFormatUtil;
import com.zipow.videobox.util.ZMWebUtil;
import com.zipow.videobox.view.ScheduledMeetingItem;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.TimeZone;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.template.Template;
import us.zoom.videomeetings.R;

public class MeetingInvitationUtil {
    private static final String TAG = MeetingInvitationUtil.class.getSimpleName();

    public static String buildEmailInvitationContent(Context context, MeetingInfo meetingInfo, boolean includeTime) {
        if (context == null || meetingInfo == null) {
            return null;
        }
        return MeetingInvitationUtil.buildEmailInvitationContent(context, ScheduledMeetingItem.fromMeetingInfo(meetingInfo), includeTime);
    }

    public static String buildEmailInvitationContent(Context context, ScheduledMeetingItem meetingItem, boolean includeTime) {
        if (context == null || meetingItem == null) {
            return null;
        }
        String contentFromMeetingItem = null;
        if (!includeTime) {
            contentFromMeetingItem = meetingItem.getInvitationEmailContent();
        }
        if (StringUtil.isEmptyOrNull(contentFromMeetingItem)) {
            contentFromMeetingItem = meetingItem.getInvitationEmailContentWithTime();
        }
        if (!StringUtil.isEmptyOrNull((String)contentFromMeetingItem)) {
            return contentFromMeetingItem;
        }
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return null;
        }
        AppContext appContext = new AppContext("config");
        String webServer = appContext.queryWithKey("conf.webserver", AppContext.APP_NAME_CHAT);
        if (StringUtil.isEmptyOrNull((String)webServer)) {
            webServer = ZMWebUtil.getWebDomainWithHttps();
        }
        String meetingNumber = StringUtil.formatConfNumber((long)meetingItem.getMeetingNo(), (char)' ');
        String number = String.valueOf(meetingItem.getMeetingNo());
        String meetingUrl = meetingItem.getJoinMeetingUrl();
        String enablePSTN = String.valueOf(meetingItem.isPSTNEnabled());
        String usCallInNumber = meetingItem.getCallInNumber();
        String accessCode = meetingNumber;
        String[] h323Gateways = meetingItem.getH323Gateways();
        String h323Gateway1 = null;
        String h323Gateway2 = null;
        String enableH323 = "false";
        if (h323Gateways != null && h323Gateways.length > 0) {
            enableH323 = "true";
            h323Gateway1 = h323Gateways[0];
            if (h323Gateways.length > 1) {
                h323Gateway2 = h323Gateways[1];
            }
        }
        String tempateStr = MeetingInvitationUtil.loadTemplate(context);
        Template template = new Template(tempateStr);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("userName", profile.getUserName());
        config.put("meetingUrl", meetingUrl);
        config.put("webServer", webServer);
        config.put("meetingNumber", meetingNumber);
        config.put("number", number);
        config.put("enablePSTN", enablePSTN);
        config.put("usCallInNumber", usCallInNumber);
        config.put("accessCode", accessCode);
        config.put("enableH323", enableH323);
        if (h323Gateway1 != null) {
            config.put("h323Gateway1", h323Gateway1);
        }
        if (h323Gateway2 != null) {
            config.put("h323Gateway2", h323Gateway2);
        }
        if (!meetingItem.isRecurring() && includeTime) {
            String meetingTime = TimeFormatUtil.formatDateTime(context, meetingItem.getStartTime(), true, false) + " " + TimeZone.getDefault().getID() + "(" + MeetingInvitationUtil.getTimeZoneOffset() + ")";
            config.put("meetingTime", meetingTime);
        }
        if (meetingItem.hasPassword()) {
            config.put("password", meetingItem.getPassword());
        }
        String content = template.format(config);
        return content;
    }

    private static String getTimeZoneOffset() {
        TimeZone timeZone = TimeZone.getDefault();
        int offset = timeZone.getRawOffset();
        int hours = offset / 1000 / 3600;
        int minutes = (offset - hours * 1000 * 3600) / 1000 / 60;
        String id2 = hours == 0 && minutes == 0 ? "GMT" : String.format(CompatUtils.getLocalDefault(), "GMT%+d:%02d", hours, minutes);
        return id2;
    }

    private static String loadTemplate(Context context) {
        InputStream is = context.getResources().openRawResource(R.raw.zm_invitation_email_template);
        if (is == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder builder = new StringBuilder();
        try {
            String line = null;
            do {
                String lastLine = line;
                line = reader.readLine();
                if (line == null) continue;
                if (lastLine != null) {
                    builder.append('\n');
                }
                builder.append(line);
            } while (line != null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder.toString();
    }
}

