/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;

public class MaskedDrawable
extends Drawable {
    private static final String TAG = MaskedDrawable.class.getSimpleName();
    private int mAlpha = -1;
    private ColorFilter mColorFilter;
    private Drawable mMaskDrawable;
    private Bitmap mBitmap;
    private float mScale = 1.0f;

    public MaskedDrawable(Drawable maskDrawable, Bitmap bitmap, float scale) {
        if (maskDrawable == null) {
            throw new NullPointerException("maskDrawable is null");
        }
        if (bitmap == null) {
            throw new NullPointerException("bitmap is null");
        }
        this.mMaskDrawable = maskDrawable;
        this.mBitmap = bitmap;
        this.mBitmap.setDensity(1);
        this.mScale = scale;
    }

    public int getIntrinsicWidth() {
        return (int)((float)this.mBitmap.getWidth() * this.mScale);
    }

    public int getIntrinsicHeight() {
        return (int)((float)this.mBitmap.getHeight() * this.mScale);
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        this.mMaskDrawable.setBounds(bounds);
        Bitmap tmpBitmap = null;
        try {
            Bitmap.Config config = this.mBitmap.getConfig();
            if (config == null) {
                config = Bitmap.Config.RGB_565;
            }
            tmpBitmap = Bitmap.createBitmap((int)bounds.width(), (int)bounds.height(), (Bitmap.Config)config);
        }
        catch (OutOfMemoryError error) {
            return;
        }
        catch (Exception e) {
            canvas.drawBitmap(this.mBitmap, new Rect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight()), new Rect(0, 0, bounds.width(), bounds.height()), new Paint());
            return;
        }
        if (tmpBitmap == null) {
            return;
        }
        Canvas canvasBmp = new Canvas(tmpBitmap);
        Paint paint = new Paint();
        if (this.mAlpha >= 0 && this.mAlpha <= 255) {
            paint.setAlpha(this.mAlpha);
        }
        if (this.mColorFilter != null) {
            paint.setColorFilter(this.mColorFilter);
        }
        this.mMaskDrawable.draw(canvasBmp);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvasBmp.drawBitmap(this.mBitmap, new Rect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight()), new Rect(0, 0, bounds.width(), bounds.height()), paint);
        canvas.drawBitmap(tmpBitmap, 0.0f, 0.0f, new Paint());
        tmpBitmap.recycle();
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public void setColorFilter(ColorFilter cf) {
        this.mColorFilter = cf;
    }

    public int getOpacity() {
        return 0;
    }
}

