/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.util.GifException;
import com.zipow.videobox.util.ZMGlideRequestListener;
import com.zipow.videobox.util.ZMGlideUtil;
import com.zipow.videobox.util.zmurl.avatar.ZMAvatarCornerParams;
import com.zipow.videobox.util.zmurl.avatar.ZMAvatarUrl;
import com.zipow.videobox.view.ZMGifView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ImageLoader {
    private static final String TAG = ImageLoader.class.getName();
    private static ImageLoader sImageLoader;
    private HashMap<String, String> mFileCache;
    private ExecutorService mExecutorService = Executors.newSingleThreadExecutor();
    private Handler mCacheHandler;
    private static final int MSG_INIT_CACHE_FILE_COMPLETE = 1;
    private static final int MSG_ADD_CACHE_FILE = 11;
    private static final int MSG_FIX_CACHE_FILE = 12;
    private static final int MSG_FIX_CACHE_FILE_COMPLETE = 13;
    private static final int MSG_UPDATE_CACHE_FILE = 15;

    private ImageLoader() {
    }

    public void init() {
        this.mCacheHandler = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 1: {
                        if (msg.obj != null) {
                            ImageLoader.this.mFileCache = (HashMap)msg.obj;
                        }
                        ImageLoader.this.mCacheHandler.sendEmptyMessage(12);
                        break;
                    }
                    case 12: {
                        ImageLoader.this.fixCache();
                        break;
                    }
                    case 11: {
                        String oldPath;
                        String[] data = (String[])msg.obj;
                        if (data == null || data.length != 2 || TextUtils.isEmpty((CharSequence)data[0]) || TextUtils.isEmpty((CharSequence)data[1]) || !TextUtils.isEmpty((CharSequence)(oldPath = ImageLoader.this.getCacheFilePath(data[0]))) && data[1].equals(oldPath)) break;
                        ImageLoader.this.addCacheFile(data[0], data[1]);
                        ImageLoader.this.mCacheHandler.removeMessages(15);
                        ImageLoader.this.mCacheHandler.sendEmptyMessageDelayed(15, 1000L);
                        break;
                    }
                    case 13: {
                        if (msg.obj == null) break;
                        ImageLoader.this.mFileCache = (HashMap)msg.obj;
                        ImageLoader.this.mCacheHandler.removeMessages(15);
                        ImageLoader.this.mCacheHandler.sendEmptyMessageDelayed(15, 1000L);
                        break;
                    }
                    case 15: {
                        ImageLoader.this.mCacheHandler.removeMessages(15);
                        ImageLoader.this.saveCache2File();
                    }
                }
            }
        };
        this.initCacheFromFile();
    }

    public static synchronized ImageLoader getInstance() {
        if (sImageLoader == null) {
            sImageLoader = new ImageLoader();
        }
        return sImageLoader;
    }

    public File getCacheFile(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (this.mFileCache == null) {
            return null;
        }
        String path = this.getCacheFilePath(url);
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        return new File(path);
    }

    public String getCacheFilePath(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (this.mFileCache == null) {
            return null;
        }
        return this.mFileCache.get(url);
    }

    public void addCacheFile(String url, String filePath) {
        if (this.mFileCache == null) {
            this.mFileCache = new HashMap();
        }
        this.mFileCache.put(url, filePath);
    }

    public void displayGif(final ZMGifView gifView, final View progress, String url) {
        if (gifView == null || TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        ZMGlideRequestListener listener = new ZMGlideRequestListener(){

            @Override
            public void onSuccess(String url) {
                if (progress != null) {
                    progress.setVisibility(8);
                }
                if (gifView.getVisibility() != 0) {
                    gifView.setVisibility(0);
                }
                ImageLoader.this.requestToCache(url);
            }

            @Override
            public void onError(String url, GifException ex) {
                if (progress != null) {
                    progress.setVisibility(8);
                }
            }
        };
        gifView.setGifRemoteResourse(url, listener);
    }

    private void requestToCache(final Object url) {
        String urlString = this.getUrlString(url);
        File file = this.getCacheFile(urlString);
        if (file != null && file.exists()) {
            return;
        }
        this.mExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = ZMGlideUtil.getCachedFile((Context)VideoBoxApplication.getInstance(), url);
                    if (file != null && file.exists()) {
                        Message msg = ImageLoader.this.mCacheHandler.obtainMessage(11);
                        msg.obj = new String[]{ImageLoader.this.getUrlString(url), file.getAbsolutePath()};
                        msg.sendToTarget();
                    }
                }
                catch (ExecutionException executionException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    private String getUrlString(Object url) {
        if (url != null) {
            return url.toString();
        }
        return null;
    }

    private void saveCache2File() {
        if (this.mFileCache == null || this.mFileCache.isEmpty()) {
            return;
        }
        final HashMap<String, String> cache = new HashMap<String, String>(this.mFileCache);
        this.mExecutorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (cache.isEmpty()) {
                    return;
                }
                FileOutputStream fos = null;
                ObjectOutputStream oos = null;
                try {
                    fos = VideoBoxApplication.getInstance().openFileOutput("imgcache", 0);
                    oos = new ObjectOutputStream(fos);
                    oos.writeObject(cache);
                    oos.flush();
                }
                catch (Exception exception) {
                }
                finally {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
    }

    private void initCacheFromFile() {
        this.mExecutorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileInputStream fis = null;
                ObjectInputStream ois = null;
                try {
                    fis = VideoBoxApplication.getInstance().openFileInput("imgcache");
                    ois = new ObjectInputStream(fis);
                    HashMap data = (HashMap)ois.readObject();
                    if (data != null) {
                        Message msg = ImageLoader.this.mCacheHandler.obtainMessage(1);
                        msg.obj = data;
                        msg.sendToTarget();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
    }

    private void fixCache() {
        if (this.mFileCache == null || this.mFileCache.isEmpty()) {
            return;
        }
        final HashMap<String, String> cache = new HashMap<String, String>(this.mFileCache);
        this.mExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                Message msg = ImageLoader.this.mCacheHandler.obtainMessage(13);
                HashMap fixedCache = new HashMap(cache.size());
                for (Map.Entry entry : cache.entrySet()) {
                    String filePath = (String)entry.getValue();
                    if (TextUtils.isEmpty((CharSequence)filePath) || !new File(filePath).exists()) continue;
                    fixedCache.put(entry.getKey(), entry.getValue());
                }
                if (fixedCache.size() < cache.size()) {
                    msg.obj = fixedCache;
                }
                msg.sendToTarget();
            }
        });
    }

    public void displayImage(ImageView imageView, final String url) {
        if (imageView == null || TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        ZMGlideUtil.load(imageView.getContext(), imageView, (Object)url, new RequestListener(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Object resource, Object model, Target target, DataSource dataSource, boolean isFirstResource) {
                ImageLoader.this.requestToCache(url);
                return false;
            }
        });
    }

    public void displayAvatar(ImageView imageView, String url, String bgSeed, ZMAvatarCornerParams params, Drawable holder) {
        if (imageView == null || TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        final ZMAvatarUrl zmAvatarUrl = new ZMAvatarUrl(url, bgSeed, params);
        ZMGlideUtil.load(imageView.getContext(), imageView, (Object)zmAvatarUrl, holder, holder, new RequestListener(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Object resource, Object model, Target target, DataSource dataSource, boolean isFirstResource) {
                ImageLoader.this.requestToCache(zmAvatarUrl);
                return false;
            }
        });
    }
}

