/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.widget.TextView;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.zipow.cmmlib.ZoomAppPropData;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.AudioSessionMgr;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.RecordMgr;
import com.zipow.videobox.confapp.TipMessageType;
import com.zipow.videobox.confapp.ZoomRaiseHandInWebinar;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.dialog.SwitchOutputAudioDialog;
import com.zipow.videobox.fragment.ConfChatFragment;
import com.zipow.videobox.fragment.meeting.qa.ZMQAAttendeeViewerFragment;
import com.zipow.videobox.fragment.meeting.qa.ZMQAPanelistViewerFragment;
import com.zipow.videobox.ptapp.AlterHost;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.util.UpgradeUtil;
import com.zipow.videobox.util.ZMConfUtil;
import com.zipow.videobox.util.ZMWebUtil;
import com.zipow.videobox.view.ConfToolbar;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.NormalMessageTip;
import com.zipow.videobox.view.ScheduledMeetingItem;
import com.zipow.videobox.view.video.AbsVideoScene;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import com.zipow.videobox.view.video.DriverModeVideoScene;
import com.zipow.videobox.view.video.VideoLayoutHelper;
import com.zipow.videobox.view.video.VideoSceneMgr;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.webrtc.voiceengine.VoiceEnginContext;
import org.webrtc.voiceengine.VoiceEngineCompat;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class ConfLocalHelper {
    private static final String TAG = ConfLocalHelper.class.getName();

    private ConfLocalHelper() {
    }

    public static void refreshViewOnlyToolbar(ConfToolbar toolbar, CmmUser myself) {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        int btns = 448;
        if (confMgr.isConfConnected()) {
            CmmAudioStatus audioStatus;
            CmmConfContext confContext = confMgr.getConfContext();
            if (confContext == null) {
                return;
            }
            if (myself != null && (audioStatus = myself.getAudioStatusObj()) != null) {
                long audioType = audioStatus.getAudiotype();
                btns = audioType == 2L ? (btns += 2) : (myself.isViewOnlyUserCanTalk() ? (btns += 34) : (btns += 32));
            }
            if (confContext.isQANDAOFF()) {
                btns &= 0xFFFFFF7F;
            }
            if (confContext.isChatOff()) {
                btns &= 0xFFFFFEFF;
            } else {
                int[] indexes = confMgr.getUnreadChatMessageIndexes();
                if (indexes != null) {
                    toolbar.setChatsButton(indexes.length);
                }
            }
            CmmConfStatus confStatus = confMgr.getConfStatusObj();
            if (confStatus != null && !confStatus.isAllowRaiseHand()) {
                btns &= 0xFFFFFFBF;
            }
        }
        toolbar.setButtons(btns);
    }

    public static boolean shouldExcludeMsgSender(ConfActivity confActivity, long sender) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return true;
        }
        if (confStatus.isMyself(sender)) {
            return true;
        }
        if (confActivity == null) {
            return true;
        }
        ConfChatFragment chatFragment = ConfChatFragment.getConfChatFragment(confActivity.getSupportFragmentManager());
        return chatFragment != null && confStatus.isSameUser(sender, chatFragment.getUserId());
    }

    public static boolean isAudioConnected() {
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return false;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return false;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return false;
        }
        long audioType = audioStatus.getAudiotype();
        return 2L != audioType;
    }

    public static boolean isAudioMuted() {
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return false;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return false;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return false;
        }
        return audioStatus.getIsMuted();
    }

    public static boolean connectVoIP() {
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return false;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return false;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return false;
        }
        long audioType = audioStatus.getAudiotype();
        if (0L != audioType) {
            CmmConfStatus confStatus;
            if (1L == audioType && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null) {
                confStatus.hangUp();
            }
            return audioMgr.turnOnOffAudioSession(true);
        }
        return false;
    }

    public static void switchAudio(ZMActivity activity, long myAudioType) {
        if (HeadsetUtil.getInstance().isBTAndWiredHeadsetsOn()) {
            SwitchOutputAudioDialog.showDialog(activity.getSupportFragmentManager());
        } else {
            ConfLocalHelper.switchAudioSource((Context)activity, myAudioType);
        }
    }

    public static void switchAudioSource(Context context, long myAudioType) {
        boolean headsetOn;
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return;
        }
        int streamType = VoiceEnginContext.getSelectedPlayerStreamType();
        boolean isStreamVoiceCall = streamType == 0 || streamType < 0 && ConfUI.getInstance().isCallOffHook();
        boolean supportTelephony = VoiceEngineCompat.isFeatureTelephonySupported(context);
        boolean bl = headsetOn = HeadsetUtil.getInstance().isBluetoothHeadsetOn() || HeadsetUtil.getInstance().isWiredHeadsetOn();
        if (isStreamVoiceCall && (supportTelephony || headsetOn) && (myAudioType == 0L || ConfUI.getInstance().isCallOffHook())) {
            if (!(!audioMgr.getLoudSpeakerStatus() || HeadsetUtil.getInstance().isBluetoothScoAudioOn() && VoiceEngineCompat.isBluetoothScoSupported())) {
                ConfLocalHelper.toggleSpeakerPhone(false);
            } else {
                ConfLocalHelper.toggleSpeakerPhone(true);
            }
        }
    }

    public static void switchAudioSource(Context context, long myAudioType, int targetAudioType) {
        boolean headsetOn;
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return;
        }
        int streamType = VoiceEnginContext.getSelectedPlayerStreamType();
        boolean isStreamVoiceCall = streamType == 0 || streamType < 0 && ConfUI.getInstance().isCallOffHook();
        boolean supportTelephony = VoiceEngineCompat.isFeatureTelephonySupported(context);
        HeadsetUtil headsetUtil = HeadsetUtil.getInstance();
        boolean bl = headsetOn = headsetUtil.isBluetoothHeadsetOn() || headsetUtil.isWiredHeadsetOn();
        if (isStreamVoiceCall && (supportTelephony || headsetOn) && (myAudioType == 0L || ConfUI.getInstance().isCallOffHook())) {
            if (targetAudioType == 3 && headsetUtil.isBluetoothHeadsetOn() || targetAudioType == 2 || targetAudioType == 1) {
                audioMgr.setPreferedLoudSpeakerStatus(0);
            } else {
                audioMgr.setPreferedLoudSpeakerStatus(1);
            }
            ConfUI.getInstance().changeAudioOutput(targetAudioType);
        }
    }

    private static void toggleSpeakerPhone(boolean on) {
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return;
        }
        audioMgr.setPreferedLoudSpeakerStatus(on ? 1 : 0);
        ConfUI.getInstance().checkOpenLoudSpeaker();
    }

    public static void hostAskUnmute() {
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            long oldConfOption = confContext.getConfOption();
            audioMgr.setMutebySelfFlag(false);
            if (!ConfMgr.getInstance().handleUserCmd(50, 0L)) {
                audioMgr.setMutebySelfFlag(confContext.getOldMuteMyselfFlag(oldConfOption));
            }
        }
    }

    public static void showTipForUserAction(@NonNull ConfActivity confActivity, int userAction) {
        if (userAction == 5) {
            NormalMessageTip.show(confActivity.getSupportFragmentManager(), TipMessageType.TIP_AUDIO_MUTED_BY_HOST.name(), null, confActivity.getString(R.string.zm_msg_muted_by_host_32960), 3000L);
        } else if (userAction == 6) {
            NormalMessageTip.show(confActivity.getSupportFragmentManager(), TipMessageType.TIP_AUDIO_MUTED_BY_HOST_MUTEALL.name(), null, confActivity.getString(R.string.zm_msg_muted_by_host_mute_all_32960), 3000L);
        } else if (userAction == 7) {
            NormalMessageTip.show(confActivity.getSupportFragmentManager(), TipMessageType.TIP_AUDIO_UNMUTED_BY_HOST.name(), null, confActivity.getString(R.string.zm_msg_unmuted_by_host_32960), 3000L);
        } else if (userAction == 8) {
            NormalMessageTip.show(confActivity.getSupportFragmentManager(), TipMessageType.TIP_AUDIO_UNMUTED_BY_HOST_UNMUTEALL.name(), null, confActivity.getString(R.string.zm_msg_unmuted_by_host_unmute_all_32960), 3000L);
        }
    }

    public static boolean isViewOnlyButNotSpeakAttendee() {
        return ConfMgr.getInstance().isViewOnlyMeeting() && !ConfLocalHelper.isViewOnlyButSpeakAttendee();
    }

    public static boolean isViewOnlyButNotSupportMMR() {
        return ConfMgr.getInstance().isViewOnlyMeeting() && !ConfMgr.getInstance().isViewOnlyClientOnMMR();
    }

    public static boolean isGe2NotCallingOut() {
        ConfMgr confMgr = ConfMgr.getInstance();
        return confMgr.getClientUserCount() >= 2 || !confMgr.isCallingOut();
    }

    public static boolean isViewOnlyButSpeakAttendee() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return false;
        }
        CmmUser cmmUser = confMgr.getMyself();
        return cmmUser != null && cmmUser.isViewOnlyUserCanTalk();
    }

    public static int getClientWithoutOnHoldExcludeAttendeeUserCount() {
        return ConfMgr.getInstance().getClientWithoutOnHoldUserCount(true);
    }

    public static int getClientWithoutOnHoldIncludeAttendeeUserCount() {
        return ConfMgr.getInstance().getClientWithoutOnHoldUserCount(false);
    }

    public static void setAttendeeVideoLayout(int videoLayoutMode) {
        CmmConfStatus confStatus;
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself != null && myself.isHost() && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null && confStatus.getAttendeeVideoLayoutMode() != videoLayoutMode) {
            confStatus.setLiveLayoutMode(videoLayoutMode == 0);
        }
    }

    public static void setAttendeeVideoControlMode(int videoControlMode) {
        CmmConfStatus confStatus;
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself != null && myself.isHost() && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null) {
            confStatus.setAttendeeVideoControlMode(videoControlMode);
        }
    }

    public static int getTotalVideoCount() {
        return ConfLocalHelper.isHideNoVideoUsers() ? ConfMgr.getInstance().getVideoUserCount() : ConfLocalHelper.getClientWithoutOnHoldIncludeAttendeeUserCount();
    }

    public static boolean isMeetSwitchToGalleryView() {
        if (ConfLocalHelper.isAttendeeSupportVideoLayoutChange()) {
            return ConfMgr.getInstance().getVideoUserCount() > 0;
        }
        int videoCount = ConfLocalHelper.isHideNoVideoUsers() ? ConfMgr.getInstance().getVideoUserCount() : ConfLocalHelper.getClientWithoutOnHoldIncludeAttendeeUserCount();
        return videoCount >= 2;
    }

    public static boolean shouldSwitchActiveSpeakerView(AbsVideoSceneMgr absVideoSceneMgr) {
        if (absVideoSceneMgr instanceof VideoSceneMgr && !ConfLocalHelper.isMeetSwitchToGalleryView()) {
            VideoSceneMgr videoSceneMgr = (VideoSceneMgr)absVideoSceneMgr;
            AbsVideoScene activeScene = videoSceneMgr.getActiveScene();
            if (activeScene == null || !(activeScene instanceof DriverModeVideoScene)) {
                videoSceneMgr.switchToDefaultScene();
            }
            return true;
        }
        return false;
    }

    public static boolean isHideNoVideoUsers() {
        return VideoLayoutHelper.getInstance().isHideNoVideoUsersEnabled() || ConfLocalHelper.isAttendeeSupportVideoLayoutChange();
    }

    public static boolean isAttendeeSupportVideoLayoutChange() {
        return ConfMgr.getInstance().isViewOnlyClientOnMMR();
    }

    public static boolean hasVideo(CmmUser user) {
        if (!(user == null || user.isMMRUser() || user.isPureCallInUser() || user.inSilentMode())) {
            CmmVideoStatus videoStatus = user.getVideoStatusObj();
            return videoStatus != null && videoStatus.getIsSending();
        }
        return false;
    }

    public static CmmUser getHasVideoUserAt(CmmUserList userList, CmmConfStatus confStatus, int unitsCount, int pageIndex, int indexInPage, boolean isInBOMeeting) {
        CmmUser myself = userList.getMyself();
        boolean myselfHasVideo = ConfLocalHelper.hasVideo(myself);
        if (pageIndex == 0 && indexInPage == 0 && myselfHasVideo) {
            return myself;
        }
        int curPageIndex = 0;
        int indexInCurPage = myselfHasVideo ? 1 : 0;
        int userCount = userList.getUserCount();
        for (int i = 0; i < userCount; ++i) {
            CmmUser user = userList.getUserAt(i);
            if (user == null || confStatus.isMyself(user.getNodeId()) || !ConfLocalHelper.hasVideo(user) || !isInBOMeeting && user.isInBOMeeting()) continue;
            if (curPageIndex == pageIndex && indexInCurPage == indexInPage) {
                return user;
            }
            if (++indexInCurPage != unitsCount) continue;
            indexInCurPage = 0;
            ++curPageIndex;
        }
        return null;
    }

    public static CmmUser getUserAt(CmmUserList userList, CmmConfStatus confStatus, int unitsCount, int pageIndex, int indexInPage, boolean isInBOMeeting) {
        if (pageIndex == 0 && indexInPage == 0) {
            return userList.getMyself();
        }
        int curPageIndex = 0;
        int indexInCurPage = 1;
        int userCount = userList.getUserCount();
        for (int i = 0; i < userCount; ++i) {
            CmmUser user = userList.getUserAt(i);
            if (user == null || user.isMMRUser() || confStatus.isMyself(user.getNodeId()) || user.inSilentMode() || !isInBOMeeting && user.isInBOMeeting()) continue;
            if (curPageIndex == pageIndex && indexInCurPage == indexInPage) {
                return user;
            }
            if (++indexInCurPage != unitsCount) continue;
            indexInCurPage = 0;
            ++curPageIndex;
        }
        return null;
    }

    public static boolean isNeedShowAttendeeActionList() {
        CmmConfContext confContext;
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null || ConfMgr.getInstance().isViewOnlyMeeting()) {
            return false;
        }
        return myself.isHost() || myself.isCoHost() || (confContext = ConfMgr.getInstance().getConfContext()) != null && !confContext.isChatOff() && !confContext.isPrivateChatOFF();
    }

    public static boolean isHostCoHostBOModerator() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        return myself != null && (myself.isHost() || myself.isCoHost() || myself.isBOModerator());
    }

    public static boolean isHostCoHost() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        return myself != null && (myself.isHost() || myself.isCoHost());
    }

    public static boolean isHost() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        return myself != null && myself.isHost();
    }

    public static boolean isCoHost() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        return myself != null && myself.isCoHost();
    }

    public static boolean isHaisedHand(String jid) {
        ZoomRaiseHandInWebinar raiseHandInWebinar = ConfMgr.getInstance().getRaiseHandAPIObj();
        boolean isHaisedHand = false;
        if (raiseHandInWebinar != null) {
            isHaisedHand = raiseHandInWebinar.getRaisedHandStatus(jid);
        }
        return isHaisedHand;
    }

    public static boolean isTalking(long nodeId) {
        CmmAudioStatus audioStatus;
        CmmUser user = ConfMgr.getInstance().getUserById(nodeId);
        return user != null && (audioStatus = user.getAudioStatusObj()) != null && audioStatus.getIsTalking();
    }

    public static boolean isWebinar() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        return confContext != null && confContext.isWebinar();
    }

    public static boolean isGuest(CmmUser user) {
        if (user == null) {
            return false;
        }
        if (user.isViewOnlyUserCanTalk()) {
            return ConfLocalHelper.isGuestForBuddy(user.getNodeId());
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        return confContext != null && confContext.isHighlightGuestFeatureEnabled() && user.isGuest() && !confContext.amIGuest();
    }

    public static boolean isGuestForMyself() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        return confContext != null && confContext.amIGuest();
    }

    private static boolean isGuestForBuddy(long nodeId) {
        ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(nodeId);
        return buddy != null && ConfLocalHelper.isGuest(buddy);
    }

    public static boolean isGuest(ZoomQABuddy buddy) {
        if (buddy == null) {
            return false;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        return confContext != null && confContext.isHighlightGuestFeatureEnabled() && buddy.isGuest() && !confContext.amIGuest();
    }

    public static CmmAudioStatus getMySelfAudioStatus() {
        if (!ConfMgr.getInstance().isConfConnected()) {
            return null;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return null;
        }
        return myself.getAudioStatusObj();
    }

    public static String getWaterMarkString() {
        String text;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        StringBuffer stringBuffer = new StringBuffer();
        if (confContext != null && confContext.isSupportConfidentialWaterMarker() && !StringUtil.isEmptyOrNull((String)(text = confContext.getConfidentialWaterMarker()))) {
            stringBuffer.append(text);
        }
        return stringBuffer.toString();
    }

    public static boolean isNeedShowPresenterNameToWaterMark() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        return confContext != null && confContext.needShowPresenterNameToWaterMark();
    }

    public static Bitmap createWaterMarkBitmap(int waterMarkWidth, int waterMarkHeight, int textColorId, float scale) {
        Bitmap bitmap;
        int width;
        double ctgTheta;
        double theta;
        String text = ConfLocalHelper.getWaterMarkString();
        if (StringUtil.isEmptyOrNull((String)text)) {
            return null;
        }
        if (waterMarkWidth < waterMarkHeight) {
            int oldWaterMarkHeightHeight = waterMarkHeight;
            waterMarkHeight = waterMarkHeight * waterMarkHeight / waterMarkWidth;
            waterMarkWidth = oldWaterMarkHeightHeight;
        }
        TextPaint textPaint = new TextPaint();
        Typeface typeface = new TextView((Context)VideoBoxApplication.getInstance()).getTypeface();
        textPaint.setTypeface(typeface);
        textPaint.setTextSize((float)UIUtil.sp2px((Context)VideoBoxApplication.getInstance(), (float)36.0f));
        textPaint.setColor(VideoBoxApplication.getInstance().getResources().getColor(textColorId));
        textPaint.setAntiAlias(true);
        textPaint.setStyle(Paint.Style.FILL);
        int textWidth = (int)(textPaint.measureText(text) / scale);
        StaticLayout textLayout = new StaticLayout((CharSequence)text, textPaint, textWidth, Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
        int textHeight = textLayout.getHeight();
        if (waterMarkWidth >= waterMarkHeight) {
            theta = Math.atan((float)waterMarkHeight / (float)waterMarkWidth);
            ctgTheta = (double)waterMarkWidth / (double)waterMarkHeight;
            width = (int)(((double)textHeight * ctgTheta + (double)textWidth) * Math.cos(theta));
        } else {
            theta = Math.atan((float)waterMarkWidth / (float)waterMarkHeight);
            ctgTheta = (double)waterMarkHeight / (double)waterMarkWidth;
            width = (int)(((double)textHeight * ctgTheta + (double)textWidth) * Math.sin(theta));
        }
        int height = width * waterMarkHeight / waterMarkWidth;
        try {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (Exception e) {
            return null;
        }
        Canvas canvas = new Canvas(bitmap);
        Matrix matrix = new Matrix();
        float degree = (float)Math.toDegrees(Math.atan((float)height / (float)width));
        matrix.setRotate(-degree, (float)(width / 2), (float)(height / 2));
        canvas.setMatrix(matrix);
        float x = (width - textWidth) / 2;
        float y = (height - textHeight) / 2;
        canvas.translate(x, y);
        textLayout.draw(canvas);
        textPaint.setColor(0x1A000000);
        textPaint.setStyle(Paint.Style.STROKE);
        textPaint.setStrokeJoin(Paint.Join.ROUND);
        textPaint.setStrokeWidth(0.0f);
        textLayout = new StaticLayout((CharSequence)text, textPaint, textWidth, Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
        textLayout.draw(canvas);
        return bitmap;
    }

    public static void showChatUI(ZMFragment zmFragment, long userId) {
        if (zmFragment == null) {
            return;
        }
        ZMActivity activity = (ZMActivity)zmFragment.getActivity();
        if (activity == null) {
            return;
        }
        ConfLocalHelper.showChatUI(activity, userId);
    }

    public static void showChatUI(ZMActivity activity, long userId) {
        if (activity == null) {
            return;
        }
        CmmConfContext context = ConfMgr.getInstance().getConfContext();
        if (userId != 0L && (context == null || context.isPrivateChatOFF())) {
            return;
        }
        if (UIMgr.isLargeMode((Context)activity)) {
            ConfChatFragment.showAsFragment(activity.getSupportFragmentManager(), userId);
        } else {
            ConfChatFragment.showAsActivity(activity, 0, userId);
        }
    }

    public static boolean isSameActiveCall(ScheduledMeetingItem scheduledMeetingItem) {
        boolean isSameActiveCall;
        boolean bl = isSameActiveCall = PTApp.getInstance().hasActiveCall() && VideoBoxApplication.getInstance().isConfProcessRunning();
        if (isSameActiveCall) {
            boolean bl2 = isSameActiveCall = PTApp.getInstance().getActiveMeetingNo() == scheduledMeetingItem.getMeetingNo();
            if (!isSameActiveCall) {
                String activeCallId = PTApp.getInstance().getActiveCallId();
                isSameActiveCall = activeCallId != null && activeCallId.equals(scheduledMeetingItem.getId());
            }
        }
        return isSameActiveCall;
    }

    public static String getDescAlternativeHosts(Context context, long meetingNumber) {
        if (context == null) {
            return null;
        }
        MeetingInfo meetingInfo = PTApp.getInstance().getMeetingHelper().getMeetingItemByNumber(meetingNumber);
        if (meetingInfo == null) {
            return null;
        }
        ArrayList<AlterHost> alterHostList = meetingInfo.getAlterHostList();
        return ConfLocalHelper.getDescAlternativeHosts(context, alterHostList);
    }

    public static String getDescAlternativeHosts(Context context, List<AlterHost> alterHostList) {
        if (alterHostList != null && !alterHostList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (AlterHost alterHost : alterHostList) {
                if (alterHost == null) continue;
                String tmp = alterHost.getFirstName();
                if (StringUtil.isEmptyOrNull((String)tmp)) {
                    tmp = alterHost.getLastName();
                } else {
                    stringBuilder.append(tmp);
                    if (!StringUtil.isEmptyOrNull((String)alterHost.getLastName())) {
                        stringBuilder.append(" ").append(alterHost.getLastName());
                    }
                }
                if (!StringUtil.isEmptyOrNull((String)tmp)) break;
                stringBuilder.append(alterHost.getEmail());
                break;
            }
            if (alterHostList.size() > 1) {
                return context.getString(R.string.zm_desc_alterhost_21201, new Object[]{stringBuilder.toString(), alterHostList.size() - 1});
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static ArrayList<AlterHost> transformIMAddrBookItemsToAlterHosts(List<IMAddrBookItem> abItems, Set<String> emails) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        ArrayList<AlterHost> alterHostList = new ArrayList<AlterHost>();
        if (abItems != null && !abItems.isEmpty()) {
            AlterHost alterhost = new AlterHost();
            for (IMAddrBookItem imAddrBookItem : abItems) {
                ZoomBuddy buddy;
                String email = StringUtil.safeString((String)imAddrBookItem.getAccountEmail());
                if (imAddrBookItem.isManualInput()) {
                    emails.add(email);
                }
                String jid = imAddrBookItem.getJid();
                alterhost.setEmail(email);
                alterhost.setPmi(imAddrBookItem.getPmi());
                alterhost.setFirstName(StringUtil.safeString((String)imAddrBookItem.getScreenName()));
                if (messenger == null) {
                    alterHostList.add(alterhost);
                    continue;
                }
                if (!StringUtil.isEmptyOrNull((String)jid) && (buddy = messenger.getBuddyWithJID(jid)) != null) {
                    alterhost.setHostID(jid);
                    alterhost.setFirstName(StringUtil.safeString((String)buddy.getFirstName()));
                    alterhost.setLastName(StringUtil.safeString((String)buddy.getLastName()));
                }
                alterHostList.add(alterhost);
            }
        }
        return alterHostList;
    }

    public static String formatScheduleMeetingErrorMsg(String errorMsg) {
        if (!StringUtil.isEmptyOrNull((String)errorMsg)) {
            String[] tmps = errorMsg.split("#|,");
            if (tmps.length > 0) {
                String result = "";
                for (String str : tmps) {
                    if (StringUtil.isEmptyOrNull((String)str) || !str.contains("@")) continue;
                    result = result + str + ",";
                }
                if (result.length() > 1) {
                    result = result.substring(0, result.length() - 1);
                }
                return result;
            }
            return errorMsg;
        }
        return "";
    }

    public static void saveAlterHostsForOnlyEmail(List<AlterHost> alterHostList, Set<String> inputEmails) {
        if (alterHostList != null && !alterHostList.isEmpty()) {
            ZoomAppPropData zoomAppPropData;
            HashSet<String> emails = new HashSet<String>();
            for (AlterHost alterHost : alterHostList) {
                String email = alterHost.getEmail();
                if (!inputEmails.contains(email)) continue;
                emails.add(email);
            }
            if (!emails.isEmpty() && (zoomAppPropData = ZoomAppPropData.getInstance()) != null) {
                Set<String> localEmails = ConfLocalHelper.loadHistoryEmailsForAlterHosts();
                if (localEmails != null && !localEmails.isEmpty()) {
                    emails.addAll(localEmails);
                }
                Gson gson = new Gson();
                Type listType = new TypeToken<Set<String>>(){}.getType();
                String value = gson.toJson(emails, listType);
                zoomAppPropData.setKeyValue("android.alternate.host.cache", value);
            }
        }
    }

    public static Set<String> loadHistoryEmailsForAlterHosts() {
        String value;
        ZoomAppPropData zoomAppPropData = ZoomAppPropData.getInstance();
        if (zoomAppPropData != null && !StringUtil.isEmptyOrNull((String)(value = zoomAppPropData.queryWithKey("android.alternate.host.cache", null)))) {
            Gson gson = new Gson();
            Type listType = new TypeToken<Set<String>>(){}.getType();
            return (Set)gson.fromJson(value, listType);
        }
        return null;
    }

    public static boolean stopRecord() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        return recordMgr != null && recordMgr.stopRecord(recordMgr.isCMRInProgress());
    }

    public static boolean resumeRecord() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr == null) {
            return false;
        }
        if (recordMgr.canControlCMR() && recordMgr.canControlCMR()) {
            return recordMgr.resumeCMR();
        }
        return false;
    }

    public static boolean pauseRecord() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        return recordMgr != null && recordMgr.canControlCMR() && recordMgr.pauseCMR();
    }

    public static int errorCodeToLeaveReason(int errorCode) {
        int leaveReason;
        switch (errorCode) {
            case 1: {
                leaveReason = 11;
                break;
            }
            case 3: {
                leaveReason = 12;
                break;
            }
            case 5: {
                leaveReason = 19;
                break;
            }
            case 6: {
                leaveReason = 14;
                break;
            }
            case 8: {
                leaveReason = 15;
                break;
            }
            case 9: {
                leaveReason = 10;
                break;
            }
            case 11: {
                leaveReason = 13;
                break;
            }
            case 12: {
                leaveReason = 20;
                break;
            }
            case 13: {
                leaveReason = 17;
                break;
            }
            case 14: {
                leaveReason = 18;
                break;
            }
            case 15: {
                leaveReason = 5;
                break;
            }
            case 19: {
                leaveReason = 21;
                break;
            }
            case 20: {
                leaveReason = 22;
                break;
            }
            case 21: {
                leaveReason = 23;
                break;
            }
            case 22: {
                leaveReason = 24;
                break;
            }
            case 23: {
                leaveReason = 26;
                break;
            }
            default: {
                leaveReason = 27;
            }
        }
        return leaveReason;
    }

    public static String errorCodeToMessage(Resources res, int errorCode) {
        String message = "";
        switch (errorCode) {
            case 9: {
                CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                if (confContext == null) break;
                message = res.getString(R.string.zm_msg_conffail_userfull_confirm, new Object[]{confContext.getParticipantLimit()});
                break;
            }
            case 1: {
                message = res.getString(R.string.zm_msg_conffail_neterror_confirm, new Object[]{ConfMgr.getInstance().getLastNetworkErrorCode()});
                break;
            }
            case 3: {
                message = res.getString(R.string.zm_msg_conffail_retry_confirm);
                break;
            }
            case 11: {
                message = res.getString(R.string.zm_msg_conffail_no_mmr_confirm);
                break;
            }
            case 6: {
                message = res.getString(R.string.zm_msg_conffail_callover_confirm);
                break;
            }
            case 8: {
                message = res.getString(R.string.zm_msg_conffail_callnotthere_confirm);
                break;
            }
            case 10: {
                message = res.getString(R.string.zm_msg_conffail_needupdate_confirm);
                break;
            }
            case 12: {
                message = res.getString(R.string.zm_msg_conffail_locked_confirm);
                break;
            }
            case 13: {
                message = res.getString(R.string.zm_msg_conffail_single_meeting_restricted_confirm);
                break;
            }
            case 14: {
                message = res.getString(R.string.zm_msg_conffail_single_meeting_restricted_jbh_confirm);
                break;
            }
            case 19: {
                message = res.getString(R.string.zm_msg_conffail_webinar_register_full);
                break;
            }
            case 20: {
                message = res.getString(R.string.zm_msg_conffail_webinar_register_with_host_email);
                break;
            }
            case 21: {
                message = res.getString(R.string.zm_msg_conffail_webinar_register_with_panelist_email);
                break;
            }
            case 22: {
                message = res.getString(R.string.zm_msg_conffail_webinar_register_denied);
                break;
            }
            case 23: {
                message = res.getString(R.string.zm_msg_conffail_webinar_register_enforce_login);
                break;
            }
            case 24: {
                message = res.getString(R.string.zm_msg_conffail_certificate_changed, new Object[]{ZMWebUtil.getZmUrlWebServerPostfix(), res.getString(R.string.zm_firewall_support_url)});
                break;
            }
            case 27: {
                message = res.getString(R.string.zm_msg_conffail_meeting_name_unvalid);
                break;
            }
            case 28: {
                message = res.getString(R.string.zm_msg_conffail_join_webinar_withsameemail);
                break;
            }
            case 61: {
                message = res.getString(R.string.zm_msg_conffail_cannot_rejoin_by_removed_44379);
                break;
            }
            default: {
                message = res.getString(R.string.zm_msg_conffail_unknownerror_confirm, new Object[]{errorCode});
            }
        }
        return message;
    }

    public static void leaveCall(ConfActivity confActivity) {
        if (confActivity != null) {
            confActivity.finish(true);
            ConfMgr.getInstance().leaveConference();
        }
    }

    public static void endCall(ConfActivity confActivity) {
        if (confActivity != null) {
            confActivity.finish(true);
            ConfMgr.getInstance().endConference();
        }
    }

    public static void leaveAndUpdate(ConfActivity confActivity) {
        if (confActivity != null) {
            ConfMgr.getInstance().leaveConference();
            UpgradeUtil.upgrade(confActivity);
            confActivity.finish(true);
        }
    }

    public static void leaveAndLogin(ConfActivity confActivity) {
        if (confActivity != null) {
            ConfMgr.getInstance().notifyPTStartLogin("Login to start meeting");
            confActivity.finish(true);
        }
    }

    public static void endOtherMeeting() {
        ConfMgr.getInstance().handleConfCmd(67);
    }

    public static String getLiveChannelStreamName() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isLiveOn()) {
            int count = confStatus.getLiveChannelsCount();
            for (int i = 0; i < count; ++i) {
                if (!confStatus.isLiveChannelsOn(i)) continue;
                return confStatus.getLiveChannelsName(i);
            }
        }
        return "";
    }

    public static String getLiveChannelStreamUrl() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isLiveOn()) {
            int count = confStatus.getLiveChannelsCount();
            for (int i = 0; i < count; ++i) {
                if (!confStatus.isLiveChannelsOn(i)) continue;
                return confStatus.getLiveChannelUrL(i);
            }
        }
        return "";
    }

    public static boolean isInSilentMode() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return false;
        }
        return confContext.inSilentMode();
    }

    public static void showQA(ConfActivity confActivity) {
        if (ConfMgr.getInstance().isViewOnlyMeeting()) {
            ZMQAAttendeeViewerFragment.showAsActivity(confActivity);
        } else {
            ZMQAPanelistViewerFragment.showAsActivity(confActivity);
        }
    }
}

