/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.tempbean;

import android.graphics.Color;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.widget.TextView;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import us.zoom.androidlib.util.ZMLog;

public class IMessageTemplateTextStyle {
    private boolean bold;
    private String color;
    private boolean italic;

    public static IMessageTemplateTextStyle parse(JsonObject jsonObject) {
        JsonElement element;
        if (jsonObject == null) {
            return null;
        }
        IMessageTemplateTextStyle style2 = new IMessageTemplateTextStyle();
        if (jsonObject.has("bold") && (element = jsonObject.get("bold")) != null) {
            style2.setBold(element.getAsBoolean());
        }
        if (jsonObject.has("color") && (element = jsonObject.get("color")) != null) {
            style2.setColor(element.getAsString());
        }
        if (jsonObject.has("italic") && (element = jsonObject.get("italic")) != null) {
            style2.setItalic(element.getAsBoolean());
        }
        return style2;
    }

    public void writeJson(JsonWriter writer) throws IOException {
        writer.beginObject();
        writer.name("bold").value(this.bold);
        if (this.color != null) {
            writer.name("color").value(this.color);
        }
        writer.name("italic").value(this.italic);
        writer.endObject();
    }

    public void applyStyle(TextView textView) {
        if (textView == null) {
            return;
        }
        if (this.isBold() && this.isItalic()) {
            textView.setTypeface(Typeface.DEFAULT, 3);
        } else if (this.isBold()) {
            textView.setTypeface(Typeface.DEFAULT, 1);
        } else if (this.isItalic()) {
            textView.setTypeface(Typeface.DEFAULT, 2);
        }
        if (!TextUtils.isEmpty((CharSequence)this.getColor())) {
            try {
                int color2 = Color.parseColor((String)this.getColor());
                textView.setTextColor(color2);
            }
            catch (Exception e) {
                if ("orange".equalsIgnoreCase(this.getColor())) {
                    int color3 = Color.parseColor((String)"#FFA500");
                    textView.setTextColor(color3);
                }
                ZMLog.e((String)IMessageTemplateTextStyle.class.getSimpleName(), (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color2) {
        this.color = color2;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }
}

