/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.stabilility;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.SystemInfoHelper;
import com.zipow.videobox.stabilility.JavaCrashHandler;
import com.zipow.videobox.util.LogUtil;
import com.zipow.videobox.util.PreferenceUtil;
import java.io.File;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import us.zoom.androidlib.app.ZMActivity;

public class DeadLockDetector {
    private final String TAG = DeadLockDetector.class.getSimpleName();
    private static final long HEARTBEAT_PERIOD = 3000L;
    private static final long CHECK_PERIOD = 5000L;
    private static final long DEADLOCK_CHECK_THRESHOLD = 30000L;
    private Handler mHandler;
    private Runnable mRunnable;
    private boolean mRunning = false;
    private long mLastHeartbeatTime = 0L;
    private DeadLockDetectorThread mDetectThread;
    private long mCurrentTime = 0L;
    private File mLastDeadlockLogFile;

    public DeadLockDetector() {
        if (Looper.getMainLooper().getThread().getId() != Thread.currentThread().getId()) {
            throw new RuntimeException("Not called from main thread");
        }
        this.mHandler = new Handler();
        this.mRunnable = new Runnable(){

            @Override
            public void run() {
                DeadLockDetector.this.mLastHeartbeatTime = DeadLockDetector.this.getCurrentTime();
                if (DeadLockDetector.this.mLastDeadlockLogFile != null && DeadLockDetector.this.mLastDeadlockLogFile.exists()) {
                    DeadLockDetector.this.mLastDeadlockLogFile.delete();
                    DeadLockDetector.this.mLastDeadlockLogFile = null;
                    PreferenceUtil.removeValue("camera_is_freezed");
                }
                if (DeadLockDetector.this.mRunning) {
                    DeadLockDetector.this.mHandler.postDelayed(DeadLockDetector.this.mRunnable, 3000L);
                }
            }
        };
    }

    private long getCurrentTime() {
        return this.mCurrentTime;
    }

    private void increaseCurrentTime(long increase) {
        this.mCurrentTime += increase;
    }

    public void start() {
        this.mRunning = true;
        this.mLastHeartbeatTime = this.getCurrentTime();
        this.mHandler.postDelayed(this.mRunnable, 3000L);
        this.mDetectThread = new DeadLockDetectorThread();
        this.mDetectThread.start();
    }

    public void stop() {
        this.mRunning = false;
        if (this.mDetectThread.isAlive()) {
            this.mDetectThread.interrupt();
        }
        this.mDetectThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDeadLock(Thread detectorThread) {
        if (this.isCameraAPIFreezed()) {
            boolean hasCameraFreezedBefore = PreferenceUtil.readBooleanValue("camera_is_freezed", false);
            if (hasCameraFreezedBefore) {
                return;
            }
            PreferenceUtil.saveBooleanValue("camera_is_freezed", true);
        }
        int pid = Process.myPid();
        String pname = VideoBoxApplication.getInstance().isConfApp() ? "zVideoApp" : "zChatApp";
        File file = LogUtil.getNewLogFile("freeze-", "-" + pname + "-" + pid + ".log", 5, System.currentTimeMillis());
        if (file == null) {
            return;
        }
        PrintStream os = null;
        try {
            CmmConfContext confContext;
            os = new PrintStream(file);
            os.println("version: " + VideoBoxApplication.getInstance().getVersionName());
            os.println("Kernel Version: " + VideoBoxApplication.getInstance().getKernelVersion());
            os.println("OS: " + SystemInfoHelper.getOSInfo());
            os.println("Hardware: " + SystemInfoHelper.getHardwareInfo());
            os.println("MemCPU: " + VideoBoxApplication.getMemoryCPUStatistics());
            if (VideoBoxApplication.getInstance().isConfApp() && (confContext = ConfMgr.getInstance().getConfContext()) != null) {
                String meetingId = confContext.getMeetingId();
                long meetingNumber = confContext.getConfNumber();
                CmmUser user = ConfMgr.getInstance().getMyself();
                long nodeId = user != null ? user.getNodeId() : 0L;
                StringBuilder sb = new StringBuilder();
                sb.append("MeetingId:").append(meetingId).append("; ").append("MeetingNo:").append(meetingNumber).append("; ").append("NodeId:").append(nodeId);
                os.println(sb.toString());
            }
            os.println();
            String startMessage = "=====================Start to print dead lock stacks===================";
            os.println(startMessage);
            this.printThreadsStacks(detectorThread, os);
            String endMessage = "=======================Dead lock stacks till here======================";
            os.println(endMessage);
        }
        catch (Exception exception) {
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (Exception exception) {}
            }
            this.mLastDeadlockLogFile = file;
        }
    }

    private boolean isCameraAPIFreezed() {
        Map<Thread, StackTraceElement[]> stacksMap = Thread.getAllStackTraces();
        Set<Map.Entry<Thread, StackTraceElement[]>> entrySet = stacksMap.entrySet();
        for (Map.Entry<Thread, StackTraceElement[]> entry : entrySet) {
            StackTraceElement[] stacks = entry.getValue();
            if (stacks == null || stacks.length < 1 || !"android.hardware.Camera".equals(stacks[0].getClassName())) continue;
            return true;
        }
        return false;
    }

    private void printThreadsStacks(Thread detectorThread, PrintStream os) {
        Map<Thread, StackTraceElement[]> stacksMap = Thread.getAllStackTraces();
        Set<Map.Entry<Thread, StackTraceElement[]>> entrySet = stacksMap.entrySet();
        for (Map.Entry<Thread, StackTraceElement[]> entry : entrySet) {
            Thread thread = entry.getKey();
            if (thread.getId() == detectorThread.getId()) continue;
            StackTraceElement[] stacks = entry.getValue();
            this.printThreadStack(thread, stacks, os);
        }
    }

    private void printThreadStack(Thread thread, StackTraceElement[] stacks, PrintStream os) {
        os.println(thread.toString());
        for (StackTraceElement elem : stacks) {
            os.println(elem.toString());
        }
        os.println();
    }

    class DeadLockDetectorThread
    extends Thread {
        private long mLastDeadLockStartTime;

        public DeadLockDetectorThread() {
            super("DeadLockDetector");
            this.mLastDeadLockStartTime = 0L;
        }

        @Override
        public void run() {
            while (DeadLockDetector.this.mRunning) {
                try {
                    DeadLockDetectorThread.sleep(5000L);
                    DeadLockDetector.this.increaseCurrentTime(5000L);
                    if (JavaCrashHandler.hasJavaThreadCrashed() || Mainboard.isNativeCrashed()) {
                        DeadLockDetector.this.stop();
                        continue;
                    }
                    this.checkDeadLock();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private boolean isProcessAtFront() {
            ZMActivity frontActivity = ZMActivity.getFrontActivity();
            return frontActivity != null && frontActivity.isActive();
        }

        private void checkDeadLock() {
            long curTime = DeadLockDetector.this.getCurrentTime();
            if (!this.isProcessAtFront()) {
                DeadLockDetector.this.mLastHeartbeatTime = curTime;
                return;
            }
            if (curTime - DeadLockDetector.this.mLastHeartbeatTime > 30000L && DeadLockDetector.this.mLastHeartbeatTime != this.mLastDeadLockStartTime) {
                this.mLastDeadLockStartTime = DeadLockDetector.this.mLastHeartbeatTime;
                DeadLockDetector.this.onDeadLock(this);
            }
        }
    }
}

