/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sip.server;

import com.zipow.videobox.sip.server.ZoomAssistantIPCMessageUI;

public class ZoomAssistantIPCServer {
    private static ZoomAssistantIPCServer mInstance;
    private static long mPNativeServerHandle;

    public static boolean init(int pid) {
        if (mInstance != null) {
            return false;
        }
        mPNativeServerHandle = ZoomAssistantIPCServer.nativeInit(pid);
        if (mPNativeServerHandle == 0L) {
            return false;
        }
        mInstance = new ZoomAssistantIPCServer();
        return true;
    }

    public static void unInit() {
        ZoomAssistantIPCServer.nativeUninit();
        mPNativeServerHandle = 0L;
        mInstance = null;
    }

    public static boolean isInit() {
        return mPNativeServerHandle != 0L;
    }

    public void addMessageHandler(ZoomAssistantIPCMessageUI ui) {
        if (mPNativeServerHandle == 0L) {
            return;
        }
        if (ui == null) {
            return;
        }
        long nativeHandle = ui.getNativeHandle();
        if (nativeHandle == 0L) {
            return;
        }
        this.addMessageHandlerImpl(mPNativeServerHandle, nativeHandle);
    }

    public void removeMessageHandler(ZoomAssistantIPCMessageUI ui) {
        if (mPNativeServerHandle == 0L) {
            return;
        }
        if (ui == null) {
            return;
        }
        long nativeHandle = ui.getNativeHandle();
        if (nativeHandle == 0L) {
            return;
        }
        this.removeMessageHandlerImpl(mPNativeServerHandle, nativeHandle);
    }

    public static ZoomAssistantIPCServer getInstance() {
        if (mPNativeServerHandle == 0L) {
            return null;
        }
        return mInstance;
    }

    public void heartBeat() {
        if (mPNativeServerHandle == 0L) {
            return;
        }
        this.heartBeatImpl(mPNativeServerHandle);
    }

    public void sendAppStopMessage() {
        if (mPNativeServerHandle == 0L) {
            return;
        }
        this.sendAppStopMessageImpl(mPNativeServerHandle);
    }

    public boolean sendSIPRegistrarRequestMessage(String localIP, String serverIP, int protocol, String userName, String passWord, String authName, String displayName, String domain, String proxy, int registrationExpiry) {
        if (mPNativeServerHandle == 0L) {
            return false;
        }
        return this.sendSIPRegistrarRequestMessageImpl(mPNativeServerHandle, localIP, serverIP, protocol, userName, passWord, authName, displayName, domain, proxy, registrationExpiry);
    }

    public boolean sendSIPUnRegistrarRequestMessage() {
        if (mPNativeServerHandle == 0L) {
            return false;
        }
        return this.sendSIPUnRegistrarRequestMessageImpl(mPNativeServerHandle);
    }

    public boolean sendSIPResposeCallRequestMessage(String callID, int callAction, int reason) {
        if (mPNativeServerHandle == 0L) {
            return false;
        }
        return this.sendSIPResposeCallRequestMessageImpl(mPNativeServerHandle, callID, callAction, reason);
    }

    public boolean sendSIPCallPeerRequestMessage(String peerUri) {
        if (mPNativeServerHandle == 0L) {
            return false;
        }
        return this.sendSIPCallPeerRequestMessageImpl(mPNativeServerHandle, peerUri);
    }

    public boolean sendSIPMuteCallRequestMessage(String callID, boolean mute) {
        if (mPNativeServerHandle == 0L) {
            return false;
        }
        return this.sendSIPMuteCallRequestMessageImpl(mPNativeServerHandle, callID, mute);
    }

    public boolean sendSIPDTMFRequestMessage(String callID, String key) {
        if (mPNativeServerHandle == 0L) {
            return false;
        }
        return this.sendSIPDTMFRequestMessageImpl(mPNativeServerHandle, callID, key);
    }

    public boolean sendCECLoadRequestMessage() {
        if (mPNativeServerHandle == 0L) {
            return false;
        }
        return this.sendCECLoadRequestMessageImpl(mPNativeServerHandle);
    }

    public boolean sendCECUnloadRequestMessage() {
        if (mPNativeServerHandle == 0L) {
            return false;
        }
        return this.sendCECUnloadRequestMessageImpl(mPNativeServerHandle);
    }

    public boolean sendCECPowerOnRequestMessage() {
        if (mPNativeServerHandle == 0L) {
            return false;
        }
        return this.sendCECPowerOnRequestMessageImpl(mPNativeServerHandle);
    }

    public boolean sendCECStandByRequestMessage() {
        if (mPNativeServerHandle == 0L) {
            return false;
        }
        return this.sendCECStandByRequestMessageImpl(mPNativeServerHandle);
    }

    private static native long nativeInit(int var0);

    private static native void nativeUninit();

    private native void heartBeatImpl(long var1);

    private native void sendAppStopMessageImpl(long var1);

    private native boolean sendSIPRegistrarRequestMessageImpl(long var1, String var3, String var4, int var5, String var6, String var7, String var8, String var9, String var10, String var11, int var12);

    private native boolean sendSIPUnRegistrarRequestMessageImpl(long var1);

    private native boolean sendSIPResposeCallRequestMessageImpl(long var1, String var3, int var4, int var5);

    private native boolean sendSIPCallPeerRequestMessageImpl(long var1, String var3);

    private native boolean sendSIPMuteCallRequestMessageImpl(long var1, String var3, boolean var4);

    private native boolean sendSIPDTMFRequestMessageImpl(long var1, String var3, String var4);

    private native boolean sendCECLoadRequestMessageImpl(long var1);

    private native boolean sendCECUnloadRequestMessageImpl(long var1);

    private native boolean sendCECPowerOnRequestMessageImpl(long var1);

    private native boolean sendCECStandByRequestMessageImpl(long var1);

    private native void addMessageHandlerImpl(long var1, long var3);

    private native void removeMessageHandlerImpl(long var1, long var3);

    static {
        mPNativeServerHandle = 0L;
    }
}

