/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sip.server;

import com.zipow.videobox.sip.server.AssistantAppMgr;
import com.zipow.videobox.sip.server.SipCallManager;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class ZoomAssistantIPCMessageUI {
    private static final String TAG = ZoomAssistantIPCMessageUI.class.getSimpleName();
    private static ZoomAssistantIPCMessageUI instance = null;
    private ListenerList mListenerList = new ListenerList();
    private long mNativeHandle = 0L;

    public static synchronized ZoomAssistantIPCMessageUI getInstance() {
        if (instance == null) {
            instance = new ZoomAssistantIPCMessageUI();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    private ZoomAssistantIPCMessageUI() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        try {
            this.mNativeHandle = this.nativeInit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    protected void finalize() throws Throwable {
        if (this.mNativeHandle != 0L) {
            this.nativeUninit(this.mNativeHandle);
        }
        super.finalize();
    }

    public void addListener(IZoomAssistantIPCMessageUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IZoomAssistantIPCMessageUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IZoomAssistantIPCMessageUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    protected void HandleCECLoadResponseMessage(boolean result) {
        try {
            this.HandleCECLoadResponseMessageImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleCECLoadResponseMessageImpl(boolean result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleCECLoadResponseMessage(result);
            }
        }
    }

    protected void HandleCECUnloadResponseMessage(boolean result) {
        try {
            this.HandleCECUnloadResponseMessageImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleCECUnloadResponseMessageImpl(boolean result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleCECUnloadResponseMessage(result);
            }
        }
    }

    protected void HandleCECPowerOnResponseMessage(boolean result) {
        try {
            this.HandleCECPowerOnResponseMessageImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleCECPowerOnResponseMessageImpl(boolean result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleCECPowerOnResponseMessage(result);
            }
        }
    }

    protected void HandleCECStandbyResponseMessage(boolean result) {
        try {
            this.HandleCECStandbyResponseMessageImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleCECStandbyResponseMessageImpl(boolean result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleCECStandbyResponseMessage(result);
            }
        }
    }

    protected void HandleSIPRegistrarResponse(int result) {
        try {
            this.HandleSIPRegistrarResponseImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleSIPRegistrarResponseImpl(int result) {
        SipCallManager.getInstance().onSIPRegistrarResponse(result);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleSIPRegistrarResponse(result);
            }
        }
    }

    protected void HandleSIPOnRegistrarNotification(int result, int respCode, String respDescription) {
        try {
            this.HandleSIPOnRegistrarNotificationImpl(result, respCode, respDescription);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleSIPOnRegistrarNotificationImpl(int result, int respCode, String respDescription) {
        SipCallManager.getInstance().onSIPOnRegistrarNotification(result, respCode, respDescription);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleSIPOnRegistrarNotification(result, respCode, respDescription);
            }
        }
    }

    protected void HandleSIPConfigureAudioResponse(int result) {
        try {
            this.HandleSIPConfigureAudioResponseImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleSIPConfigureAudioResponseImpl(int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleSIPConfigureAudioResponse(result);
            }
        }
    }

    protected void HandleSIPResponseCallResponse(int result) {
        try {
            this.HandleSIPResponseCallResponseImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleSIPResponseCallResponseImpl(int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleSIPResponseCallResponse(result);
            }
        }
    }

    protected void HandleSIPCallPeerResponse(int result) {
        try {
            this.HandleSIPCallPeerResponseImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleSIPCallPeerResponseImpl(int result) {
        SipCallManager.getInstance().onCallPeer(result);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleSIPCallPeerResponse(result);
            }
        }
    }

    protected void HandleSIPMuteCallResponse(boolean muted) {
        try {
            this.HandleSIPMuteCallResponseImpl(muted);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleSIPMuteCallResponseImpl(boolean muted) {
        SipCallManager.getInstance().onMuteCall(muted);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleSIPMuteCallResponse(muted);
            }
        }
    }

    protected void HandleSIPDTMFResponse(int result) {
        try {
            this.HandleSIPDTMFResponseImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleSIPDTMFResponseImpl(int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleSIPDTMFResponse(result);
            }
        }
    }

    protected void HandleSIPOnCallStatusUpdateNotification(String callID, int status, String peerUri, String peerNumber, String peerDisplayName, boolean isIncomingCall) {
        try {
            this.HandleSIPOnCallStatusUpdateNotificationImpl(callID, status, peerUri, peerNumber, peerDisplayName, isIncomingCall);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleSIPOnCallStatusUpdateNotificationImpl(String callID, int status, String peerUri, String peerNumber, String peerDisplayName, boolean isIncomingCall) {
        SipCallManager.getInstance().OnCallStatusUpdate(callID, status, peerUri, peerNumber, peerDisplayName, isIncomingCall);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleSIPOnCallStatusUpdateNotification(callID, status, peerUri, peerNumber, peerDisplayName, isIncomingCall);
            }
        }
    }

    protected void HandleSIPOnCallTerminatedNotification(String callID, String peerUri, String peerNumber, String peerDisplayName, int reason, boolean isIncomingCall) {
        try {
            this.HandleSIPOnCallTerminatedNotificationImpl(callID, peerUri, peerNumber, peerDisplayName, reason, isIncomingCall);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleSIPOnCallTerminatedNotificationImpl(String callID, String peerUri, String peerNumber, String peerDisplayName, int reason, boolean isIncomingCall) {
        SipCallManager.getInstance().onCallTerminated(callID, peerUri, peerNumber, peerDisplayName, reason, isIncomingCall);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleSIPOnCallTerminatedNotification(callID, peerUri, peerNumber, peerDisplayName, reason, isIncomingCall);
            }
        }
    }

    protected void HandleSIPOnCallIncomingNotification(String callID, String peerUri, String peerNumber, String peerDisplayName, boolean needRing) {
        try {
            this.HandleSIPOnCallIncomingNotificationImpl(callID, peerUri, peerNumber, peerDisplayName, needRing);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleSIPOnCallIncomingNotificationImpl(String callID, String peerUri, String peerNumber, String peerDisplayName, boolean needRing) {
        SipCallManager.getInstance().onCallIncoming(callID, peerUri, peerNumber, peerDisplayName, needRing);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleSIPOnCallIncomingNotification(callID, peerUri, peerNumber, peerDisplayName, needRing);
            }
        }
    }

    protected void HandleSIPOnSIPServiceStatusChangedNotification(int status) {
        try {
            this.HandleSIPOnSIPServiceStatusChangedNotificationImpl(status);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleSIPOnSIPServiceStatusChangedNotificationImpl(int status) {
        SipCallManager.getInstance().OnSIPServiceStatusChanged(status);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleSIPOnSIPServiceStatusChangedNotification(status);
            }
        }
    }

    protected void OnChannelError() {
        try {
            this.OnChannelErrorImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnChannelErrorImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.OnChannelError();
            }
        }
    }

    protected void HandleAssistantProcessStart() {
        try {
            this.HandleAssistantProcessStartImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleAssistantProcessStartImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleAssistantProcessStart();
            }
        }
    }

    protected void HandleAssistantProcessStop() {
        try {
            this.HandleAssistantProcessStopImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void HandleAssistantProcessStopImpl() {
        AssistantAppMgr.getInstance().stopAssistantService();
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomAssistantIPCMessageUIListener l = (IZoomAssistantIPCMessageUIListener)lTmp;
                l.HandleAssistantProcessStop();
            }
        }
    }

    private native long nativeInit();

    private native void nativeUninit(long var1);

    public static abstract class SimpleZoomAssistantIPCMessageUIListener
    implements IZoomAssistantIPCMessageUIListener {
        @Override
        public void HandleCECLoadResponseMessage(boolean result) {
        }

        @Override
        public void HandleCECUnloadResponseMessage(boolean result) {
        }

        @Override
        public void HandleCECPowerOnResponseMessage(boolean result) {
        }

        @Override
        public void HandleCECStandbyResponseMessage(boolean result) {
        }

        @Override
        public void HandleSIPRegistrarResponse(int result) {
        }

        @Override
        public void HandleSIPOnRegistrarNotification(int result, int respCode, String respDescription) {
        }

        @Override
        public void HandleSIPConfigureAudioResponse(int result) {
        }

        @Override
        public void HandleSIPResponseCallResponse(int result) {
        }

        @Override
        public void HandleSIPCallPeerResponse(int result) {
        }

        @Override
        public void HandleSIPMuteCallResponse(boolean muted) {
        }

        @Override
        public void HandleSIPDTMFResponse(int result) {
        }

        @Override
        public void HandleSIPOnCallStatusUpdateNotification(String callID, int status, String peerUri, String peerNumber, String peerDisplayName, boolean isIncomingCall) {
        }

        @Override
        public void HandleSIPOnCallTerminatedNotification(String callID, String peerUri, String peerNumber, String peerDisplayName, int reason, boolean isIncomingCall) {
        }

        @Override
        public void HandleSIPOnCallIncomingNotification(String callID, String peerUri, String peerNumber, String peerDisplayName, boolean needRing) {
        }

        @Override
        public void HandleSIPOnSIPServiceStatusChangedNotification(int status) {
        }

        @Override
        public void OnChannelError() {
        }

        @Override
        public void HandleAssistantProcessStart() {
        }

        @Override
        public void HandleAssistantProcessStop() {
        }
    }

    public static interface IZoomAssistantIPCMessageUIListener
    extends IListener {
        public void HandleCECLoadResponseMessage(boolean var1);

        public void HandleCECUnloadResponseMessage(boolean var1);

        public void HandleCECPowerOnResponseMessage(boolean var1);

        public void HandleCECStandbyResponseMessage(boolean var1);

        public void HandleSIPRegistrarResponse(int var1);

        public void HandleSIPOnRegistrarNotification(int var1, int var2, String var3);

        public void HandleSIPConfigureAudioResponse(int var1);

        public void HandleSIPResponseCallResponse(int var1);

        public void HandleSIPCallPeerResponse(int var1);

        public void HandleSIPMuteCallResponse(boolean var1);

        public void HandleSIPDTMFResponse(int var1);

        public void HandleSIPOnCallStatusUpdateNotification(String var1, int var2, String var3, String var4, String var5, boolean var6);

        public void HandleSIPOnCallTerminatedNotification(String var1, String var2, String var3, String var4, int var5, boolean var6);

        public void HandleSIPOnCallIncomingNotification(String var1, String var2, String var3, String var4, boolean var5);

        public void HandleSIPOnSIPServiceStatusChangedNotification(int var1);

        public void OnChannelError();

        public void HandleAssistantProcessStart();

        public void HandleAssistantProcessStop();
    }
}

